package com.talpa.translation.session

import com.talpa.translation.State
import com.talpa.translation.TranslateType
import com.talpa.translation.context.TranslationContext
import com.talpa.translation.event.Event

/**
 * Create by chenjunsheng on 2020/4/23
 */
class TranslationSessionImpl :
    TranslationSession {

    private var state = State.INITIALIZE
    private var type = TranslateType.CAMERA_TRANSLATION
    private var context : TranslationContext? = null
    private var translationEvent: Event = Event.START_REQUEST_PERMISSION

    override fun getType() = type

    fun setType(type: TranslateType) {
        this.type = type
    }

    override fun getState() = state

    override fun setState(state: State) {
        this.state = state
    }

    override fun setContext(context: TranslationContext) {
        this.context = context
    }

    override fun getContext(): TranslationContext? {
        return context
    }

    override fun setEvent(event: Event) {
        translationEvent = event
    }

    override fun getEvent(): Event {
        return translationEvent
    }
}

object TranslationSessionFactory {

    fun buildDefaultSession() : TranslationSession {
        return TranslationSessionImpl()
            .apply {
                setState(State.INITIALIZE)
                setEvent(Event.START_REQUEST_PERMISSION)
                setType(TranslateType.CAMERA_TRANSLATION)
            }
    }
}