package com.talpa

import android.app.Activity
import android.content.Context
import androidx.annotation.Keep
import com.talpa.translate.activity.CameraActivity
import com.talpa.translate.base.BaseApp
import com.talpa.translate.base.screenshot.ScreenShotListenManager
import com.talpa.translate.base.utils.PT_enter
import com.talpa.translate.base.utils.logEvent

/**
 * Create by chenjunsheng on 2020/4/26
 */
@Keep
object TranslationController {

    const val SCREENSHOT_PATH = "screenshot_path"
    const val SCREENSHOT_ID = "screenshot_id"
    var serverAppKey: String? = null
    var serverAppSecret: String? = null
    var googleKey: String? = null
    var microsoftKey: String? = null
    private var initialized = false

    fun hasInitialized() = initialized

    /**
     * SDK初始化，要求传入serverAppKey和serverAppSecret
     * 可多次调用，建议在Application启动时调用
     * 方法内部仅做了赋值操作，没有其他耗时调用
     */
    @JvmStatic
    @JvmOverloads
    fun initialize(serverAppKey : String, serverAppSecret: String,
                   googleKey : String? = null, microsoftKey: String? = null) {
        initialized = true
        this.serverAppKey = serverAppKey
        this.serverAppSecret = serverAppSecret
        this.googleKey = googleKey
        this.microsoftKey = microsoftKey
    }

    /**
     * 启动CameraActivity进行拍照翻译，
     * 接口调用前请先确认是否有相机权限
     * 请用这个接口启动
     * 不要用startActivity的方式启动CameraActivity
     */
    @JvmOverloads
    @JvmStatic
    fun startCameraCollection(context: Activity, requestCode: Int = 0) {
        CameraActivity.start(context, requestCode)
        logEvent(PT_enter)
    }

    /**
     * 图片翻译
     * 图片由外部传入
     * @param context
     * @param screenShotPath 截图地址，需要传绝对路径
     */
    @JvmStatic
    @JvmOverloads
    fun startTranslateFromUri(context: Context, screenShotPath: String, id: Long) {
        CameraActivity.start(
            context = context,
            requestCode = 0,
            screenShotPath = screenShotPath,
            id = id
        )
    }

    /**
     * 截图翻译开关
     */
    @JvmStatic
    fun enableScreenShotTranslate(enable: Boolean) {
        if (enable) {
            ScreenShotListenManager.getInstance(BaseApp.appContext).startListen()
        } else {
            ScreenShotListenManager.getInstance(BaseApp.appContext).stopListen()
        }
    }
}