package com.talpa.translate.base

//import com.flurry.android.FlurryAgent
//import com.flurry.android.FlurryPerformance
import android.content.Context
import android.os.Looper
import android.util.Log
import android.view.LayoutInflater
import android.view.animation.BounceInterpolator
import com.flurry.android.FlurryConfig
import com.photo.translation.BuildConfig
import com.photo.translation.R
import com.talpa.TranslationController
import com.talpa.translate.base.screenshot.ScreenShotListenManager
import com.talpa.translate.base.trace.HiTranslateTrace
import com.talpa.translate.base.utils.PT_screen_shot_click
import com.talpa.translate.base.utils.logEvent
import com.talpa.translate.base.view.floatview.*
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.subjects.PublishSubject
import java.util.concurrent.TimeUnit


/**
 * Create by chenjunsheng on 2020/4/26
 */
object BaseApp {

    var floatWindow: IFloatWindow? = null
    lateinit var appContext: Context
    var serverKey : String? = null
    private val DEFAULT_KEY = "123transsion"

    fun initialize(context: Context) {
        appContext = context
        if (Looper.myLooper() == Looper.getMainLooper()) {
            initFloatingView(context)
            //initBackgourndKey()
            //initMMkv()
            Log.i("Photo_application", "init_version:${BuildConfig.VERSION_NAME}")
        }
    }

    /*private fun initMMkv() {
        try {
            MMKV.initialize(appContext)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }*/

    //后台通信key
    fun initBackgourndKey() {
        try {
            val flurryConfig = FlurryConfig.getInstance()
            serverKey = flurryConfig.getString("trans_server_key", DEFAULT_KEY)
        } catch (e: Exception) {
            serverKey = DEFAULT_KEY
        }
    }

    fun getTraceEvent() = HiTranslateTrace

    private fun initFloatingView(context: Context) {
        val screenShotManager = ScreenShotListenManager.getInstance(context)
        screenShotManager.setListener { imgPath, relativePath ->
            if (floatWindow == null) {

                val button = LayoutInflater.from(context)
                    .inflate(R.layout.layout_tap_overlay_view, null,false)
                //val button1 = ImageView(context!!)
                //button1.setImageResource(R.drawable.icon)

                floatWindow = FloatWindow
                    .with(context)
                    .setView(button)
                    .setWidth(Screen.width, 0.2f) //设置悬浮控件宽高
                    .setHeight(Screen.width, 0.2f)
                    .setX(Screen.width, 0.8f)
                    .setY(Screen.height, 0.3f)
                    .setMoveType(MoveType.slide, 10, 10)
                    .setMoveStyle(500, BounceInterpolator())
                    //.setFilter(true, CameraActivity::class.java)
                    .setViewStateListener(mViewStateListener)
                    .setPermissionListener(mPermissionListener)
                    .setDesktopShow(true)
                    .build()
            }

            floatWindow?.setOnclickListener {
                TranslationController.startTranslateFromUri(
                    context,
                    imgPath,
                    relativePath
                )
                floatWindow?.hide()
                logEvent(PT_screen_shot_click)
            }
            //floatWindow?.setTag(imgPath)
            Log.d("cjslog", "show")
            floatWindow?.show()
        }
        //screenShotManager.startListen()
    }

    val mPermissionListener: PermissionListener = object :
        PermissionListener {
        override fun onSuccess() {
            Log.d("cjslog", "on success")
        }

        override fun onFail() {
            Log.d("cjslog", "on fail")
        }

    }

    val mViewStateListener: ViewStateListener = object :
        ViewStateListener {

        val subject = PublishSubject.create<Boolean>()

        init {
            subject.debounce(5, TimeUnit.SECONDS, AndroidSchedulers.mainThread())
                //.subscribeOn(AndroidSchedulers.mainThread())
                .subscribe {
                    Log.d("cjslog", "on hide")
                    floatWindow?.hide()
                }
        }

        override fun onBackToDesktop() {
            Log.d("cjslog", "onBackToDesktop")
        }

        override fun onMoveAnimStart() {
            Log.d("cjslog", "onMoveAnimStart")
        }

        override fun onMoveAnimEnd() {
            Log.d("cjslog", "onMoveAnimEnd")
            subject.onNext(true)
        }

        override fun onPositionUpdate(x: Int, y: Int) {
            //Log.d("cjslog", "onPositionUpdate")
            subject.onNext(true)
        }

        override fun onDismiss() {
            Log.d("cjslog", "onDismiss")
        }

        override fun onShow() {
            Log.d("cjslog", "onShow")
            subject.onNext(true)
        }

        override fun onHide() {
            Log.d("cjslog", "onHide")
        }

    }
}