package com.talpa.translate.base.utils

import android.content.Context
import android.graphics.*
import android.net.ConnectivityManager
import android.os.Environment
import android.os.StatFs
import java.io.File
import java.security.MessageDigest
import java.security.NoSuchAlgorithmException
import java.text.SimpleDateFormat
import java.util.*


/**
 * Create by chenjunsheng on 2020/4/27
 */

private const val RATIO_4_3_VALUE = 4.0 / 3.0
private const val RATIO_16_9_VALUE = 16.0 / 9.0

const val PREFER_KEY_SOURCE_LANG = "key_source_lang"
const val PREFER_NAME = "prefer_camera"

const val MAX_TEXT_SIZE_PX = 160
const val MIN_TEXT_SIZE_PX = 12

/**
 * Release origin image by translation bitmap
 */

/**
 *  [androidx.camera.core.ImageAnalysisConfig] requires enum value of
 *  [androidx.camera.core.AspectRatio]. Currently it has values of 4:3 & 16:9.
 *
 *  Detecting the most suitable ratio for dimensions provided in @params by counting absolute
 *  of preview ratio to one of the provided values.
 *
 *  @param width - preview width
 *  @param height - preview height
 *  @return suitable aspect ratio
 */
/*fun aspectRatio(width: Int, height: Int): Int {
    val previewRatio = max(width, height).toDouble() / min(width, height)
    if (abs(previewRatio - RATIO_4_3_VALUE) <= abs(previewRatio - RATIO_16_9_VALUE)) {
        return AspectRatio.RATIO_4_3
    }
    return AspectRatio.RATIO_16_9
}*/

/**
 * Save Language Tag
 */
fun saveLanguage(
    context: Context,
    preferKey: String = PREFER_KEY_SOURCE_LANG,
    value: String
) {
    val prefer = context.getSharedPreferences(PREFER_NAME, Context.MODE_PRIVATE)
    prefer.edit().putString(preferKey, value).apply()
    //val mmkv = MMKV.defaultMMKV()
    //mmkv.encode(preferKey, value)
}

fun Context.isNetworkConnected(): Boolean {
    val connectivityManager =
        getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

    val networkInfo = connectivityManager.activeNetworkInfo
    return networkInfo?.isAvailable == true && networkInfo.isConnected
}

fun crypt(str: String): String {
    if (str.isEmpty()) {
        return ""
    }
    val hexString = StringBuffer()
    try {
        val md = MessageDigest.getInstance("MD5")
        md.update(str.toByteArray())

        val hash = md.digest()

        repeat(hash.size) {
            if ((0xff and hash[it].toInt()) < 0x10) {
                hexString.append("0" + Integer.toHexString((0xFF and hash[it].toInt())))
            } else {
                hexString.append(Integer.toHexString(0xFF and hash[it].toInt()))
            }
        }
    } catch (e: NoSuchAlgorithmException) {
        e.printStackTrace()
    }
    return hexString.toString()
}

fun isSDCardEnable(): Boolean {
    return Environment.MEDIA_MOUNTED == Environment.getExternalStorageState()
}

fun getFreeSpace(): Long {
    if (!isSDCardEnable()) {
        return -1
    }
    val stat = StatFs(Environment.getExternalStorageDirectory().path)
    val blockSize = stat.blockSizeLong
    val availableBlocks = stat.availableBlocksLong
    val size = availableBlocks * blockSize / 1024L
    return size
}

/**
 * Create Photo File
 */
fun createPhotoFile(context: Context): File {

    val baseDir: File = context.externalMediaDirs.firstOrNull() ?: context.filesDir

    if (!baseDir.exists()) {
        baseDir.mkdirs()
    }

    val pattern = "yyyy-MM-dd-HH-mm-ss"

    val extension = ".jpg"

    val dateFormat =
        SimpleDateFormat(pattern, Locale.US).format(System.currentTimeMillis())

    val fileName = "$dateFormat$extension"

    return File(baseDir, fileName)
}

fun Context.navigationBarHeight(): Int {
    val resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android")
    val height = resources.getDimensionPixelSize(resourceId)
    //Log.v("dbw", "Navi height:" + height);
    return height
}

fun drawTextToBitmap(bitmap: Bitmap, context: Context, text: String): Bitmap {
    val scale = context.resources.displayMetrics.density
    var bitmapConfig = bitmap.config
    if (bitmapConfig == null) {
        bitmapConfig = Bitmap.Config.ARGB_8888
    }
    val newBitmap = bitmap.copy(bitmapConfig, true)
    val canvas = Canvas(newBitmap)
    val paint = Paint(Paint.ANTI_ALIAS_FLAG)
        .also {
            it.color = Color.BLACK
            it.textSize = (12 * scale)
            it.setShadowLayer(1f, 0f, 1f, Color.WHITE)
        }
    val bounds = Rect()
    paint.getTextBounds(text, 0, text.length, bounds)
    val x: Int = (bitmap.width - bounds.width()) / 2
    val y: Int = (bitmap.height + bounds.height()) / 2
    canvas.drawText(text, x.toFloat(), y.toFloat(), paint)

    return newBitmap
}