package com.talpa.translate.base.view.floatview

import android.content.Context
import android.content.res.Configuration
import android.content.res.Resources
import android.graphics.Point
import android.util.AttributeSet
import android.util.TypedValue
import android.view.WindowManager
import androidx.constraintlayout.widget.ConstraintLayout
import com.talpa.translate.base.BaseApp

/**
 * Create by chenjunsheng on 2020/5/11
 */
class TapOverlayView : ConstraintLayout {

    constructor(context: Context) : super(context)
    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    override fun onConfigurationChanged(newConfig: Configuration?) {
        super.onConfigurationChanged(newConfig)

        val point = overlayViewDefaultPoint()
        updateViewLayout(point.x, point.y)
    }

    /**
     * 悬浮视图默认位置
     */
    private fun overlayViewDefaultPoint(): Point {
        val outSize = Point()

        val windowManager = BaseApp.appContext
            .getSystemService(Context.WINDOW_SERVICE) as WindowManager
        val display = windowManager.defaultDisplay

        display.getSize(outSize)

        val x = outSize.x - overlayViewDefaultWidth()
        val y = (outSize.y - overlayViewDefaultHeight()) / 5 * 2

        outSize.set(x.toInt(), y.toInt())
        return outSize
    }

    /**
     * 悬浮视图默认宽
     */
    private fun overlayViewDefaultWidth() = dp2px(100f)

    /**
     * 悬浮视图默认高
     */
    private fun overlayViewDefaultHeight() = dp2px(100F)

    /*
      --------- 滚动变化方法同监听器方法（适用于子类） ------
     */
    /**
     * dp转换px
     *
     * @param dp dp值
     * @return 转换后的px值
     */
        protected fun dp2px(dp: Float): Float {
        return TypedValue.applyDimension(
            TypedValue.COMPLEX_UNIT_DIP,
            dp,
            Resources.getSystem().displayMetrics
        )
    }

    /**
     * 更新视图位置
     */
    private fun updateViewLayout(x: Int, y: Int) {

        val params = layoutParams as WindowManager.LayoutParams
        params.x = x
        params.y = y
        try {
            val windowManager = context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
            windowManager.updateViewLayout(this, params)
        } catch (e: Throwable) {
            e.printStackTrace()
        }

    }

}