package com.talpa.translate.camera.view.filter;

import androidx.annotation.NonNull;

import com.talpa.translate.camera.view.filters.AutoFixFilter;
import com.talpa.translate.camera.view.filters.BlackAndWhiteFilter;
import com.talpa.translate.camera.view.filters.BrightnessFilter;
import com.talpa.translate.camera.view.filters.ContrastFilter;
import com.talpa.translate.camera.view.filters.CrossProcessFilter;
import com.talpa.translate.camera.view.filters.DocumentaryFilter;
import com.talpa.translate.camera.view.filters.DuotoneFilter;
import com.talpa.translate.camera.view.filters.FillLightFilter;
import com.talpa.translate.camera.view.filters.GammaFilter;
import com.talpa.translate.camera.view.filters.GrainFilter;
import com.talpa.translate.camera.view.filters.GrayscaleFilter;
import com.talpa.translate.camera.view.filters.HueFilter;
import com.talpa.translate.camera.view.filters.InvertColorsFilter;
import com.talpa.translate.camera.view.filters.LomoishFilter;
import com.talpa.translate.camera.view.filters.PosterizeFilter;
import com.talpa.translate.camera.view.filters.SaturationFilter;
import com.talpa.translate.camera.view.filters.SepiaFilter;
import com.talpa.translate.camera.view.filters.SharpnessFilter;
import com.talpa.translate.camera.view.filters.TemperatureFilter;
import com.talpa.translate.camera.view.filters.TintFilter;
import com.talpa.translate.camera.view.filters.VignetteFilter;

/**
 * Contains commonly used {@link Filter}s.
 *
 * You can use {@link #newInstance()} to create a new instance and
 * pass it to {@link com.talpa.cameraview.CameraView#setFilter(Filter)}.
 */
public enum Filters {

    /** @see NoFilter */
    NONE(NoFilter.class),

    /** @see AutoFixFilter */
    AUTO_FIX(AutoFixFilter.class),

    /** @see BlackAndWhiteFilter */
    BLACK_AND_WHITE(BlackAndWhiteFilter.class),

    /** @see BrightnessFilter */
    BRIGHTNESS(BrightnessFilter.class),

    /** @see ContrastFilter */
    CONTRAST(ContrastFilter.class),

    /** @see CrossProcessFilter */
    CROSS_PROCESS(CrossProcessFilter.class),

    /** @see DocumentaryFilter */
    DOCUMENTARY(DocumentaryFilter.class),

    /** @see DuotoneFilter */
    DUOTONE(DuotoneFilter.class),

    /** @see FillLightFilter */
    FILL_LIGHT(FillLightFilter.class),

    /** @see GammaFilter */
    GAMMA(GammaFilter.class),

    /** @see GrainFilter */
    GRAIN(GrainFilter.class),

    /** @see GrayscaleFilter */
    GRAYSCALE(GrayscaleFilter.class),

    /** @see HueFilter */
    HUE(HueFilter.class),

    /** @see InvertColorsFilter */
    INVERT_COLORS(InvertColorsFilter.class),

    /** @see LomoishFilter */
    LOMOISH(LomoishFilter.class),

    /** @see PosterizeFilter */
    POSTERIZE(PosterizeFilter.class),

    /** @see SaturationFilter */
    SATURATION(SaturationFilter.class),

    /** @see SepiaFilter */
    SEPIA(SepiaFilter.class),

    /** @see SharpnessFilter */
    SHARPNESS(SharpnessFilter.class),

    /** @see TemperatureFilter */
    TEMPERATURE(TemperatureFilter.class),

    /** @see TintFilter */
    TINT(TintFilter.class),

    /** @see VignetteFilter */
    VIGNETTE(VignetteFilter.class);

    private Class<? extends Filter> filterClass;

    Filters(@NonNull Class<? extends Filter> filterClass) {
        this.filterClass = filterClass;
    }

    /**
     * Returns a new instance of the given filter.
     * @return a new instance
     */
    @NonNull
    public Filter newInstance() {
        try {
            return filterClass.newInstance();
        } catch (IllegalAccessException e) {
            return new NoFilter();
        } catch (InstantiationException e) {
            return new NoFilter();
        }
    }
}
