package com.talpa.translate.ocr

import android.content.Context
import android.graphics.Bitmap
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.liveData
import com.photo.translation.R
import com.talpa.translate.base.common.FrameMetadata
import com.talpa.translate.factory.TranslatorFactory
import com.talpa.translate.network.HiTranslator
import com.talpa.translate.ocr.exception.NoContentException
import kotlinx.coroutines.Dispatchers


/**
 * Photo Translation
 *
 * @author CY 2020-02-05
 */
class ImageTranslate constructor(private val context: Context) {

    companion object {
        const val TAG = "ocr_translate"
    }

    private val mTranslator: Translator = TranslatorFactory.getTranslator(context)
    private val mRender = TranslatorFactory.getRender(context)

    /*private fun getTransRequest(sourceLanguage: String, targetLanguage: String, text: List<String>) : Trans {
        val map = languageTagToLangMap()

        val source = if (sourceLanguage == LANG.AUTO) {
            sourceLanguage
        } else {
            map[sourceLanguage] ?: "en"
        }

        val target = map[targetLanguage] ?: "en"
        Log.d(TAG, "start_trans: source_lan:${source}, target_lan:${target}")
        return Trans(from = source, to = target, text = *//*text*//*"")
    }*/

    /**
     * 翻译
     */
    fun translate(bitmap: Bitmap, metadata: FrameMetadata?, sourceLanguage: String, targetLanguage: String): LiveData<Result<Bitmap>> {
        mTranslator.setup(bitmap, checkNotNull(metadata))
        return liveData(Dispatchers.IO) {

                try {
                    val ocrResult = mTranslator.doOcr(targetLanguage)

                    val texts = arrayListOf<String>()
                    ocrResult.blocks.forEach {
                        texts.add(it.text)
                    }

                    val transResult = HiTranslator.getInstance()
                        .postTranslate(from = sourceLanguage, to = targetLanguage, tests = texts)
                        ?: throw NoContentException(
                            context.getString(R.string.translate_fail)
                        )


                    val textsResponse = transResult.result?.texts ?: throw NoContentException(
                        context.getString(R.string.translate_fail)
                    )
                    if (textsResponse.isEmpty()) throw NoContentException(
                        context.getString(R.string.no_trans_for_ocr)
                    )

                    /*val transResult = context.translate(
                        getTransRequest(sourceLanguage, targetLanguage, texts)
                    ).blockingSingle().result*/
                    val result = mRender.renderOverlay(mTranslator, textsResponse) ?: throw NoContentException(
                        context.getString(R.string.generate_bitmap_fail)
                    )
                    emit(Result.success(result))
                } catch (e: Exception) {
                    Log.d("cjslog", "e:", e)
                    emit(Result.failure(e))
                    return@liveData
                }
        }
    }

    fun changeLanguage(sourceLanguage: String, targetLanguage: String): LiveData<Result<Bitmap>> {
        return liveData (Dispatchers.IO) {
            mTranslator.getHistory()?.let {
                try {
                    val texts = arrayListOf<String>()
                    it.blocks.forEach { block->
                        texts.add(block.text)
                    }
                    val transResult = HiTranslator.getInstance()
                        .postTranslate(from = sourceLanguage, to = targetLanguage, tests = texts)
                        ?: throw NoContentException(
                            context.getString(R.string.translate_fail)
                        )


                    val textsResponse = transResult.result?.texts ?: throw NoContentException(
                        context.getString(R.string.translate_fail)
                    )
                    if (textsResponse.isEmpty()) throw NoContentException(
                        context.getString(R.string.no_trans_for_ocr)
                    )
                    val result = mRender.renderOverlay(mTranslator, textsResponse) ?: throw NoContentException(
                        context.getString(R.string.generate_bitmap_fail)
                    )

                    emit(Result.success(result))
                } catch (e: Exception) {
                    e.printStackTrace()
                    emit(Result.failure(e))
                }

            }
        }
    }


}