package com.talpa.translate.ocr.result

import android.graphics.Point
import android.graphics.Rect

/**
 * Create by chenjunsheng on 2020/7/14
 */
data class OcrResult(val blocks: List<Block>)

data class Block(val text: String, val rect: Rect, val points: Array<Point>) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Block

        if (text != other.text) return false
        if (rect != other.rect) return false
        if (!points.contentEquals(other.points)) return false

        return true
    }

    override fun hashCode(): Int {
        var result = text.hashCode()
        result = 31 * result + rect.hashCode()
        result = 31 * result + points.contentHashCode()
        return result
    }
}