package com.talpa.translate.ocr

import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Base64
import java.io.ByteArrayOutputStream


/**
 * Create by chenjunsheng on 2020/8/3
 * 适配6.0以下版本，不加载so
 */
class PhotoAnalyzerCompat : IAnalyzer {

    private var mOriginBitmap: Bitmap? = null

    override fun initialize(bitmap: Bitmap) {
        mOriginBitmap = bitmap
    }

    override fun cleanUp() {
        mOriginBitmap?.recycle()
        mOriginBitmap = null
    }

    override fun postAnalyzeArea(rects: Array<Rect>): Bitmap? {
        return mOriginBitmap
    }

    override fun getBase64String(): String? {
        return ByteArrayOutputStream().use {
            mOriginBitmap?.compress(Bitmap.CompressFormat.JPEG, 100, it)
            val imgBytes: ByteArray = it.toByteArray()
            Base64.encodeToString(imgBytes, Base64.DEFAULT)
        }


    }
}