package com.talpa.translate.ocr.datasource

import android.graphics.Bitmap
import com.talpa.translate.base.common.FrameMetadata

/**
 * Create by chenjunsheng on 2020/7/29
 */
class GoogleDataSource(var bitmap: Bitmap, private var sourceBase64: String?, var metadata: FrameMetadata, val targetLanguage: String) : DataSource {


    override fun getSourceBitmap() = bitmap

    override fun getBase64() = sourceBase64

    override fun getMetaData() = metadata

    override fun getRecognizeLanguage(): String {
        return targetLanguage
    }
}