package com.talpa.translate.render

import android.graphics.Bitmap
import com.talpa.translate.base.common.FrameMetadata
import com.talpa.translate.ocr.Recognizer
import com.talpa.translate.ocr.datasource.DataSource

/**
 * Create by chenjunsheng on 2020/7/14
 */
interface Render {

    suspend fun renderOverlay(translator: Recognizer, transResult: List<String>) : Bitmap?

    fun getBase64FromRender() : String?

    fun createDataSource(bitmap: Bitmap, type: Int, metadata: FrameMetadata, targetLanguage: String) : DataSource

    fun initialize(originalBitmap: Bitmap)

    fun release()
}