/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.draw;

import android.graphics.RectF;
import android.opengl.GLES20;
import androidx.annotation.Px;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.surface.opengl.draw.Gl2dDrawable;
import com.talpa.translate.camera.surface.opengl.extensions.BuffersKt;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0014J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\b\b\u0001\u0010\u001f\u001a\u00020\u001aJ.\u0010\u001e\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001a2\b\b\u0001\u0010#\u001a\u00020\u001aJ\u000e\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&J&\u0010$\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lcom/talpa/translate/camera/surface/opengl/draw/GlRoundRect;", "Lcom/talpa/translate/camera/surface/opengl/draw/Gl2dDrawable;", "()V", "bottom", "", "bottomLeftCorner", "bottomRightCorner", "left", "right", "top", "topLeftCorner", "topRightCorner", "vertexArray", "Ljava/nio/FloatBuffer;", "getVertexArray", "()Ljava/nio/FloatBuffer;", "setVertexArray", "(Ljava/nio/FloatBuffer;)V", "addCornerArc", "", "array", "pivotX", "pivotY", "width", "height", "startAngle", "", "draw", "onViewportSizeChanged", "recompute", "setCornersPx", "corners", "topLeft", "topRight", "bottomLeft", "bottomRight", "setRect", "rect", "Landroid/graphics/RectF;", "Companion", "translation_hitranslateRelease"})
public class GlRoundRect
extends Gl2dDrawable {
    private float topLeftCorner;
    private float topRightCorner;
    private float bottomLeftCorner;
    private float bottomRightCorner;
    private float top = 1.0f;
    private float bottom = -1.0f;
    private float left = -1.0f;
    private float right = 1.0f;
    @NotNull
    private FloatBuffer vertexArray = BuffersKt.floatBufferOf(82 * this.getCoordsPerVertex());
    private static final int POINTS_PER_CORNER = 20;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public FloatBuffer getVertexArray() {
        return this.vertexArray;
    }

    @Override
    public void setVertexArray(@NotNull FloatBuffer floatBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)floatBuffer, (String)"<set-?>");
        this.vertexArray = floatBuffer;
    }

    public final void setCornersPx(@Px int corners) {
        this.setCornersPx(corners, corners, corners, corners);
    }

    public final void setCornersPx(@Px int topLeft, @Px int topRight, @Px int bottomLeft, @Px int bottomRight) {
        this.topLeftCorner = topLeft;
        this.topRightCorner = topRight;
        this.bottomLeftCorner = bottomLeft;
        this.bottomRightCorner = bottomRight;
        this.recompute();
    }

    public final void setRect(@NotNull RectF rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        this.setRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public final void setRect(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.recompute();
    }

    @Override
    protected void onViewportSizeChanged() {
        super.onViewportSizeChanged();
        this.recompute();
    }

    private final void recompute() {
        boolean hasBottomLeftCorner;
        boolean hasBottomRightCorner;
        boolean hasTopRightCorner;
        boolean hasTopLeftCorner;
        FloatBuffer array = this.getVertexArray();
        array.clear();
        float centerX = (this.right + this.left) / 2.0f;
        float centerY = (this.top + this.bottom) / 2.0f;
        array.put(centerX);
        array.put(centerY);
        boolean hasCorners = this.getViewportHeight() > 0 && this.getViewportWidth() > 0;
        boolean bl = hasTopLeftCorner = hasCorners && this.topLeftCorner > 0.0f;
        if (hasTopLeftCorner) {
            float cornerWidth = this.topLeftCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.topLeftCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.left + cornerWidth;
            float cornerPivotY = this.top - cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, 180);
        } else {
            array.put(this.left);
            array.put(this.top);
        }
        boolean bl2 = hasTopRightCorner = hasCorners && this.topRightCorner > 0.0f;
        if (hasTopRightCorner) {
            float cornerWidth = this.topRightCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.topRightCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.right - cornerWidth;
            float cornerPivotY = this.top - cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, 90);
        } else {
            array.put(this.right);
            array.put(this.top);
        }
        boolean bl3 = hasBottomRightCorner = hasCorners && this.bottomRightCorner > 0.0f;
        if (hasBottomRightCorner) {
            float cornerWidth = this.bottomRightCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.bottomRightCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.right - cornerWidth;
            float cornerPivotY = this.bottom + cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, 0);
        } else {
            array.put(this.right);
            array.put(this.bottom);
        }
        boolean bl4 = hasBottomLeftCorner = hasCorners && this.bottomLeftCorner > 0.0f;
        if (hasBottomLeftCorner) {
            float cornerWidth = this.bottomLeftCorner / (float)this.getViewportWidth() * 2.0f;
            float cornerHeight = this.bottomLeftCorner / (float)this.getViewportHeight() * 2.0f;
            float cornerPivotX = this.left + cornerWidth;
            float cornerPivotY = this.bottom + cornerHeight;
            this.addCornerArc(array, cornerPivotX, cornerPivotY, cornerWidth, cornerHeight, -90);
        } else {
            array.put(this.left);
            array.put(this.bottom);
        }
        array.put(array.get(2));
        array.put(array.get(3));
        array.flip();
        this.notifyVertexArrayChange();
    }

    private final void addCornerArc(FloatBuffer array, float pivotX, float pivotY, float width, float height, int startAngle) {
        int endAngle = startAngle - 90;
        int points = 20;
        float t = 0.0f;
        float tDelta = 1.0f / (float)(points - 1);
        boolean bl = false;
        int n = 0;
        n = 0;
        int n2 = points;
        while (n < n2) {
            float radius;
            int it = n++;
            boolean bl2 = false;
            float angle = (float)startAngle + t * (float)(endAngle - startAngle);
            float radians = (float)((double)angle * Math.PI / (double)180);
            float f = width;
            float f2 = width * height;
            boolean bl3 = false;
            float f3 = (float)Math.sin(radians);
            float f4 = f * f3;
            int n3 = 2;
            boolean bl4 = false;
            f = (float)Math.pow(f4, n3);
            f3 = height;
            boolean bl5 = false;
            float f5 = (float)Math.cos(radians);
            float f6 = f3 * f5;
            n3 = 2;
            bl4 = false;
            f3 = (float)Math.pow(f6, n3);
            f6 = f + f3;
            n3 = 0;
            f = (float)Math.sqrt(f6);
            f3 = radius = f2 / f;
            f = pivotX;
            FloatBuffer floatBuffer = array;
            bl3 = false;
            f5 = (float)Math.cos(radians);
            floatBuffer.put(f + f3 * f5);
            f3 = radius;
            f = pivotY;
            floatBuffer = array;
            bl3 = false;
            f5 = (float)Math.sin(radians);
            floatBuffer.put(f + f3 * f5);
            t += tDelta;
        }
    }

    @Override
    public void draw() {
        GLES20.glDrawArrays((int)6, (int)0, (int)this.getVertexCount());
        Egloo.checkGlError("glDrawArrays");
    }

    public GlRoundRect() {
        this.recompute();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/talpa/translate/camera/surface/opengl/draw/GlRoundRect$Companion;", "", "()V", "POINTS_PER_CORNER", "", "translation_hitranslateRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

