/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.util.Log;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.vision.v1.Vision;
import com.google.api.services.vision.v1.VisionRequest;
import com.google.api.services.vision.v1.VisionRequestInitializer;
import com.google.api.services.vision.v1.model.AnnotateImageRequest;
import com.google.api.services.vision.v1.model.AnnotateImageResponse;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse;
import com.google.api.services.vision.v1.model.BoundingPoly;
import com.google.api.services.vision.v1.model.Feature;
import com.google.api.services.vision.v1.model.Image;
import com.google.api.services.vision.v1.model.Page;
import com.google.api.services.vision.v1.model.Paragraph;
import com.google.api.services.vision.v1.model.Symbol;
import com.google.api.services.vision.v1.model.Vertex;
import com.google.api.services.vision.v1.model.Word;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.ocr.Recognizer;
import com.talpa.translate.ocr.datasource.DataSource;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0010\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u0016\u0010\b\u001a\n0\tR\u00060\nR\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcom/talpa/translate/ocr/GoogleRecognizer;", "Lcom/talpa/translate/ocr/Recognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "setContext", "mAnnotateRequest", "Lcom/google/api/services/vision/v1/Vision$Images$Annotate;", "Lcom/google/api/services/vision/v1/Vision$Images;", "Lcom/google/api/services/vision/v1/Vision;", "mDataSource", "Lcom/talpa/translate/ocr/datasource/DataSource;", "mHistory", "Lcom/talpa/translate/ocr/result/OcrResult;", "doOcr", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFrameMetadata", "Lcom/talpa/translate/base/common/FrameMetadata;", "getHistory", "getType", "", "setup", "", "dataSource", "Companion", "translation_hitranslateRelease"})
public final class GoogleRecognizer
implements Recognizer {
    private DataSource mDataSource;
    private Vision.Images.Annotate mAnnotateRequest;
    private OcrResult mHistory;
    @NotNull
    private Context context;
    @NotNull
    public static final String ANDROID_PACKAGE_HEADER = "X-Android-Package";
    @NotNull
    public static final String ANDROID_CERT_HEADER = "X-Android-Cert";
    @NotNull
    public static final String TAG = "Recognizer";
    public static final Companion Companion = new Companion(null);

    @Override
    public void setup(@NotNull DataSource dataSource) {
        AnnotateImageRequest annotateImageRequest;
        Feature feature;
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        this.mDataSource = dataSource;
        NetHttpTransport httpTransport = new NetHttpTransport();
        GsonFactory gsonFactory = GsonFactory.getDefaultInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)gsonFactory, (String)"GsonFactory.getDefaultInstance()");
        JsonFactory jsonFactory = (JsonFactory)gsonFactory;
        VisionRequestInitializer requestInitializer2 = new VisionRequestInitializer(this, "AIzaSyCtWmgM8o6XImuJOMFav_bEMmkeES9Acwc"){
            final /* synthetic */ GoogleRecognizer this$0;

            protected void initializeVisionRequest(@NotNull VisionRequest<?> visionRequest) throws IOException {
                Intrinsics.checkParameterIsNotNull(visionRequest, (String)"visionRequest");
                super.initializeVisionRequest(visionRequest);
                String string = this.this$0.getContext().getPackageName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.packageName");
                String packageName = string;
                visionRequest.getRequestHeaders().set("X-Android-Package", (Object)packageName);
                PackageManager packageManager = this.this$0.getContext().getPackageManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)packageManager, (String)"context.packageManager");
                String sig = UtilsKt.getSignature(packageManager, packageName);
                visionRequest.getRequestHeaders().set("X-Android-Cert", (Object)sig);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        Vision.Builder builder = new Vision.Builder((HttpTransport)httpTransport, jsonFactory, null);
        builder.setVisionRequestInitializer(requestInitializer2);
        Vision vision = builder.build();
        BatchAnnotateImagesRequest batchAnnotateImagesRequest = new BatchAnnotateImagesRequest();
        boolean bl = false;
        boolean bl2 = false;
        BatchAnnotateImagesRequest $this$apply = batchAnnotateImagesRequest;
        boolean bl3 = false;
        AnnotateImageRequest annotateImageRequest2 = new AnnotateImageRequest();
        int n = 0;
        Object[] objectArray3 = objectArray2 = new AnnotateImageRequest[1];
        BatchAnnotateImagesRequest batchAnnotateImagesRequest2 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        AnnotateImageRequest imageRequest = annotateImageRequest2;
        boolean bl6 = false;
        Image base64EncodedImage = new Image();
        String string = dataSource.getBase64();
        if (string == null) {
            string = "";
        }
        base64EncodedImage.setContent(string);
        imageRequest.setImage(base64EncodedImage);
        Feature feature2 = new Feature();
        int n2 = 0;
        Object[] objectArray4 = objectArray = new Feature[1];
        AnnotateImageRequest annotateImageRequest3 = imageRequest;
        boolean bl7 = false;
        boolean bl8 = false;
        Feature feature3 = feature2;
        boolean bl9 = false;
        feature3.setType("TEXT_DETECTION");
        objectArray[n2] = feature = feature2;
        annotateImageRequest3.setFeatures((List)CollectionsKt.arrayListOf((Object[])objectArray4));
        objectArray2[n] = annotateImageRequest = annotateImageRequest2;
        batchAnnotateImagesRequest2.setRequests((List)CollectionsKt.arrayListOf((Object[])objectArray3));
        BatchAnnotateImagesRequest batchAnnotateImagesRequest3 = batchAnnotateImagesRequest;
        Vision.Images.Annotate annotate = vision.images().annotate(batchAnnotateImagesRequest3);
        Intrinsics.checkExpressionValueIsNotNull((Object)annotate, (String)"vision.images().annotate\u2026tchAnnotateImagesRequest)");
        Vision.Images.Annotate annotate2 = this.mAnnotateRequest = annotate;
        if (annotate2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAnnotateRequest");
        }
        annotate2.setDisableGZipContent(true);
        Log.d((String)"cjslog", (String)"created Cloud Vision request object, sending request");
    }

    @Override
    @Nullable
    public Object doOcr(@NotNull Continuation<? super OcrResult> $completion) {
        Log.d((String)TAG, (String)"start google ocr");
        Vision.Images.Annotate annotate = this.mAnnotateRequest;
        if (annotate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mAnnotateRequest");
        }
        Object object = annotate.execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mAnnotateRequest.execute()");
        BatchAnnotateImagesResponse response = (BatchAnnotateImagesResponse)object;
        boolean bl = false;
        ArrayList<Block> blocks = new ArrayList<Block>();
        Log.d((String)"cjslog", (String)("response:" + response.size()));
        List list = response.getResponses();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotateImageResponse it = (AnnotateImageResponse)element$iv;
                boolean bl2 = false;
                AnnotateImageResponse annotateImageResponse = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotateImageResponse, (String)"it");
                Object object2 = annotateImageResponse.getFullTextAnnotation();
                if (object2 == null || (object2 = object2.getPages()) == null) continue;
                Iterable $this$forEach$iv2 = (Iterable)object2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Page page = (Page)element$iv2;
                    boolean bl3 = false;
                    Page page2 = page;
                    Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"page");
                    List list2 = page2.getBlocks();
                    if (list2 != null) {
                        Iterable $this$forEach$iv3 = list2;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            String text;
                            Rect rect;
                            FrameMetadata metadata;
                            com.google.api.services.vision.v1.model.Block block = (com.google.api.services.vision.v1.model.Block)element$iv3;
                            boolean bl4 = false;
                            StringBuilder stringBuilder = new StringBuilder();
                            com.google.api.services.vision.v1.model.Block block2 = block;
                            Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"block");
                            List list3 = block2.getParagraphs();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"block.paragraphs");
                            Iterable $this$forEach$iv4 = list3;
                            boolean $i$f$forEach4 = false;
                            for (Object element$iv4 : $this$forEach$iv4) {
                                Paragraph it2 = (Paragraph)element$iv4;
                                boolean bl5 = false;
                                Paragraph paragraph = it2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)paragraph, (String)"it");
                                List list4 = paragraph.getWords();
                                Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"it.words");
                                Iterable $this$forEach$iv5 = list4;
                                boolean $i$f$forEach5 = false;
                                for (Object element$iv5 : $this$forEach$iv5) {
                                    Word word = (Word)element$iv5;
                                    boolean bl6 = false;
                                    Word word2 = word;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)word2, (String)"word");
                                    List list5 = word2.getSymbols();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"word.symbols");
                                    Iterable $this$forEach$iv6 = list5;
                                    boolean $i$f$forEach6 = false;
                                    for (Object element$iv6 : $this$forEach$iv6) {
                                        Symbol symbol = (Symbol)element$iv6;
                                        boolean bl7 = false;
                                        Symbol symbol2 = symbol;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)symbol2, (String)"symbol");
                                        stringBuilder.append(symbol2.getText());
                                    }
                                    stringBuilder.append(" ");
                                }
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder.toString(), (String)"stringBuilder.toString()");
                            BoundingPoly boundingPoly = block.getBoundingBox();
                            Intrinsics.checkExpressionValueIsNotNull((Object)boundingPoly, (String)"block.boundingBox");
                            Object e = boundingPoly.getVertices().get(0);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"block.boundingBox.vertices[0]");
                            Integer n = ((Vertex)e).getX();
                            if (n == null) {
                                continue;
                            }
                            int left = n;
                            BoundingPoly boundingPoly2 = block.getBoundingBox();
                            Intrinsics.checkExpressionValueIsNotNull((Object)boundingPoly2, (String)"block.boundingBox");
                            Object e2 = boundingPoly2.getVertices().get(0);
                            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"block.boundingBox.vertices[0]");
                            Integer n2 = ((Vertex)e2).getY();
                            if (n2 == null) {
                                continue;
                            }
                            int top = n2;
                            BoundingPoly boundingPoly3 = block.getBoundingBox();
                            Intrinsics.checkExpressionValueIsNotNull((Object)boundingPoly3, (String)"block.boundingBox");
                            Object e3 = boundingPoly3.getVertices().get(2);
                            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"block.boundingBox.vertices[2]");
                            Integer n3 = ((Vertex)e3).getX();
                            if (n3 == null) {
                                continue;
                            }
                            int right = n3;
                            BoundingPoly boundingPoly4 = block.getBoundingBox();
                            Intrinsics.checkExpressionValueIsNotNull((Object)boundingPoly4, (String)"block.boundingBox");
                            Object e4 = boundingPoly4.getVertices().get(2);
                            Intrinsics.checkExpressionValueIsNotNull(e4, (String)"block.boundingBox.vertices[2]");
                            Integer n4 = ((Vertex)e4).getY();
                            if (n4 == null) {
                                continue;
                            }
                            int bottom = n4;
                            DataSource dataSource = this.mDataSource;
                            if (dataSource == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"mDataSource");
                            }
                            if (right >= (metadata = dataSource.getMetaData()).getWidth()) {
                                right = metadata.getWidth() - 1;
                            }
                            if (bottom >= metadata.getHeight()) {
                                bottom = metadata.getHeight() - 1;
                            }
                            if (left <= 0) {
                                left = 1;
                            }
                            if (top <= 0) {
                                top = 1;
                            }
                            if ((rect = new Rect(left, top, right, bottom)).width() <= 0 || rect.height() <= 0) continue;
                            Block block1 = new Block(text, rect);
                            blocks.add(block1);
                        }
                    }
                }
            }
        }
        OcrResult ocrResult = new OcrResult((List<Block>)blocks);
        boolean bl8 = false;
        boolean bl9 = false;
        OcrResult it = ocrResult;
        boolean bl10 = false;
        this.mHistory = it;
        return ocrResult;
    }

    @Override
    @Nullable
    public FrameMetadata getFrameMetadata() {
        DataSource dataSource = this.mDataSource;
        if (dataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mDataSource");
        }
        return dataSource.getMetaData();
    }

    @Override
    @Nullable
    public OcrResult getHistory() {
        return this.mHistory;
    }

    @Override
    public int getType() {
        return 1;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"<set-?>");
        this.context = context;
    }

    public GoogleRecognizer(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/talpa/translate/ocr/GoogleRecognizer$Companion;", "", "()V", "ANDROID_CERT_HEADER", "", "ANDROID_PACKAGE_HEADER", "TAG", "translation_hitranslateRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

