/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import androidx.annotation.Keep;
import com.talpa.translate.ocr.IAnalyzer;
import com.talpa.translate.ocr.TextDrawer;
import com.talpa.translate.ocr.text.NormalTextDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0082 \u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0006H\u0082 J\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0082 \u00a2\u0006\u0002\u0010\u001aJ\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0082 J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001f\u001a\u0004\u0018\u00010\fJ\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0018H\u0016J\u0011\u0010$\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0018H\u0082 J\u001d\u0010%\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000b\u0010&\u001a\u0004\u0018\u00010\u0018H\u0082 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/talpa/translate/ocr/PhotoAnalyzer;", "Lcom/talpa/translate/ocr/IAnalyzer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mNativeAddr", "", "mRecycled", "", "mTextDrawer", "Lcom/talpa/translate/ocr/text/NormalTextDrawer;", "sourceConfig", "Landroid/graphics/Bitmap$Config;", "analyzeTextColor", "", "areas", "", "Landroid/graphics/Rect;", "([Landroid/graphics/Rect;)[I", "cleanUp", "", "cleanUpNative", "addr", "generateBgBitmap", "Landroid/graphics/Bitmap;", "rects", "([Landroid/graphics/Rect;)Landroid/graphics/Bitmap;", "generateBitmapNative", "getBase64Native", "", "getBase64String", "getSourceConfig", "getTextDrawer", "Lcom/talpa/translate/ocr/TextDrawer;", "initialize", "bitmap", "initializeNative", "postAnalyzeArea", "preprocessor", "Companion", "translation_hitranslateRelease"})
@Keep
public final class PhotoAnalyzer
implements IAnalyzer {
    private final NormalTextDrawer mTextDrawer;
    private long mNativeAddr;
    private boolean mRecycled;
    private Bitmap.Config sourceConfig;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public TextDrawer getTextDrawer() {
        return this.mTextDrawer;
    }

    @Nullable
    public final Bitmap.Config getSourceConfig() {
        Log.d((String)"cjslog", (String)"from jni call");
        return this.sourceConfig;
    }

    @Override
    public void initialize(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.mNativeAddr = this.initializeNative(bitmap);
        if (this.mNativeAddr == 0L) {
            throw (Throwable)new RuntimeException("can't initialize photo analyze object");
        }
        this.mRecycled = false;
        this.sourceConfig = bitmap.getConfig();
    }

    @Override
    public void cleanUp() {
        if (!this.mRecycled) {
            this.cleanUpNative(this.mNativeAddr);
            this.mRecycled = true;
        }
    }

    private final Bitmap generateBgBitmap(Rect[] rects) {
        if (this.mRecycled) {
            throw (Throwable)new IllegalStateException("analyzer has been recycled");
        }
        return this.generateBitmapNative(rects);
    }

    @Override
    @Nullable
    public Bitmap postAnalyzeArea(@NotNull Rect[] rects) {
        Intrinsics.checkParameterIsNotNull((Object)rects, (String)"rects");
        return this.generateBgBitmap(rects);
    }

    @Override
    @Nullable
    public String getBase64String() {
        if (this.mRecycled) {
            throw (Throwable)new IllegalStateException("analyzer has been recycled");
        }
        return this.getBase64Native();
    }

    private final native Bitmap generateBitmapNative(Rect[] var1);

    private final native long initializeNative(Bitmap var1);

    private final native int[] analyzeTextColor(Rect[] var1);

    private final native Bitmap preprocessor();

    private final native String getBase64Native();

    private final native void cleanUpNative(long var1);

    public PhotoAnalyzer(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mTextDrawer = new NormalTextDrawer(context);
        this.mRecycled = true;
    }

    static {
        System.loadLibrary("opencv_java4");
        System.loadLibrary("imgprocessor");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/talpa/translate/ocr/PhotoAnalyzer$Companion;", "", "()V", "translation_hitranslateRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

