package com.talpa.rate

import android.content.Context
import androidx.annotation.Keep
import androidx.core.os.LocaleListCompat
import java.util.*

/**
 * Create by chenjunsheng on 2021/11/15
 */
@Keep
open class DefaultReviewStrategy(context: Context) : ReviewStrategyImpl(context) {

    override fun getSupportLocales(): LocaleListCompat {
        return LocaleListCompat.forLanguageTags(Locale.getDefault().language)
    }

    override fun enable(): Boolean {
        return true
    }

    override fun getCustomType(): UserType {
        return UserType.All
    }

    override fun getVersionType(): VersionType {
        return VersionType.Normal
    }

    override fun getShowTime(): List<EnableTime> {
        return arrayListOf(EnableTime(8), EnableTime(22))
    }

    override fun getOneStarAction(): String? {
        return null
    }

    override fun getTwoStarsAction(): String? {
        return null
    }

    override fun getThreeStarsAction(): String? {
        return null
    }

    override fun getFourStarsAction(): String? {
        return null
    }

    override fun getFiveStarsAction(): String? {
        return null
    }
}