package com.talpa.rate

import android.content.DialogInterface
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import androidx.fragment.app.DialogFragment
import com.talpa.rate.ReviewStrategyImpl.Companion.KEY_RATE_RESULT
import com.talpa.rate.ReviewStrategyImpl.Companion.RATE_RESULT_BAD
import com.talpa.rate.ReviewStrategyImpl.Companion.RATE_RESULT_GOOD
import com.talpa.rate.databinding.RateFragmentLayoutBinding
import android.view.WindowManager

import android.view.ViewGroup
import androidx.work.ExistingWorkPolicy
import androidx.work.OneTimeWorkRequest
import androidx.work.WorkManager
import com.talpa.rate.ReviewStrategyImpl.Companion.KEY_RATE_CANCEL
import com.talpa.rate.ReviewStrategyImpl.Companion.KEY_RATE_CANCEL_TIME_REACH
import com.talpa.rate.ratebar.BaseRatingBar
import java.util.concurrent.TimeUnit


/**
 * Create by chenjunsheng on 2021/11/2
 */
open class RateFragment : DialogFragment(), View.OnClickListener,
    BaseRatingBar.OnRatingChangeListener {


    private lateinit var binding: RateFragmentLayoutBinding
    private var mRating: Float = 0f
    private var mRateListener: RateListener? = null
    private lateinit var mStrategy: ReviewStrategy
    private var listener: ReviewController.EventListener? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        dialog?.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        binding = RateFragmentLayoutBinding.inflate(layoutInflater, container, false)
        return binding.root
    }

    fun setStrategy(strategy: ReviewStrategy) {
        mStrategy = strategy
    }

    fun setEventListener(eventListener: ReviewController.EventListener?) {
        listener = eventListener
    }

    override fun onCancel(dialog: DialogInterface) {
        super.onCancel(dialog)
        KeyValue.put(KEY_RATE_CANCEL, true)
        KeyValue.put(KEY_RATE_CANCEL_TIME_REACH, false)
        val work = OneTimeWorkRequest.Builder(TimeReachWork::class.java)
            .setInitialDelay(7, TimeUnit.DAYS)
            .build()
        WorkManager.getInstance(context ?: return).enqueueUniqueWork(
            TimeReachWork::class.java.simpleName,
            ExistingWorkPolicy.REPLACE,
            work
        )
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.rateButton.setOnClickListener(this)
        binding.materialRatingBar.setOnRatingChangeListener(this)
        if (mStrategy.getVersionType() == VersionType.Guidance) {
            binding.materialRatingBar.showGuidanceText()
            binding.guideWidget.visibility = View.VISIBLE
        }

        listener?.onShow5Stars(mStrategy.getVersionType())
    }

    fun setRateListener(rateListener: RateListener?) {
        mRateListener = rateListener
    }

    fun markFavorableReception() {
        KeyValue.put(KEY_RATE_RESULT, RATE_RESULT_GOOD)
    }

    fun markNegativeReception() {
        KeyValue.put(KEY_RATE_RESULT, RATE_RESULT_BAD)
    }

    override fun onResume() {
        val params: WindowManager.LayoutParams = dialog!!.window!!.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        dialog!!.window!!.attributes = params
        super.onResume()
        listener?.onShowRateDialog(mStrategy.getVersionType())
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.rate_button -> {
                if (mRating > 4) {
                    markFavorableReception()
                } else {
                    markNegativeReception()
                }
                mRateListener?.onUserRate(mRating, mStrategy)
                listener?.onRateEvent(mStrategy.getVersionType(), mRating)
                dismiss()
            }
        }
    }

    override fun onRatingChange(ratingBar: BaseRatingBar, rating: Float, fromUser: Boolean) {
        mRating = rating
        if (mStrategy.getVersionType() == VersionType.Normal) {
            if (mRating <= 0f) {
                binding.firstLine.setText(R.string.normal_five_stars_second_line)
                binding.firstLine.visibility = View.VISIBLE
                binding.secondLine.visibility = View.INVISIBLE
                binding.face.setAnimation("recommend_us.json")
                binding.face.playAnimation()
                //binding.face.setImageResource(R.drawable.recommend_us)
            } else if (mRating <= 1f) {
                binding.firstLine.setText(R.string.normal_one_star_first_line)
                binding.secondLine.setText(R.string.normal_one_star_second_line)
                binding.face.setImageResource(R.drawable.normal_first_rate_img)
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else if (mRating <= 2f) {
                binding.firstLine.setText(R.string.normal_two_stars_first_line)
                binding.secondLine.setText(R.string.normal_two_stars_second_line)
                binding.face.setImageResource(R.drawable.normal_second_rate_img)
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else if (mRating <= 3f) {
                binding.firstLine.setText(R.string.normal_three_stars_first_line)
                binding.secondLine.setText(R.string.normal_three_stars_second_line)
                binding.face.setImageResource(R.drawable.normal_third_rate_img)
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else if (mRating <= 4f) {
                binding.firstLine.setText(R.string.normal_four_stars_first_line)
                binding.secondLine.setText(R.string.normal_four_stars_second_line)
                binding.face.setImageResource(R.drawable.normal_fourth_rate_img)
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else {
                binding.firstLine.setText(R.string.normal_five_stars_first_line)
                binding.secondLine.setText(R.string.normal_five_stars_second_line)
                binding.face.setImageResource(R.drawable.normal_fifth_rate_img)
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            }
        } else {
            binding.face.setImageResource(0)
            if (mRating <= 0f) {
                binding.firstLine.setText(R.string.normal_five_stars_second_line)
                binding.firstLine.visibility = View.VISIBLE
                binding.secondLine.visibility = View.INVISIBLE
                binding.face.setAnimation("recommend_us.json")
                binding.face.playAnimation()
                //binding.face.setImageResource(R.drawable.recommend_us)
            } else if (mRating <= 1f) {
                binding.firstLine.setText(R.string.normal_one_star_first_line)
                binding.secondLine.setText(R.string.normal_one_star_second_line)
                binding.face.setAnimation("one_star_anim.json")
                binding.face.playAnimation()
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else if (mRating <= 2f) {
                binding.firstLine.setText(R.string.normal_two_stars_first_line)
                binding.secondLine.setText(R.string.normal_two_stars_second_line)
                binding.face.setAnimation("two_stars_anim.json")
                binding.face.playAnimation()
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else if (mRating <= 3f) {
                binding.firstLine.setText(R.string.normal_three_stars_first_line)
                binding.secondLine.setText(R.string.normal_three_stars_second_line)
                binding.face.setAnimation("three_stars_anim.json")
                binding.face.playAnimation()
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else if (mRating <= 4f) {
                binding.firstLine.setText(R.string.normal_four_stars_first_line)
                binding.secondLine.setText(R.string.normal_four_stars_second_line)
                binding.face.setAnimation("four_stars_anim.json")
                binding.face.playAnimation()
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            } else {
                binding.firstLine.setText(R.string.normal_five_stars_first_line)
                binding.secondLine.setText(R.string.normal_five_stars_second_line)
                binding.face.setAnimation("five_stars_anim.json")
                binding.face.playAnimation()
                binding.secondLine.visibility = View.VISIBLE
                binding.firstLine.visibility = View.VISIBLE
            }
        }
    }
}