package com.talpa.rate

import androidx.annotation.Keep
import androidx.fragment.app.FragmentActivity

/**
 * Create by chenjunsheng on 2021/11/2
 */
@Keep
interface ReviewController {

    fun requestReview(activity: FragmentActivity, rateListener: RateListener? = null)

    fun setReviewStrategy(strategy: ReviewStrategy)

    fun setEventListener(eventListener: EventListener)

    interface EventListener {

        //展示五星好评框
        fun onShow5Stars(versionType: VersionType)

        //弹出引导性评价动画
        fun onShowRateDialog(versionType: VersionType)

        fun onRateEvent(versionType: VersionType, rate: Float)
    }
}