package com.talpa.rate

import android.content.Context
import androidx.fragment.app.FragmentActivity

/**
 * Create by chenjunsheng on 2021/11/2
 */
class ReviewControllerImpl(private val context: Context) : ReviewController {

    private var strategy: ReviewStrategy = DefaultReviewStrategy(context)
    private var listener: ReviewController.EventListener? = null

    override fun requestReview(activity: FragmentActivity, rateListener: RateListener?) {
        if (strategy.reviewPermission()) {
            val simpleRateFragment = SimpleRateFragment(strategy.getVersionType())
            simpleRateFragment.setSimpleRateListener(object : SimpleRateFragment.SimpleRateListener {
                override fun onRateGood(versionType: VersionType) {
                    simpleRateFragment.dismiss()
                    val rateFragment = RateFragment()
                    rateFragment.setStrategy(strategy)
                    rateFragment.setEventListener(listener)
                    //rateFragment.setStyle(DialogFragment.STYLE_NORMAL, R.style.dialogFullScreen);
                    rateFragment.setRateListener(rateListener)
                    rateFragment.show(activity.supportFragmentManager, "rate")
                }

                override fun onRateNotGood(versionType: VersionType) {
                    rateListener?.onRateNotGood()
                    simpleRateFragment.dismiss()
                }

            })
            simpleRateFragment.show(activity.supportFragmentManager, "rate")
        }
    }

    override fun setReviewStrategy(strategy: ReviewStrategy) {
        this.strategy = strategy
    }

    override fun setEventListener(eventListener: ReviewController.EventListener) {
        listener = eventListener
    }
}