package com.talpa.rate

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import androidx.fragment.app.DialogFragment
import com.talpa.rate.databinding.RateSimpleFragmentLayoutBinding

/**
 * Create by chenjunsheng on 2021/11/19
 */
class SimpleRateFragment(private val versionType: VersionType)  : DialogFragment(), View.OnClickListener{

    private lateinit var binding: RateSimpleFragmentLayoutBinding
    private var mSimpleRateListener: SimpleRateListener? = null

    fun setSimpleRateListener(simpleRateListener: SimpleRateListener) {
        mSimpleRateListener = simpleRateListener
    }
    interface SimpleRateListener {
        fun onRateGood(versionType: VersionType)
        fun onRateNotGood(versionType: VersionType)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        dialog?.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        binding = RateSimpleFragmentLayoutBinding.inflate(layoutInflater, container, false)
        binding.rateGoodButton.setOnClickListener(this)
        binding.rateNotGoodButton.setOnClickListener(this)
        when (versionType) {
            VersionType.Normal -> {
                binding.guideText.visibility = View.GONE
            }
            VersionType.Guidance -> {
                binding.guideText.visibility = View.VISIBLE
            }
        }
        return binding.root
    }

    override fun onResume() {
        val params: WindowManager.LayoutParams = dialog!!.window!!.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        dialog!!.window!!.attributes = params
        super.onResume()
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.rate_good_button -> {
                mSimpleRateListener?.onRateGood(versionType)
            }
            R.id.rate_not_good_button -> {
                mSimpleRateListener?.onRateNotGood(versionType)
            }
        }
    }
}