package com.talpa.rate

import android.content.Context
import android.os.Build

/**
 * Create by chenjunsheng on 2021/11/2
 */

fun getAppVersionCode(context: Context): Long {
    val packageManager = context.packageManager
    return try {
        val info = packageManager.getPackageInfo(context.packageName, 0)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
            info.longVersionCode
        } else {
            info.versionCode.toLong()
        }
    } catch (e: Exception) {
        e.printStackTrace()
        0L
    }
}