package com.talpa.rate

import android.content.DialogInterface
import androidx.fragment.app.DialogFragment
import androidx.work.ExistingPeriodicWorkPolicy
import androidx.work.PeriodicWorkRequest
import androidx.work.WorkManager
import com.talpa.rate.strategy.ReviewStrategy
import com.talpa.rate.strategy.ReviewStrategyImpl
import com.talpa.rate.utils.KeyValue
import com.talpa.rate.worker.TimeReachWork
import java.util.concurrent.TimeUnit

/**
 * Create by chenjunsheng on 2022/1/14
 */
open class CancelableFragment : DialogFragment() {

    protected var mStrategy: ReviewStrategy? = null

    fun setStrategy(strategy: ReviewStrategy) {
        mStrategy = strategy
    }

    override fun onCancel(dialog: DialogInterface) {
        super.onCancel(dialog)
        setCancelAction()
    }

    protected fun setCancelAction() {
        KeyValue.put(ReviewStrategyImpl.KEY_RATE_CANCEL, true)
        KeyValue.put(ReviewStrategyImpl.KEY_RATE_CANCEL_TIME_REACH, false)
        val work = if (mStrategy?.getDebug() ?: false) {
            PeriodicWorkRequest.Builder(TimeReachWork::class.java, 15, TimeUnit.MINUTES)
                .setInitialDelay(1, TimeUnit.MINUTES)
                .build()
            /*OneTimeWorkRequest.Builder(TimeReachWork::class.java)
                .setInitialDelay(1, TimeUnit.MINUTES)
                .build()*/
        } else {
            PeriodicWorkRequest.Builder(TimeReachWork::class.java, 7, TimeUnit.DAYS)
                .setInitialDelay(7, TimeUnit.DAYS)
                .build()
        }

        WorkManager.getInstance(context ?: return).enqueueUniquePeriodicWork(
            TimeReachWork::class.java.simpleName,
            ExistingPeriodicWorkPolicy.REPLACE,
            work
        )
    }
}