package com.talpa.rate

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import androidx.annotation.Keep
import com.talpa.rate.controller.ReviewController
import com.talpa.rate.databinding.RateFragmentLayoutBinding
import com.talpa.rate.ratebar.BaseRatingBar
import com.talpa.rate.ratebar.PartialView
import com.talpa.rate.strategy.ReviewStrategyImpl.Companion.KEY_RATE_RESULT
import com.talpa.rate.strategy.ReviewStrategyImpl.Companion.RATE_RESULT_BAD
import com.talpa.rate.strategy.ReviewStrategyImpl.Companion.RATE_RESULT_GOOD
import com.talpa.rate.strategy.data.VersionType
import com.talpa.rate.utils.KeyValue


/**
 * Create by chenjunsheng on 2021/11/2
 */
@Keep
open class RateFragment : CancelableFragment(), View.OnClickListener,
    BaseRatingBar.OnRatingChangeListener {

    private lateinit var binding: RateFragmentLayoutBinding
    private var mRating: Float = 0f
    private var mRateListener: RateListener? = null
    private var listener: ReviewController.EventListener? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        dialog?.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        binding = RateFragmentLayoutBinding.inflate(layoutInflater, container, false)
        binding.materialRatingBar.setEndAnimListener(object : PartialView.EndAnimListener {
            override fun onEnd() {
                binding.rateButton.isEnabled = true
            }

            override fun onCurrentEnd(current: PartialView?) {}

        })
        return binding.root
    }

    fun setEventListener(eventListener: ReviewController.EventListener?) {
        listener = eventListener
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.rateButton.setOnClickListener(this)
        binding.materialRatingBar.setOnRatingChangeListener(this)
        mStrategy?.let {
            if (it.getVersionType() == VersionType.Guidance) {
                binding.materialRatingBar.showGuidanceText()
                binding.guideWidget.visibility = View.VISIBLE
            }
        }


        listener?.onShow5Stars(mStrategy?.getVersionType() ?: return)
    }

    fun setRateListener(rateListener: RateListener?) {
        mRateListener = rateListener
    }

    fun markFavorableReception() {
        KeyValue.put(KEY_RATE_RESULT, RATE_RESULT_GOOD)
    }

    fun markNegativeReception() {
        KeyValue.put(KEY_RATE_RESULT, RATE_RESULT_BAD)
    }

    override fun onResume() {
        val params: WindowManager.LayoutParams = dialog!!.window!!.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        dialog!!.window!!.attributes = params
        super.onResume()
        listener?.onShowRateDialog(mStrategy?.getVersionType() ?: return)
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.rate_button -> {
                if (mRating > 4) {
                    markFavorableReception()
                } else if (mRating > 0){
                    markNegativeReception()
                } else {
                    setCancelAction()
                }
                mStrategy?.let {
                    if (mRating >= 5f) {
                        mRateListener?.onUserRate(mRating, it, it.getFiveStarsAction())
                    } else if (mRating >=4) {
                        mRateListener?.onUserRate(mRating, it, it.getFourStarsAction())
                    } else if (mRating >= 3) {
                        mRateListener?.onUserRate(mRating, it, it.getThreeStarsAction())
                    } else if (mRating >= 2) {
                        mRateListener?.onUserRate(mRating, it, it.getTwoStarsAction())
                    } else if (mRating >= 1) {
                        mRateListener?.onUserRate(mRating, it, it.getOneStarAction())
                    }
                    listener?.onRateEvent(it.getVersionType(), mRating)
                }
                dismiss()
            }
        }
    }

    override fun onRatingChange(ratingBar: BaseRatingBar, rating: Float, fromUser: Boolean) {
        mRating = rating
        mStrategy?.let { strategy ->

            if (strategy.getVersionType() == VersionType.Normal) {
                if (mRating <= 0f) {
                    binding.firstLine.setText(R.string.normal_five_stars_second_line)
                    binding.firstLine.visibility = View.VISIBLE
                    binding.secondLine.visibility = View.INVISIBLE
                    binding.face.setAnimation("recommend_us.json")
                    binding.face.playAnimation()
                    binding.rateButton.setText(R.string.rate_dialog_close)
                    //binding.face.setImageResource(R.drawable.recommend_us)
                } else if (mRating <= 1f) {
                    binding.firstLine.setText(R.string.normal_one_star_first_line)
                    binding.secondLine.setText(R.string.normal_one_star_second_line)
                    binding.face.setAnimation("one_star_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else if (mRating <= 2f) {
                    binding.firstLine.setText(R.string.normal_two_stars_first_line)
                    binding.secondLine.setText(R.string.normal_two_stars_second_line)
                    binding.face.setAnimation("two_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else if (mRating <= 3f) {
                    binding.firstLine.setText(R.string.normal_three_stars_first_line)
                    binding.secondLine.setText(R.string.normal_three_stars_second_line)
                    binding.face.setAnimation("three_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else if (mRating <= 4f) {
                    binding.firstLine.setText(R.string.normal_four_stars_first_line)
                    binding.secondLine.setText(R.string.normal_four_stars_second_line)
                    binding.face.setAnimation("four_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else {
                    binding.firstLine.setText(R.string.normal_five_stars_first_line)
                    binding.secondLine.setText(R.string.normal_five_stars_second_line)
                    binding.face.setAnimation("five_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text)
                }
            } else {
                if (mRating <= 0f) {
                    binding.firstLine.setText(R.string.normal_five_stars_second_line)
                    binding.firstLine.visibility = View.VISIBLE
                    binding.secondLine.visibility = View.INVISIBLE
                    binding.face.setAnimation("recommend_us.json")
                    binding.face.playAnimation()
                    binding.rateButton.setText(R.string.rate_dialog_close)
                    //binding.face.setImageResource(R.drawable.recommend_us)
                } else if (mRating <= 1f) {
                    binding.firstLine.setText(R.string.normal_one_star_first_line)
                    binding.secondLine.setText(R.string.normal_one_star_second_line)
                    binding.face.setAnimation("one_star_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else if (mRating <= 2f) {
                    binding.firstLine.setText(R.string.normal_two_stars_first_line)
                    binding.secondLine.setText(R.string.normal_two_stars_second_line)
                    binding.face.setAnimation("two_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else if (mRating <= 3f) {
                    binding.firstLine.setText(R.string.normal_three_stars_first_line)
                    binding.secondLine.setText(R.string.normal_three_stars_second_line)
                    binding.face.setAnimation("three_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else if (mRating <= 4f) {
                    binding.firstLine.setText(R.string.normal_four_stars_first_line)
                    binding.secondLine.setText(R.string.normal_four_stars_second_line)
                    binding.face.setAnimation("four_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text1)
                } else {
                    binding.firstLine.setText(R.string.normal_five_stars_first_line)
                    binding.secondLine.setText(R.string.normal_five_stars_second_line)
                    binding.face.setAnimation("five_stars_anim.json")
                    binding.face.playAnimation()
                    binding.secondLine.visibility = View.VISIBLE
                    binding.firstLine.visibility = View.VISIBLE
                    binding.rateButton.setText(R.string.rate_button_text)
                }
            }
        }

    }
}