package com.talpa.rate

import android.content.DialogInterface
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.os.Handler
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import androidx.annotation.Keep
import androidx.fragment.app.DialogFragment
import androidx.work.PeriodicWorkRequest
import com.talpa.rate.databinding.RateSimpleFragmentLayoutBinding
import com.talpa.rate.strategy.ReviewStrategyImpl
import com.talpa.rate.strategy.data.VersionType
import com.talpa.rate.utils.KeyValue
import com.talpa.rate.worker.TimeReachWork
import java.util.concurrent.TimeUnit

/**
 * Create by chenjunsheng on 2021/11/19
 */
@Keep
class SimpleRateFragment  : CancelableFragment(), View.OnClickListener{


    companion object {
        const val EXTRA_VERSION_TYPE = "extra_version_type"
    }

    private lateinit var versionType: VersionType
    private lateinit var binding: RateSimpleFragmentLayoutBinding
    private var mSimpleRateListener: SimpleRateListener? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        versionType = arguments?.get(EXTRA_VERSION_TYPE) as? VersionType ?: VersionType.Normal
    }

    fun setSimpleRateListener(simpleRateListener: SimpleRateListener) {
        mSimpleRateListener = simpleRateListener
    }
    interface SimpleRateListener {
        fun onRateGood(versionType: VersionType)
        fun onRateNotGood(versionType: VersionType)
        fun onFirstRateShow(versionType: VersionType)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        dialog?.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        binding = RateSimpleFragmentLayoutBinding.inflate(layoutInflater, container, false)
        binding.rateGoodButton.setOnClickListener(this)
        binding.rateNotGoodButton.setOnClickListener(this)
        when (versionType) {
            VersionType.Normal -> {
                binding.guideText.visibility = View.GONE
            }
            VersionType.Guidance -> {
                binding.guideText.visibility = View.VISIBLE
            }
        }
        mSimpleRateListener?.onFirstRateShow(versionType)
        return binding.root
    }

    override fun onResume() {
        val params: WindowManager.LayoutParams = dialog!!.window!!.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        dialog!!.window!!.attributes = params
        super.onResume()
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.rate_good_button -> {
                mSimpleRateListener?.onRateGood(versionType)
            }
            R.id.rate_not_good_button -> {
                mSimpleRateListener?.onRateNotGood(versionType)
            }
        }
    }
}