package com.talpa.rate.controller

import com.talpa.rate.strategy.data.VersionType
import com.talpa.rate.utils.*

/**
 * Create by chenjunsheng on 2021/12/17
 */
abstract class DefaultEventReporter: ReviewController.EventListener {

    override fun onShow5Stars(versionType: VersionType) {
        when(versionType) {
            VersionType.Guidance -> {
                reportEvent(show_super5star)
            }
            VersionType.Normal -> {
                reportEvent(show_5star)
            }
        }
    }

    override fun onShowRateDialog(versionType: VersionType) {
        when(versionType) {
            VersionType.Guidance -> {
                reportEvent(show_super5star_flash)
            }
            VersionType.Normal -> {
                reportEvent(show_5star_flash)
            }
        }
    }

    override fun onRateEvent(versionType: VersionType, rate: Float) {
        when(versionType) {
            VersionType.Guidance -> {
                if (rate >= 5f) {
                    reportEvent(show_super5star_5)
                } else if (rate >= 4) {
                    reportEvent(show_super5star_4)
                } else if (rate >= 3) {
                    reportEvent(show_super5star_3)
                } else if (rate >= 2) {
                    reportEvent(show_super5star_2)
                } else if (rate >= 1) {
                    reportEvent(show_super5star_1)
                }
            }
            VersionType.Normal -> {
                if (rate >= 5f) {
                    reportEvent(show_5star_5)
                } else if (rate >= 4) {
                    reportEvent(show_5star_4)
                } else if (rate >= 3) {
                    reportEvent(show_5star_3)
                } else if (rate >= 2) {
                    reportEvent(show_5star_2)
                } else if (rate >= 1) {
                    reportEvent(show_5star_1)
                }
            }
        }
    }

    override fun onRateGood(versionType: VersionType) {
        when (versionType) {
            VersionType.Guidance -> {
                reportEvent(click_super5star_good)
            }
            VersionType.Normal -> {
                reportEvent(show_5star_good)
            }
        }
    }

    override fun onRateNotGood(versionType: VersionType) {
        when (versionType) {
            VersionType.Guidance -> {
                reportEvent(click_super5star_notgood)
            }
            VersionType.Normal -> {
                reportEvent(show_5star_notgood)
            }
        }
    }

    override fun onFirstRateShow(versionType: VersionType) {
        when (versionType) {
            VersionType.Guidance -> {
                reportEvent(show_super5window)
            }
            VersionType.Normal -> {
                reportEvent(show_5window)
            }
        }
    }

    abstract fun reportEvent(eventId: String)
}