package com.talpa.rate.controller

import androidx.annotation.Keep
import androidx.fragment.app.FragmentActivity
import com.talpa.rate.RateListener
import com.talpa.rate.strategy.data.VersionType
import com.talpa.rate.strategy.ReviewStrategy

/**
 * Create by chenjunsheng on 2021/11/2
 */
@Keep
interface ReviewController {

    /**
     * 请求展示评分框，如果满足条件，则会展示评分窗口
     */
    fun requestReview(activity: FragmentActivity, rateListener: RateListener? = null)

    /**
     * 设置评分窗展示策略
     */
    fun setReviewStrategy(strategy: ReviewStrategy)

    /**
     * 设置事件监听，主要用户埋点
     */
    fun setEventListener(eventListener: EventListener)

    interface EventListener {

        //展示五星好评框
        fun onShow5Stars(versionType: VersionType)

        //弹出引导性评价动画
        fun onShowRateDialog(versionType: VersionType)

        fun onRateEvent(versionType: VersionType, rate: Float)

        fun onRateGood(versionType: VersionType)
        fun onRateNotGood(versionType: VersionType)

        fun onFirstRateShow(versionType: VersionType)
    }
}