package com.talpa.rate.controller

import android.os.Bundle
import androidx.fragment.app.FragmentActivity
import com.talpa.rate.*
import com.talpa.rate.strategy.ReviewStrategy
import com.talpa.rate.strategy.data.VersionType

/**
 * Create by chenjunsheng on 2021/11/2
 */
class ReviewControllerImpl : ReviewController {

    private var strategy: ReviewStrategy? = null
    private var listener: ReviewController.EventListener? = null

    /**
     * 根据规则进行评分框弹出
     */
    override fun requestReview(activity: FragmentActivity, rateListener: RateListener?) {
        if (strategy?.reviewPermission() ?: false) {
            val simpleRateFragment = SimpleRateFragment()
            strategy?.let { simpleRateFragment.setStrategy(it) }
            simpleRateFragment.arguments = Bundle().also {
                it.putSerializable(SimpleRateFragment.EXTRA_VERSION_TYPE, strategy?.getVersionType())
            }
            simpleRateFragment.setSimpleRateListener(object :
                SimpleRateFragment.SimpleRateListener {
                override fun onRateGood(versionType: VersionType) {
                    simpleRateFragment.dismiss()
                    val rateFragment = RateFragment()
                    strategy?.let { rateFragment.setStrategy(it) }
                    rateFragment.setEventListener(listener)
                    //rateFragment.setStyle(DialogFragment.STYLE_NORMAL, R.style.dialogFullScreen);
                    rateFragment.setRateListener(rateListener)
                    rateFragment.show(activity.supportFragmentManager, "rate")
                    strategy?.let { listener?.onRateGood(it.getVersionType()) }
                }

                override fun onRateNotGood(versionType: VersionType) {
                    rateListener?.onRateNotGood()
                    simpleRateFragment.dismiss()
                    listener?.onRateNotGood(versionType)
                }

                override fun onFirstRateShow(versionType: VersionType) {
                    listener?.onFirstRateShow(versionType)
                }
            })
            simpleRateFragment.show(activity.supportFragmentManager, "rate")
        }
    }

    override fun setReviewStrategy(strategy: ReviewStrategy) {
        this.strategy = strategy
    }

    /**
     * 设置埋点事件
     */
    override fun setEventListener(eventListener: ReviewController.EventListener) {
        listener = eventListener
    }
}