package com.talpa.rate.strategy

import androidx.annotation.Keep
import androidx.core.os.LocaleListCompat
import com.talpa.rate.strategy.data.EnableTime
import com.talpa.rate.strategy.data.UserType
import com.talpa.rate.strategy.data.VersionType

/**
 * Create by chenjunsheng on 2021/11/2
 * 展示策略，用于控制评分框是否展示和具体行为
 */
@Keep
interface ReviewStrategy {

    /**
     * 对评分框是否需要弹出进行必要判断
     */
    fun reviewPermission(): Boolean

    /**
     * 设置支持的国家
     */
    fun getSupportLocales(): LocaleListCompat

    /**
     * 配置线上对应的策略是否启用
     */
    fun enable(): Boolean

    /**
     * 定义弹出评分框的用户类型，如新用户，老用户，所有用户
     */
    fun getCustomType(): UserType

    /**
     * 设置评分框类型，目前有普通类型和引导类型
     */
    fun getVersionType(): VersionType

    /**
     * 设置评分框展示时间段
     */
    fun getShowTime(): List<EnableTime>

    /**
     * 设置评分后对应按钮的行为
     */
    fun getOneStarAction(): String?

    fun getTwoStarsAction(): String?

    fun getThreeStarsAction(): String?

    fun getFourStarsAction(): String?

    fun getFiveStarsAction(): String?

    fun getDebug(): Boolean = false
}