package com.talpa.rate.strategy

import android.content.Context
import android.text.TextUtils
import android.util.Log
import com.talpa.rate.*
import com.talpa.rate.strategy.data.UserType
import com.talpa.rate.utils.KeyValue
import com.talpa.rate.utils.getAppVersionCode
import java.util.*

/**
 * Create by chenjunsheng on 2021/11/2
 * 这个类定义的是默认的评分框行为
 * 建议继承该类来实现定制化的行为
 */
abstract class ReviewStrategyImpl(private val context: Context) : ReviewStrategy {


    private var userType: UserType
    private var showCount = 0

    companion object {

        const val KEY_LAST_VERSION_CODE = "key_last_version_code"
        const val KEY_RATE_SHOW_COUNT = "key_rate_show_count"
        const val KEY_RATE_RESULT = "key_rate_result"
        const val KEY_RATE_CANCEL = "key_rate_cancel"
        const val KEY_RATE_CANCEL_TIME_REACH = "key_rate_cancel_time_reach"
        const val RATE_RESULT_GOOD = "rate_result_good"
        const val RATE_RESULT_BAD = "rate_result_bad"
        const val RATE_SHOW_STRATEGY_KEY = "rate_show_strategy"
        const val RATE_ACTION_STRATEGY = "rate_action_strategy"
    }

    init {

/*        mRateRemoteConfig = RateRemoteConfig(
            enable = enable(),
            country = getSupportLocales(),
            custom = getCustomType(),
            showTime = getShowTime(),
            version = getVersionType()
        )

        mRateRemoteAction = RateRemoteAction(
            oneAction = getOneStarAction(),
            twoAction = getTwoStarsAction(),
            threeAction = getThreeStarsAction(),
            fourAction = getFourStarsAction(),
            fiveAction = getFiveStarsAction()
        )*/

        val lastVersion = KeyValue.get(KEY_LAST_VERSION_CODE, 0L) ?: 0L

        if (lastVersion == 0L) {
            //新安装的用户
            userType = UserType.NewInstall
        } else {
            //老用户
            userType = UserType.Regular
        }
        showCount = KeyValue.get(KEY_RATE_SHOW_COUNT, 0) ?: 0
    }

    private fun updateCurrentVersion() {
        val currentVersion = getAppVersionCode(context)
        KeyValue.put(KEY_LAST_VERSION_CODE, currentVersion)
        userType = UserType.Regular
    }

    private fun matchJudgement(): Boolean {
        val date = Calendar.getInstance()
        val startTime = getShowTime()[0]
        val endTime = getShowTime()[1]
        val currentHour = date.get(Calendar.HOUR_OF_DAY)
        var match = false
        if (!getSupportLocales().isEmpty) {
            kotlin.run {
                repeat(getSupportLocales().size()) {
                    if (getSupportLocales()[it].language == Locale.getDefault().language) {
                        match = true
                        return@run
                    }
                }
            }

        }
        Log.d("cjslog", "get custom type:${getCustomType()} ${currentHour}")
        Log.d("cjslog", "first enable:${enable()}")
        Log.d("cjslog", "second:(getSupportLocales().isEmpty() || getSupportLocales()\n" +
                "            .getFirstMatch(arrayOf(Locale.getDefault().language)) != null)"
        + " " + (getSupportLocales().isEmpty() || match))
        Log.d("cjslog", "third:${(getCustomType() == UserType.All || getCustomType() == userType)}")
        Log.d("cjslog", "hour:${startTime.hour <= currentHour && endTime.hour >= currentHour}")

        return enable()
                && (getSupportLocales().isEmpty || match)
                && (getCustomType() == UserType.All || getCustomType() == userType)
                && startTime.hour <= currentHour && endTime.hour >= currentHour
    }

    private fun increaseShowCount() {
        showCount++
        KeyValue.put(KEY_RATE_SHOW_COUNT, showCount)
    }

    override fun reviewPermission(): Boolean {

        if (matchJudgement()) {
            when (userType) {
                UserType.NewInstall -> {
                    if (showCount == 0) {
                        increaseShowCount()
                        updateCurrentVersion()
                        return true
                    } else {
                        return false
                    }
                }
                UserType.Regular -> {
                    //分为给了差评的和没给差评的
                    val rateResult = KeyValue.get(KEY_RATE_RESULT, "") ?: ""
                    if (TextUtils.isEmpty(rateResult) && showCount == 0) {
                        //没评论过并且没弹出过
                        increaseShowCount()
                        updateCurrentVersion()
                        return true
                    } else if (rateResult == RATE_RESULT_BAD) {
                        //差评的用户，做了版本升级
                        val currentVersion = getAppVersionCode(context)
                        val lastVersion = KeyValue.get(KEY_LAST_VERSION_CODE, 0L) ?: 0L
                        if (currentVersion > lastVersion) {
                            increaseShowCount()
                            updateCurrentVersion()
                            return true
                        } else if (KeyValue.get(KEY_RATE_CANCEL_TIME_REACH, false) ?: false) {
                            //如果差评没给评价退出了评分，需要超过7天才显示
                            increaseShowCount()
                            updateCurrentVersion()
                            KeyValue.put(KEY_RATE_CANCEL, false)
                            return true
                        }
                    } else if (showCount > 0 && KeyValue.get(KEY_RATE_CANCEL, false) ?: false) {
                        //上次没给评价退出了评分，需要超过7天才显示
                        if (KeyValue.get(KEY_RATE_CANCEL_TIME_REACH, false) ?: false) {
                            increaseShowCount()
                            updateCurrentVersion()
                            KeyValue.put(KEY_RATE_CANCEL, false)
                            return true
                        }
                    }
                    return false
                }
            }
        }
        return false
    }

}