package com.talpa.rate.strategy

import android.content.Context
import androidx.core.os.LocaleListCompat
import com.talpa.rate.strategy.data.*

/**
 * Create by chenjunsheng on 2021/12/17
 * @param strategyStr 标准的策略配置
 * 格式：
 * {
"enable": true,
"country": "",
"custom": 3,
"showTime": "10-22",
"version": 2
}

 * @param actionStrategy 1-5星的跳转行为
 * 格式：
 * {
"oneAction" : "",
"twoAction": "",
"threeAction":"",
"fourAction":"",
"fiveAction":""
}
 */
class StandardStrategy @JvmOverloads constructor(
    context: Context,
    strategyStr: String?,
    actionStrategy: String?,
    var debugable: Boolean = false
) : ReviewStrategyImpl(context) {

    protected var mRateRemoteConfig: RateRemoteConfig? = null
    protected var mRateRemoteAction: RateRemoteAction? = null

    init {

        strategyStr?.let {
            mRateRemoteConfig = RateRemoteConfig.parse(it)
        }

        actionStrategy?.let {
            mRateRemoteAction = RateRemoteAction.parse(it)
        }
    }

    override fun getSupportLocales(): LocaleListCompat {
        return mRateRemoteConfig?.country ?: LocaleListCompat.getEmptyLocaleList()
    }

    override fun enable(): Boolean {
        return mRateRemoteConfig?.enable ?: false
    }

    override fun getCustomType(): UserType {
        return mRateRemoteConfig?.custom ?: UserType.Regular
    }

    override fun getVersionType(): VersionType {
        return mRateRemoteConfig?.version ?: VersionType.Normal
    }

    override fun getShowTime(): List<EnableTime> {
        if (mRateRemoteConfig?.showTime.isNullOrEmpty() || mRateRemoteConfig?.showTime?.size != 2) {
            return arrayListOf(EnableTime(0), EnableTime(24))
        }
        return mRateRemoteConfig?.showTime ?: arrayListOf(EnableTime(0), EnableTime(24))
    }

    override fun getOneStarAction(): String? {
        return mRateRemoteAction?.oneAction
    }

    override fun getTwoStarsAction(): String? {
        return mRateRemoteAction?.twoAction
    }

    override fun getThreeStarsAction(): String? {
        return mRateRemoteAction?.threeAction
    }

    override fun getFourStarsAction(): String? {
        return mRateRemoteAction?.fourAction
    }

    override fun getFiveStarsAction(): String? {
        return mRateRemoteAction?.fiveAction
    }

    override fun getDebug(): Boolean {
        return debugable
    }
}