package com.talpa.rate.strategy.data

import android.annotation.SuppressLint
import androidx.annotation.Keep
import androidx.core.os.LocaleListCompat
import com.google.gson.*
import com.google.gson.annotations.SerializedName
import java.lang.reflect.Type

/**
 * Create by chenjunsheng on 2021/11/2
 */

/*{
    "enable": true, //是否启用
    "country": "zh,en", //国家
    "custom":1, //触发用户，新用户，老用户
    "showTime":"10:00-22:00", //展示时间
    "version":1 //触发版本，正常版本，引导版本
}*/

/*{
    "oneAction" : "",
    "twoAction": "",
    "threeAction":"",
    "fourAction":"",
    "fiveAction":""
}*/

@Keep
data class RateRemoteAction(
    @SerializedName("oneAction")
    var oneAction: String? = null,
    @SerializedName("twoAction")
    var twoAction: String? = null,
    @SerializedName("threeAction")
    var threeAction: String? = null,
    @SerializedName("fourAction")
    var fourAction: String? = null,
    @SerializedName("fiveAction")
    var fiveAction: String? = null
) {
    companion object {
        fun parse(str: String): RateRemoteAction {
            val gson = Gson()
            return gson.fromJson(str, RateRemoteAction::class.java)
        }
    }
}

@Keep
data class EnableTime(
    @SerializedName("hour")
    var hour: Int
)

@Keep
data class RateRemoteConfig(
    @SerializedName("enable")
    var enable: Boolean,
    @SerializedName("country")
    var country: LocaleListCompat,
    @SerializedName("custom")
    var custom: UserType,
    @SerializedName("showTime")
    var showTime: List<EnableTime>,
    @SerializedName("version")
    var version: VersionType
) {
    companion object {
        fun parse(str: String): RateRemoteConfig {
            val gson = GsonBuilder()
                .registerTypeHierarchyAdapter(LocaleListCompat::class.java, LocaleListDeserializer())
                .registerTypeHierarchyAdapter(UserType::class.java, UserTypeDeserializer())
                .registerTypeHierarchyAdapter(List::class.java, EnableTimeDeserializer())
                .registerTypeHierarchyAdapter(VersionType::class.java, VersionTypeDeserializer())
                .create()
            return gson.fromJson(str, RateRemoteConfig::class.java)
        }
    }
}

@Keep
class VersionTypeDeserializer : JsonDeserializer<VersionType> {
    override fun deserialize(
        json: JsonElement?,
        typeOfT: Type?,
        context: JsonDeserializationContext?
    ): VersionType {
        if (json == null) {
            return VersionType.Normal
        }
        val versionInt = json.asInt
        if (versionInt == 1) {
            return VersionType.Guidance
        } else {
            return VersionType.Normal
        }
    }

}

@Keep
class LocaleListDeserializer : JsonDeserializer<LocaleListCompat> {

    override fun deserialize(
        json: JsonElement?,
        typeOfT: Type?,
        context: JsonDeserializationContext?
    ): LocaleListCompat {
        if (json == null) {
            return LocaleListCompat.getEmptyLocaleList()
        }
        val localeStr = json.asString
        return LocaleListCompat.forLanguageTags(localeStr)
    }

}

@Keep
class EnableTimeDeserializer : JsonDeserializer<List<EnableTime>> {
    @SuppressLint("SimpleDateFormat")
    override fun deserialize(
        json: JsonElement?,
        typeOfT: Type?,
        context: JsonDeserializationContext?
    ): List<EnableTime> {
        if (json == null) {
            return emptyList()
        }
        try {
            val dateListStr = json.asString.split("-".toRegex())
            if (dateListStr.size != 2) {
                return arrayListOf(EnableTime(0), EnableTime(24))
            } else {
                return dateListStr.map {
                    EnableTime(
                        it.toInt()
                    )

                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return arrayListOf(EnableTime(0), EnableTime(24))
    }

}

@Keep
class UserTypeDeserializer : JsonDeserializer<UserType> {

    override fun deserialize(
        json: JsonElement?,
        typeOfT: Type?,
        context: JsonDeserializationContext?
    ): UserType {
        if (json == null) {
            return UserType.Regular
        }
        val userTypeInt = json.asInt
        if (userTypeInt == 1) {
            return UserType.NewInstall
        } else if (userTypeInt == 2) {
            return UserType.Regular
        } else {
            return UserType.All
        }
    }

}

@Keep
enum class UserType {
    NewInstall, Regular, All
}

@Keep
enum class VersionType {
    Normal, Guidance
}
