package com.talpa.translate.config

import android.app.ActivityManager
import android.content.Context
import android.net.ConnectivityManager
import android.text.TextUtils
import android.util.Log
import com.flurry.android.FlurryAgent
import com.flurry.android.FlurryConfig
import com.google.android.gms.tasks.Task
import com.talpa.translate.kv.KeyValue

/**
 * @author CY 2020-01-06
 */

/**
 * 离线翻译总开关
 * true
 * false
 */
const val KEY_SETTING_OFFLINE_TRANSLATE_SWITCH = "setting_offline_translate_switch"

/** 引导第二个界面用户使用指南是否展示开关 */
const val KEY_GUIDE_USER_REFERENCE_ENABLED = "guide_user_reference_enabled"

/**
 * server_subscription_key
 */
const val SERVER_SUBSCRIPTION_KEY = "server_subscription_key"

/**
 * server_subscription_secret
 */
const val SERVER_SUBSCRIPTION_SECRET = "server_subscription_secret"


/**
 * google_subscription_key
 */
const val GOOGLE_SUBSCRIPTION_KEY = "google_subscription_key"


/**
 * microsoft_subscription_key
 */
const val MICROSOFT_SUBSCRIPTION_KEY = "microsoft_subscription_key"

/**
 * yandex switch
 */
const val TRANSLATOR_YANDEX = "translator_yandex"

/**
 * 离线翻译开启日期
 * OFFLINE_TRANSLATE_DATE example:2020-01-01
 */
const val OFFLINE_TRANSLATE_LIMIT_DATE = "offline_translate_limit_date"

/**
 * 广告开启日期
 * AD_LIMIT_DATE example:2020-01-01
 */
const val AD_LIMIT_DATE = "ad_limit_date"

internal const val APP_VERSION = "app_version"

/**
 * 静默天数 Long,默认30天
 */
const val SILENCE_DAYS = "silence_days"

const val GOOGLE_VISION_API_ENABLE = "google_vision_api_enable"

///**
// * 返回 Remote Config
// */
//fun remoteConfig(): FirebaseRemoteConfig {
//    return RemoteConfigHelper.remoteConfig()
//}

const val ADMOB_PLACEMENT_ID_HOME = "placementID_settingBottom_admob_native"
const val AUDIENCE_PLACEMENT_ID_HOME = "placementID_settingBottom_facebook"
//audience

fun initRemoteConfig(context: Context, flurryKey: String): Task<Boolean>? {
    RemoteConfigHelper.initRemoteConfig(context)
    initFlurry(context, flurryKey)
    KeyValue.init(context)
    return context.fetchConfig()
}

/**
 * Flurry 初始化，相同Key 时可以进行多次初始化
 * {@link https://developer.yahoo.com/flurry/docs/integrateflurry/android/}
 */
private fun initFlurry(context: Context, key: String) {
    FlurryAgent.Builder()
        .withCaptureUncaughtExceptions(true)
        .withIncludeBackgroundSessionsInMetrics(true)
        .withLogLevel(Log.VERBOSE)
        .withLogEnabled(BuildConfig.DEBUG)
        //.withSslPinningEnabled()
        .build(context, key)
}

/**
 * Get String From Firebase Remote Config
 */
fun Context.getStringFromRemoteConfig(key: String): String? {
    val value = RemoteConfigHelper.remoteConfig(context = this)?.getString(key)
    val value2 = if (TextUtils.isEmpty(value)) {
        FlurryConfig.getInstance().getString(key, null)
    } else value

    if (value2 == null) {
        fetchConfig()
    }
    return value2
}

/**
 * Get String From Firebase Remote Config
 */
fun Context.getLongFromRemoteConfig(key: String): Long? {
    val value =
        RemoteConfigHelper.remoteConfig(context = this)
            ?.getLong(key)
            ?: FlurryConfig.getInstance().getLong(key, -1)
    if (value == -1L) {
        fetchConfig()
    }
    return value
}

/**
 * Get String From Firebase Remote Config
 */
fun Context.getBooleanFromRemoteConfig(key: String): Boolean? {
    return RemoteConfigHelper.remoteConfig(context = this)
        ?.getBoolean(key)
        ?: FlurryConfig.getInstance().getBoolean(key, false)
}


/**
 * 静默日期
 */
fun silenceDate(defaultDays: Int = 30): Long {

    val key = "key_first_set_up_date"

    var setupDate = KeyValue.get(key) ?: -1L
    if (setupDate == -1L) {
        setupDate = System.currentTimeMillis()
        KeyValue.put(key, setupDate)
    }

    //println("start=$start  end=$end  du=$du  defaultDays=$defaultDays")

    return setupDate + 1000L * 60 * 60 * 24 * defaultDays
}

/**
 * 获取远程配置
 */
private fun Context.fetchConfig() : Task<Boolean>? {
    if (isNetworkConnected() && !ActivityManager.isUserAMonkey()) {
        FlurryConfig.getInstance().fetchConfig()
        return RemoteConfigHelper.fetch(applicationContext)
    }
    return null
}

private fun Context.isNetworkConnected(): Boolean {

    val connectivityManager =
        getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
    val networkInfo = connectivityManager.activeNetworkInfo
    return networkInfo?.isAvailable == true && networkInfo.isConnected
}