package com.talpa.translate.config

import android.content.Context
import android.text.TextUtils
import com.google.android.gms.tasks.Task
import com.google.firebase.FirebaseApp
import com.google.firebase.remoteconfig.FirebaseRemoteConfig
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings


/**
 * Firebase工具类
 * Created by jun.wen on 2018/4/20.
 */

object RemoteConfigHelper {

    private val CACHE_EXPIRATION: Long = 60

    //private lateinit var mContext: Application

    private var mFirebaseRemoteConfig: FirebaseRemoteConfig? = null

    internal fun initRemoteConfig(context: Context) {
        FirebaseApp.initializeApp(context)
        mFirebaseRemoteConfig = FirebaseRemoteConfig.getInstance()
        val configSettings = FirebaseRemoteConfigSettings.Builder()
            .setMinimumFetchIntervalInSeconds(CACHE_EXPIRATION)
            .build()
        mFirebaseRemoteConfig?.setConfigSettingsAsync(configSettings)
        mFirebaseRemoteConfig?.setDefaultsAsync(R.xml.remote_config_defaults)
    }

    fun remoteConfig(context: Context): FirebaseRemoteConfig? {
        return mFirebaseRemoteConfig

    }

    /**
     * Firebase远程配置请求
     */
    internal fun fetch(context: Context) : Task<Boolean>? {
        return remoteConfig(context)?.fetchAndActivate()
    }


    /**------------------------------Firebase远程配置读取 start------------------------------- */

    internal fun getString(context: Context, key: String): String? {
        return remoteConfig(context)?.getString(key)
    }

    internal fun getLong(context: Context, key: String): Long? {
        return remoteConfig(context)?.getLong(key)
    }


    /**
     * 填充优先级
     * @param adPlace
     * @return
     */
    fun getPrioritys(priority: String): List<String>? {
        if (TextUtils.isEmpty(priority)) {
            return null
        }
        return priority.replace(" ", "").split(",")
    }

    val AD_CONFIGS = "ad_configs"

    const val ADMOB_PLACEMENTID_HOME_REWARDEDVIDEO = "placementID_home_RewardedVideo_admob"
    const val ADMOB_PLACEMENTID_HOME_BOTTOM = "placementID_settingBottom_admob_native"

    val ADMOB_APPID = "admob_appid"
    val APP_VERSION = "app_version"

    var COLLINS_ACCESS_KEY = "collins_access_key"
    var TRANSLATOR_CONFIG = "translator_config"
    var GUARANTEED_ADVERTISING_URL =
        "guaranteed_advertising_url"// https://play.google.com/store/apps/details?id=com.collo.translateapp


}
