/*
 * Decompiled with CFR 0.152.
 */
package com.tapla.textspeech;

import android.app.Application;
import android.content.Context;
import android.media.AudioManager;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u001b\u001a\u00020\u0007H\u0002J\u0006\u0010\u001c\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/tapla/textspeech/TextSpeech;", "Landroid/speech/tts/TextToSpeech$OnInitListener;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "()V", "mApplication", "Landroid/app/Application;", "textToSpeech", "Landroid/speech/tts/TextToSpeech;", "init", "", "application", "isLanguageAvailable", "", "locale", "Ljava/util/Locale;", "isSpeaking", "matchCode", "code", "", "onAudioFocusChange", "focusChange", "onInit", "status", "requestAudioFocus", "speak", "text", "", "speech", "stopSpeak", "OnUtteranceProgressListener", "textspeech_release"})
public final class TextSpeech
implements TextToSpeech.OnInitListener,
AudioManager.OnAudioFocusChangeListener {
    private static TextToSpeech textToSpeech;
    private static Application mApplication;
    @NotNull
    public static final TextSpeech INSTANCE;

    public void onInit(int status) {
        if (status != 0) {
            textToSpeech = null;
        }
    }

    public final void init(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        mApplication = application;
        try {
            this.speech();
            TextToSpeech textToSpeech = TextSpeech.textToSpeech;
            if (textToSpeech != null) {
                textToSpeech.setOnUtteranceProgressListener((UtteranceProgressListener)new OnUtteranceProgressListener(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final TextToSpeech speech() {
        TextToSpeech textToSpeech = TextSpeech.textToSpeech;
        if (textToSpeech == null) {
            Application application = mApplication;
            if (application == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
            }
            TextToSpeech textToSpeech2 = new TextToSpeech((Context)application, (TextToSpeech.OnInitListener)this);
            boolean bl = false;
            boolean bl2 = false;
            TextToSpeech $this$apply = textToSpeech2;
            boolean bl3 = false;
            TextSpeech.textToSpeech = $this$apply;
            $this$apply.setSpeechRate(0.8f);
            textToSpeech = textToSpeech2;
        }
        return textToSpeech;
    }

    public final boolean speak(@NotNull CharSequence text, @NotNull Locale locale) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        TextToSpeech textToSpeech = null;
        try {
            textToSpeech = this.speech();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int code = textToSpeech.setLanguage(locale);
        if (this.matchCode(code)) {
            boolean isSuccess;
            int status = textToSpeech.speak(text, 0, null, String.valueOf(System.currentTimeMillis()));
            boolean bl2 = isSuccess = status == 0;
            if (isSuccess) {
                Application application = mApplication;
                if (application == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
                }
                this.requestAudioFocus(application);
            }
            bl = isSuccess;
        } else {
            TextSpeech.textToSpeech = null;
            bl = false;
        }
        return bl;
    }

    public final void stopSpeak() {
        TextToSpeech textToSpeech = this.speech();
        if (textToSpeech.isSpeaking()) {
            this.speech().stop();
        }
    }

    public final boolean isSpeaking() {
        return this.speech().isSpeaking();
    }

    public final boolean isLanguageAvailable(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        TextToSpeech textToSpeech = this.speech();
        int code = textToSpeech.isLanguageAvailable(locale);
        return this.matchCode(code);
    }

    private final boolean matchCode(int code) {
        return code == 0 || code == 2 || code == 1;
    }

    private final void requestAudioFocus(Application application) {
        Object object = application.getSystemService("audio");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
        }
        AudioManager audioManager = (AudioManager)object;
        audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 2);
    }

    public void onAudioFocusChange(int focusChange) {
        if (focusChange == -1) {
            this.stopSpeak();
        }
    }

    private TextSpeech() {
    }

    static {
        TextSpeech textSpeech;
        INSTANCE = textSpeech = new TextSpeech();
    }

    public static final /* synthetic */ Application access$getMApplication$p(TextSpeech $this) {
        TextSpeech textSpeech = $this;
        Application application = mApplication;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mApplication");
        }
        return application;
    }

    public static final /* synthetic */ void access$setMApplication$p(TextSpeech $this, Application application) {
        TextSpeech textSpeech = $this;
        mApplication = application;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/tapla/textspeech/TextSpeech$OnUtteranceProgressListener;", "Landroid/speech/tts/UtteranceProgressListener;", "textSpeech", "Lcom/tapla/textspeech/TextSpeech;", "(Lcom/tapla/textspeech/TextSpeech;)V", "getTextSpeech", "()Lcom/tapla/textspeech/TextSpeech;", "onDone", "", "utteranceId", "", "onError", "onStart", "textspeech_release"})
    private static final class OnUtteranceProgressListener
    extends UtteranceProgressListener {
        @NotNull
        private final TextSpeech textSpeech;

        public void onDone(@Nullable String utteranceId) {
            Object object = TextSpeech.access$getMApplication$p(INSTANCE).getSystemService("audio");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
            }
            AudioManager audioManager = (AudioManager)object;
            audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this.textSpeech);
        }

        public void onError(@Nullable String utteranceId) {
        }

        public void onStart(@Nullable String utteranceId) {
        }

        @NotNull
        public final TextSpeech getTextSpeech() {
            return this.textSpeech;
        }

        public OnUtteranceProgressListener(@NotNull TextSpeech textSpeech) {
            Intrinsics.checkNotNullParameter((Object)textSpeech, (String)"textSpeech");
            this.textSpeech = textSpeech;
        }
    }
}

