package com.talpa.translator.link

import android.content.Context
import android.text.TextUtils
import androidx.annotation.Keep
import com.talpa.tengine.Trans
import com.talpa.tengine.translateByOFSCTranslator
import com.talpa.translate.config.*
import io.reactivex.Flowable
import java.text.SimpleDateFormat
import java.util.*

/**
 *
 * Translate Link 链接翻译引擎中间件
 *
 * @author CY 2020/4/14
 */

/**
 * Translate
 */
fun Context.translate(trans: Trans): Flowable<Trans> {

    return translateByOFSCTranslator(trans) {
        setServerAppKey(getServerAppKey())
        setServerAppSecret(getServerAppSecret())
        setGoogleKey(getGoogleKey())
        setMicrosoftKey(getMicrosoftKey())
        isDownloadModelIfNeeded(isDownloadModelIfNeeded = false)
        isEnabledOfflineTranslate(isEnabledOfflineTranslate = isEnabledOfflineTranslate())
        isEnabledYandex(isEnabledYandex())
    }
}


@Keep
private fun Context.getServerAppKey(): String? {
    val key = getStringFromRemoteConfig(SERVER_SUBSCRIPTION_KEY)
    if (TextUtils.isEmpty(key)) {
        return "123transsion"
    }
    return key
}

@Keep
private fun Context.getServerAppSecret(): String? {
    val key = getStringFromRemoteConfig(SERVER_SUBSCRIPTION_SECRET)
    return key
}

@Keep
private fun Context.getGoogleKey(): String? {
    return getStringFromRemoteConfig(GOOGLE_SUBSCRIPTION_KEY)
}

@Keep
private fun Context.getMicrosoftKey(): String? {
    return getStringFromRemoteConfig(MICROSOFT_SUBSCRIPTION_KEY)
}

@Keep
private fun Context.getOfflineTranslateLimitDate(): Date {
    val defaultDate = "2030-01-01"
    val simpleDateFormat = SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH)
    return try {
        val dateStr = getStringFromRemoteConfig(OFFLINE_TRANSLATE_LIMIT_DATE) ?: defaultDate
        simpleDateFormat.parse(dateStr)
    } catch (e: java.lang.Exception) {
        simpleDateFormat.parse(defaultDate)
    }
}

@Keep
private fun Context.isEnabledOfflineTranslate(): Boolean {
    val limitDate = getOfflineTranslateLimitDate()
    val currentDate = Date()
    return !currentDate.before(limitDate)
}


@Keep
private fun Context.isEnabledYandex(): Boolean {
    return getBooleanFromRemoteConfig("translator_yandex") ?: false
}