package com.talpa.translator.link

import android.content.Context
import android.text.TextUtils
import android.util.Base64
import com.talpa.translate.config.*

/**
 * @author CY 2020/6/19
 */


fun Context.getServerAppKey(): String? {
    val key = getGlobalServerAppKey() ?: getStringFromRemoteConfig(SERVER_SUBSCRIPTION_KEY)
    if (TextUtils.isEmpty(key)) {
        return getString(R.string.s_ky).decode()
    }
    return key
}

fun Context.getServerAppSecret(): String? {
    val secret = getGlobalServerAppSecret() ?: getStringFromRemoteConfig(SERVER_SUBSCRIPTION_SECRET)
    if (TextUtils.isEmpty(secret)) {
        return getString(R.string.s_st).decode()
    }
    return secret
}

fun Context.getGoogleKey(): String? {
    return getStringFromRemoteConfig(GOOGLE_SUBSCRIPTION_KEY)
}

fun Context.getMicrosoftKey(): String? {
    return getStringFromRemoteConfig(MICROSOFT_SUBSCRIPTION_KEY)
}

fun Context.getOfflineTranslateLimitDate(): Long {

    val days = getLongFromRemoteConfig(SILENCE_DAYS)?.toInt() ?: 30
    if (days <= 0) {
        return silenceDate()
    }
    return silenceDate(days)
}

fun Context.isEnabledOfflineTranslate(): Boolean {
    val limitDate = getOfflineTranslateLimitDate()
    val currentDate = System.currentTimeMillis()
    return currentDate >= limitDate
}


fun Context.isEnabledYandex(): Boolean {
    return getBooleanFromRemoteConfig("translator_yandex") ?: false
}

fun Context.getGlobalServerAppKey(): String? {

    val prefer = applicationContext.getSharedPreferences("prefer_server_key", Context.MODE_PRIVATE)
    return prefer.getString("key_global_server_app_key", null)
}

fun Context.getGlobalServerAppSecret(): String? {

    val prefer = applicationContext.getSharedPreferences("prefer_server_key", Context.MODE_PRIVATE)
    return prefer.getString("key_global_server_app_secret", null)
}

fun Context.writeGlobalServerAppKey(appKey: String?) {

    val name = "prefer_server_key"
    val key = "key_global_server_app_key"
    val prefer = applicationContext.getSharedPreferences(name, Context.MODE_PRIVATE)
    if (appKey == null) {
        prefer.edit().remove(key).apply()
    } else {
        prefer.edit().putString(key, appKey).apply()
    }


}

fun Context.writeGlobalServerAppSecret(appSecret: String?) {


    val name = "prefer_server_key"
    val key = "key_global_server_app_secret"

    val prefer = applicationContext.getSharedPreferences(name, Context.MODE_PRIVATE)

    if (appSecret == null) {
        prefer.edit().remove(key).apply()
    } else {
        prefer.edit().putString(key, appSecret).apply()
    }
}


/**
 * String 加密
 */
internal fun String.encode(): String {
    return reversed().encode64().encode64()
}

/**
 * String 解密
 */
internal fun String.decode(): String {
    return decode64().decode64().reversed()
}

internal fun String.decode64(): String {
    return Base64.decode(this, Base64.DEFAULT)
        .toString(Charsets.UTF_8)
}

internal fun String.encode64(): String {
    return Base64.encodeToString(this.toByteArray(Charsets.UTF_8), Base64.DEFAULT)
}