package com.talpa.translator.link

import android.content.Context
import androidx.annotation.Keep
import com.talpa.tengine.Trans
import com.talpa.tengine.translateByOSCTranslator
import io.reactivex.Flowable

/**
 *
 * Translate Link 链接翻译引擎中间件
 *
 * @author CY 2020/4/14
 */

/**
 * Translate
 */
@Keep
fun Context.translate(trans: Trans): Flowable<Trans> {

    //Offline -> Free -> Server -> Charge
    /*return translateByOFSCTranslator(trans) {
        setServerAppKey(getServerAppKey())
        setServerAppSecret(getServerAppSecret())
        setGoogleKey(getGoogleKey())
        setMicrosoftKey(getMicrosoftKey())
        isDownloadModelIfNeeded(isDownloadModelIfNeeded = false)
        isEnabledOfflineTranslate(isEnabledOfflineTranslate = true)//isEnabledOfflineTranslate()
        isEnabledYandex(applicationContext.isEnabledYandex())
    }*/
    //Server -> Charge
    /*return translateBySCTranslator(trans) {
        setServerAppKey(getServerAppKey())
        setServerAppSecret(getServerAppSecret())
        setGoogleKey(getGoogleKey())
        setMicrosoftKey(getMicrosoftKey())
        //isDownloadModelIfNeeded(isDownloadModelIfNeeded = false)
        //isEnabledOfflineTranslate(isEnabledOfflineTranslate = isEnabledOfflineTranslate())
        //isEnabledYandex(isEnabledYandex())
    }*/
    //Offline -> Server -> Charge
    return translateByOSCTranslator(trans) {
        setServerAppKey(getServerAppKey())
        setServerAppSecret(getServerAppSecret())
        setGoogleKey(getGoogleKey())
        setMicrosoftKey(getMicrosoftKey())
        isDownloadModelIfNeeded(isDownloadModelIfNeeded = false)
        isEnabledOfflineTranslate(isEnabledOfflineTranslate = true)//isEnabledOfflineTranslate()
    }
}

