/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import com.talpa.tengine.store.TranslationStoreKt;
import com.talpa.translate.Hex;
import com.talpa.translate.HiTranslator;
import com.talpa.translator.link.TranslatorLinkKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 %2\u00020\u0001:\u0005#$%&'B1\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0003H\u0002J0\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\u0003*\u00020\u0003H\u0002R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lcom/talpa/translate/HiTranslator;", "", "sourceLanguage", "", "targetLanguage", "text", "appKey", "secret", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "apiService", "Lcom/talpa/translate/HiTranslator$ApiService;", "getApiService", "()Lcom/talpa/translate/HiTranslator$ApiService;", "apiService$delegate", "Lkotlin/Lazy;", "connect", "Lcom/talpa/translate/HiTranslator$Result;", "execute", "generateNonce", "generateSign", "timestamp", "", "nonce", "parserJson", "json", "provideCache", "Lokhttp3/Cache;", "readInputStream", "inputStream", "Ljava/io/InputStream;", "writeOutputStream", "", "outputStream", "Ljava/io/OutputStream;", "md5", "ApiService", "Builder", "Companion", "HttpLogger", "Result", "translator-link_release"})
@Keep
public final class HiTranslator {
    private final Lazy apiService$delegate;
    private final String sourceLanguage;
    private final String targetLanguage;
    private final String text;
    private final String appKey;
    private final String secret;
    private static final String BASE_URL = "https://api.translasion.com";
    private static final int CONNECT_TIME_OUT = 6000;
    private static final int READ_TIME_OUT = 8000;
    private static final String REQUEST_METHOD = "POST";
    private static final String CONTENT_TYPE = "application/json";
    @NotNull
    private static final HashMap<String, String> supportLanguageMap;
    public static final Companion Companion;

    private final ApiService getApiService() {
        Lazy lazy = this.apiService$delegate;
        HiTranslator hiTranslator = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ApiService)lazy.getValue();
    }

    private final Cache provideCache() {
        File file = Environment.getDataDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getDataDirectory()");
        return new Cache(file, 0xA00000L);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result execute() {
        void sig;
        void nonce;
        void timestamp;
        String translation = TranslationStoreKt.readTranslation(this.sourceLanguage, this.targetLanguage, this.text);
        if (!TextUtils.isEmpty((CharSequence)translation)) {
            return new Result(this.sourceLanguage, this.targetLanguage, this.text, translation, 1000, null, true, false, 160, null);
        }
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = System.currentTimeMillis() / (long)1000;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.generateNonce();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = this.generateSign(this.appKey, this.targetLanguage, timestamp.element, this.secret, (String)nonce.element);
        Result result2 = (Result)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result>, Object>(this, (Ref.LongRef)timestamp, (Ref.ObjectRef)sig, (Ref.ObjectRef)nonce, null){
            private CoroutineScope p$;
            Object L$0;
            int label;
            final /* synthetic */ HiTranslator this$0;
            final /* synthetic */ Ref.LongRef $timestamp;
            final /* synthetic */ Ref.ObjectRef $sig;
            final /* synthetic */ Ref.ObjectRef $nonce;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        execute.result.1 var3_5 = this;
                        String string2 = HiTranslator.access$getAppKey$p(this.this$0);
                        String string3 = (String)this.$nonce.element;
                        String string4 = HiTranslator.access$getSourceLanguage$p(this.this$0);
                        String string5 = HiTranslator.access$getTargetLanguage$p(this.this$0);
                        String string6 = (String)this.$sig.element;
                        String string7 = String.valueOf(this.$timestamp.element);
                        this.L$0 = $this$runBlocking;
                        this.label = 1;
                        Object object2 = HiTranslator.access$getApiService$p(this.this$0).translate(HiTranslator.access$getText$p(this.this$0), string5, string2, string3, string7, string4, string6, (Continuation<? super Result>)var3_5);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = hiTranslator;
                this.$timestamp = longRef;
                this.$sig = objectRef;
                this.$nonce = objectRef2;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Result>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (!TextUtils.isEmpty((CharSequence)result2.getTranslation())) {
            String string2 = result2.getTranslation();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            TranslationStoreKt.storeTranslation(this.sourceLanguage, this.targetLanguage, this.text, string2);
        }
        return result2;
    }

    private final Result connect() {
        InputStream inputStream;
        OutputStream outputStream;
        URL url = new URL(BASE_URL);
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setRequestProperty("content-type", CONTENT_TYPE);
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(8000);
        connection.setDefaultUseCaches(true);
        connection.setDoOutput(true);
        OutputStream outputStream2 = outputStream = connection.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"outputStream");
        this.writeOutputStream(outputStream2);
        outputStream.close();
        InputStream inputStream2 = inputStream = connection.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
        Result result2 = this.readInputStream(inputStream2);
        inputStream.close();
        connection.disconnect();
        return result2;
    }

    private final void writeOutputStream(OutputStream outputStream) {
        String json;
        long timestamp = System.currentTimeMillis() / (long)1000;
        String nonce = this.generateNonce();
        String sig = this.generateSign(this.appKey, this.targetLanguage, timestamp, this.secret, nonce);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("app_key", (Object)this.appKey);
        jsonObj.put("to", (Object)this.targetLanguage);
        jsonObj.put("text", (Object)this.text);
        jsonObj.put("timestamp", timestamp);
        jsonObj.put("nonce", (Object)nonce);
        jsonObj.put("sig", (Object)sig);
        if (this.sourceLanguage != null) {
            jsonObj.put("from", (Object)this.sourceLanguage);
        }
        String string2 = jsonObj.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jsonObj.toString()");
        String string3 = json = string2;
        OutputStream outputStream2 = outputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        outputStream2.write(byArray2);
        outputStream.flush();
    }

    private final String generateNonce() {
        Object[] charArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
        IntRange intRange = ArraysKt.getIndices((Object[])charArray);
        boolean bl = false;
        int index1 = RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default));
        IntRange intRange2 = ArraysKt.getIndices((Object[])charArray);
        boolean bl2 = false;
        int index2 = RangesKt.random((IntRange)intRange2, (Random)((Random)Random.Default));
        IntRange intRange3 = ArraysKt.getIndices((Object[])charArray);
        boolean bl3 = false;
        int index3 = RangesKt.random((IntRange)intRange3, (Random)((Random)Random.Default));
        IntRange intRange4 = ArraysKt.getIndices((Object[])charArray);
        boolean bl4 = false;
        int index4 = RangesKt.random((IntRange)intRange4, (Random)((Random)Random.Default));
        return "" + ((Character)charArray[index1]).charValue() + ((Character)charArray[index2]).charValue() + ((Character)charArray[index3]).charValue() + ((Character)charArray[index4]).charValue();
    }

    private final String generateSign(String appKey, String targetLanguage, long timestamp, String secret, String nonce) {
        String value = appKey + '&' + targetLanguage + '&' + timestamp + '&' + secret + '&' + nonce;
        return this.md5(value);
    }

    private final String md5(@NotNull String $this$md5) {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string2 = $this$md5;
        MessageDigest messageDigest = digest;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] data = messageDigest.digest(byArray2);
        char[] charArray = Hex.encodeHex(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)charArray, (String)"charArray");
        object = charArray;
        bl = false;
        return new String((char[])object);
    }

    private final Result readInputStream(InputStream inputStream) {
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        boolean bl = false;
        String content = new String(bytes, Charsets.UTF_8);
        return this.parserJson(content);
    }

    private final Result parserJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        String keyCode = "code";
        String keyMessage = "message";
        String keyResult = "result";
        String keyText = "text";
        int valueCode = 0;
        String valueMessage = null;
        String valueText = null;
        if (jsonObject.has(keyCode)) {
            valueCode = jsonObject.getInt(keyCode);
        }
        if (jsonObject.has(keyMessage)) {
            valueMessage = jsonObject.getString(keyMessage);
        }
        if (jsonObject.has(keyResult)) {
            JSONObject valueResult = jsonObject.getJSONObject(keyResult);
            valueText = valueResult.getString(keyText);
        }
        return new Result(this.sourceLanguage, this.targetLanguage, this.text, valueText, valueCode, valueMessage, false, false, 192, null);
    }

    private HiTranslator(String sourceLanguage, String targetLanguage, String text, String appKey, String secret) {
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.text = text;
        this.appKey = appKey;
        this.secret = secret;
        this.apiService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ApiService>(this){
            final /* synthetic */ HiTranslator this$0;

            public final ApiService invoke() {
                ApiService apiService2;
                if (TranslatorLinkKt.getDEBUG()) {
                    HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger());
                    logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                    Retrofit.Builder builder = new Retrofit.Builder().baseUrl("https://api.translasion.com").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(new OkHttpClient.Builder().cache(HiTranslator.access$provideCache(this.this$0)).addNetworkInterceptor((Interceptor)logInterceptor).build());
                    apiService2 = (ApiService)builder.build().create(ApiService.class);
                } else {
                    Retrofit.Builder builder = new Retrofit.Builder().baseUrl("https://api.translasion.com").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(new OkHttpClient.Builder().cache(HiTranslator.access$provideCache(this.this$0)).build());
                    apiService2 = (ApiService)builder.build().create(ApiService.class);
                }
                return apiService2;
            }
            {
                this.this$0 = hiTranslator;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        HashMap hashMap = new HashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap $this$apply = hashMap;
        boolean bl4 = false;
        ((Map)$this$apply).put("auto", "auto");
        ((Map)$this$apply).put("af", "af");
        ((Map)$this$apply).put("sq", "sq");
        ((Map)$this$apply).put("am", "am");
        ((Map)$this$apply).put("ar", "ar");
        ((Map)$this$apply).put("hy", "hy");
        ((Map)$this$apply).put("az", "az");
        ((Map)$this$apply).put("eu", "eu");
        ((Map)$this$apply).put("be", "be");
        ((Map)$this$apply).put("bn", "bn");
        ((Map)$this$apply).put("bs", "bs");
        ((Map)$this$apply).put("bg", "bg");
        ((Map)$this$apply).put("ca", "ca");
        ((Map)$this$apply).put("ceb", "ceb");
        ((Map)$this$apply).put("zh", "zh");
        ((Map)$this$apply).put("zh-TW", "zh-TW");
        ((Map)$this$apply).put("co", "co");
        ((Map)$this$apply).put("hr", "hr");
        ((Map)$this$apply).put("cs", "cs");
        ((Map)$this$apply).put("da", "da");
        ((Map)$this$apply).put("nl", "nl");
        ((Map)$this$apply).put("en", "en");
        ((Map)$this$apply).put("eo", "eo");
        ((Map)$this$apply).put("et", "et");
        ((Map)$this$apply).put("fi", "fi");
        ((Map)$this$apply).put("fr", "fr");
        ((Map)$this$apply).put("fy", "fy");
        ((Map)$this$apply).put("gl", "gl");
        ((Map)$this$apply).put("ka", "ka");
        ((Map)$this$apply).put("de", "de");
        ((Map)$this$apply).put("el", "el");
        ((Map)$this$apply).put("gu", "gu");
        ((Map)$this$apply).put("ht", "ht");
        ((Map)$this$apply).put("ha", "ha");
        ((Map)$this$apply).put("haw", "haw");
        ((Map)$this$apply).put("he", "he");
        ((Map)$this$apply).put("hi", "hi");
        ((Map)$this$apply).put("hmn", "hmn");
        ((Map)$this$apply).put("hu", "hu");
        ((Map)$this$apply).put("is", "is");
        ((Map)$this$apply).put("ig", "ig");
        ((Map)$this$apply).put("id", "id");
        ((Map)$this$apply).put("ga", "ga");
        ((Map)$this$apply).put("it", "it");
        ((Map)$this$apply).put("ja", "ja");
        ((Map)$this$apply).put("jv", "jv");
        ((Map)$this$apply).put("kn", "kn");
        ((Map)$this$apply).put("kk", "kk");
        ((Map)$this$apply).put("km", "km");
        ((Map)$this$apply).put("rw", "rw");
        ((Map)$this$apply).put("ko", "ko");
        ((Map)$this$apply).put("ku", "ku");
        ((Map)$this$apply).put("ky", "ky");
        ((Map)$this$apply).put("lo", "lo");
        ((Map)$this$apply).put("la", "la");
        ((Map)$this$apply).put("lv", "lv");
        ((Map)$this$apply).put("lt", "lt");
        ((Map)$this$apply).put("lb", "lb");
        ((Map)$this$apply).put("mk", "mk");
        ((Map)$this$apply).put("mg", "mg");
        ((Map)$this$apply).put("ms", "ms");
        ((Map)$this$apply).put("ml", "ml");
        ((Map)$this$apply).put("mt", "mt");
        ((Map)$this$apply).put("mi", "mi");
        ((Map)$this$apply).put("mr", "mr");
        ((Map)$this$apply).put("mn", "mn");
        ((Map)$this$apply).put("my", "my");
        ((Map)$this$apply).put("ne", "ne");
        ((Map)$this$apply).put("no", "no");
        ((Map)$this$apply).put("ny", "ny");
        ((Map)$this$apply).put("or", "or");
        ((Map)$this$apply).put("ps", "ps");
        ((Map)$this$apply).put("fa", "fa");
        ((Map)$this$apply).put("pl", "pl");
        ((Map)$this$apply).put("pt", "pt");
        ((Map)$this$apply).put("pa", "pa");
        ((Map)$this$apply).put("ro", "ro");
        ((Map)$this$apply).put("ru", "ru");
        ((Map)$this$apply).put("sm", "sm");
        ((Map)$this$apply).put("gd", "gd");
        ((Map)$this$apply).put("sr", "sr");
        ((Map)$this$apply).put("st", "st");
        ((Map)$this$apply).put("sn", "sn");
        ((Map)$this$apply).put("sd", "sd");
        ((Map)$this$apply).put("si", "si");
        ((Map)$this$apply).put("sk", "sk");
        ((Map)$this$apply).put("sl", "sl");
        ((Map)$this$apply).put("so", "so");
        ((Map)$this$apply).put("es", "es");
        ((Map)$this$apply).put("su", "su");
        ((Map)$this$apply).put("sw", "sw");
        ((Map)$this$apply).put("sv", "sv");
        ((Map)$this$apply).put("tl", "tl");
        ((Map)$this$apply).put("fil", "tl");
        ((Map)$this$apply).put("tg", "tg");
        ((Map)$this$apply).put("ta", "ta");
        ((Map)$this$apply).put("tt", "tt");
        ((Map)$this$apply).put("te", "te");
        ((Map)$this$apply).put("th", "th");
        ((Map)$this$apply).put("tr", "tr");
        ((Map)$this$apply).put("tk", "tk");
        ((Map)$this$apply).put("uk", "uk");
        ((Map)$this$apply).put("ur", "ur");
        ((Map)$this$apply).put("ug", "ug");
        ((Map)$this$apply).put("uz", "uz");
        ((Map)$this$apply).put("vi", "vi");
        ((Map)$this$apply).put("cy", "cy");
        ((Map)$this$apply).put("xh", "xh");
        ((Map)$this$apply).put("yi", "yi");
        ((Map)$this$apply).put("yo", "yo");
        ((Map)$this$apply).put("zu", "zu");
        supportLanguageMap = hashMap;
    }

    public /* synthetic */ HiTranslator(String sourceLanguage, String targetLanguage, String text, String appKey, String secret, DefaultConstructorMarker $constructor_marker) {
        this(sourceLanguage, targetLanguage, text, appKey, secret);
    }

    public static final /* synthetic */ ApiService access$getApiService$p(HiTranslator $this) {
        return $this.getApiService();
    }

    public static final /* synthetic */ String access$getText$p(HiTranslator $this) {
        return $this.text;
    }

    public static final /* synthetic */ String access$getTargetLanguage$p(HiTranslator $this) {
        return $this.targetLanguage;
    }

    public static final /* synthetic */ String access$getSourceLanguage$p(HiTranslator $this) {
        return $this.sourceLanguage;
    }

    public static final /* synthetic */ String access$getAppKey$p(HiTranslator $this) {
        return $this.appKey;
    }

    public static final /* synthetic */ Cache access$provideCache(HiTranslator $this) {
        return $this.provideCache();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/talpa/translate/HiTranslator$HttpLogger;", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "()V", "log", "", "message", "", "translator-link_release"})
    public static final class HttpLogger
    implements HttpLoggingInterceptor.Logger {
        public void log(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Log.d((String)"okhttp", (String)message);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\bg\u0018\u00002\u00020\u0001JY\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00052\b\b\u0001\u0010\u0007\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\u00052\b\b\u0001\u0010\t\u001a\u00020\u00052\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/talpa/translate/HiTranslator$ApiService;", "", "translate", "Lcom/talpa/translate/HiTranslator$Result;", "text", "", "targetLanguage", "app_key", "nonce", "timestamp", "from", "sig", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "translator-link_release"})
    @Keep
    public static interface ApiService {
        @FormUrlEncoded
        @POST(value="/v2/translate")
        @Nullable
        public Object translate(@Field(value="text") @NotNull String var1, @Field(value="to") @NotNull String var2, @Field(value="app_key") @NotNull String var3, @Field(value="nonce") @NotNull String var4, @Field(value="timestamp") @NotNull String var5, @Field(value="from") @Nullable String var6, @Field(value="sig") @NotNull String var7, @NotNull Continuation<? super Result> var8);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/talpa/translate/HiTranslator$Builder;", "", "()V", "appKey", "", "secret", "sourceLanguage", "targetLanguage", "text", "build", "Lcom/talpa/translate/HiTranslator;", "setAppKey", "setSecret", "setSourceLanguage", "setTargetLanguage", "setText", "translator-link_release"})
    public static final class Builder {
        private String sourceLanguage;
        private String targetLanguage;
        private String text;
        private String appKey;
        private String secret;

        @NotNull
        public final Builder setSourceLanguage(@Nullable String sourceLanguage) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.sourceLanguage = sourceLanguage;
            return builder;
        }

        @NotNull
        public final Builder setTargetLanguage(@NotNull String targetLanguage) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.targetLanguage = targetLanguage;
            return builder;
        }

        @NotNull
        public final Builder setText(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.text = text;
            return builder;
        }

        @NotNull
        public final Builder setAppKey(@NotNull String appKey) {
            Intrinsics.checkParameterIsNotNull((Object)appKey, (String)"appKey");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.appKey = appKey;
            return builder;
        }

        @NotNull
        public final Builder setSecret(@NotNull String secret) {
            Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.secret = secret;
            return builder;
        }

        @NotNull
        public final HiTranslator build() {
            if (this.targetLanguage == null) {
                throw (Throwable)new NullPointerException("targetLanguage can`t null.");
            }
            if (this.text == null) {
                throw (Throwable)new NullPointerException("text can`t null.");
            }
            if (this.appKey == null) {
                throw (Throwable)new NullPointerException("key can`t null.");
            }
            if (this.secret == null) {
                throw (Throwable)new NullPointerException("secret can`t null.");
            }
            String string2 = this.targetLanguage;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = this.text;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = this.appKey;
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            String string5 = this.secret;
            if (string5 == null) {
                Intrinsics.throwNpe();
            }
            return new HiTranslator(this.sourceLanguage, string2, string3, string4, string5, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003J_\u0010\u001f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000eR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lcom/talpa/translate/HiTranslator$Result;", "", "sourceLanguage", "", "targetLanguage", "text", "translation", "valueCode", "", "valueMessage", "isCache", "", "isSuccess", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;ZZ)V", "()Z", "getSourceLanguage", "()Ljava/lang/String;", "getTargetLanguage", "getText", "getTranslation", "getValueCode", "()I", "getValueMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "translator-link_release"})
    public static final class Result {
        @Nullable
        private final String sourceLanguage;
        @NotNull
        private final String targetLanguage;
        @NotNull
        private final String text;
        @Nullable
        private final String translation;
        private final int valueCode;
        @Nullable
        private final String valueMessage;
        private final boolean isCache;
        private final boolean isSuccess;

        @Nullable
        public final String getSourceLanguage() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String getTargetLanguage() {
            return this.targetLanguage;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getTranslation() {
            return this.translation;
        }

        public final int getValueCode() {
            return this.valueCode;
        }

        @Nullable
        public final String getValueMessage() {
            return this.valueMessage;
        }

        public final boolean isCache() {
            return this.isCache;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        public Result(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            this.text = text;
            this.translation = translation;
            this.valueCode = valueCode;
            this.valueMessage = valueMessage;
            this.isCache = isCache;
            this.isSuccess = isSuccess;
        }

        public /* synthetic */ Result(String string2, String string3, String string4, String string5, int n, String string6, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                string6 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = n == 1000;
            }
            this(string2, string3, string4, string5, n, string6, bl, bl2);
        }

        @Nullable
        public final String component1() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String component2() {
            return this.targetLanguage;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @Nullable
        public final String component4() {
            return this.translation;
        }

        public final int component5() {
            return this.valueCode;
        }

        @Nullable
        public final String component6() {
            return this.valueMessage;
        }

        public final boolean component7() {
            return this.isCache;
        }

        public final boolean component8() {
            return this.isSuccess;
        }

        @NotNull
        public final Result copy(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            return new Result(sourceLanguage, targetLanguage, text, translation, valueCode, valueMessage, isCache, isSuccess);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string2, String string3, String string4, String string5, int n, String string6, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = result2.sourceLanguage;
            }
            if ((n2 & 2) != 0) {
                string3 = result2.targetLanguage;
            }
            if ((n2 & 4) != 0) {
                string4 = result2.text;
            }
            if ((n2 & 8) != 0) {
                string5 = result2.translation;
            }
            if ((n2 & 0x10) != 0) {
                n = result2.valueCode;
            }
            if ((n2 & 0x20) != 0) {
                string6 = result2.valueMessage;
            }
            if ((n2 & 0x40) != 0) {
                bl = result2.isCache;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = result2.isSuccess;
            }
            return result2.copy(string2, string3, string4, string5, n, string6, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Result(sourceLanguage=" + this.sourceLanguage + ", targetLanguage=" + this.targetLanguage + ", text=" + this.text + ", translation=" + this.translation + ", valueCode=" + this.valueCode + ", valueMessage=" + this.valueMessage + ", isCache=" + this.isCache + ", isSuccess=" + this.isSuccess + ")";
        }

        public int hashCode() {
            String string2 = this.sourceLanguage;
            String string3 = this.targetLanguage;
            String string4 = this.text;
            String string5 = this.translation;
            String string6 = this.valueMessage;
            int n = ((((((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + Integer.hashCode(this.valueCode)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31;
            int n2 = this.isCache ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.isSuccess ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result2 = (Result)object;
                    if (!Intrinsics.areEqual((Object)this.sourceLanguage, (Object)result2.sourceLanguage) || !Intrinsics.areEqual((Object)this.targetLanguage, (Object)result2.targetLanguage) || !Intrinsics.areEqual((Object)this.text, (Object)result2.text) || !Intrinsics.areEqual((Object)this.translation, (Object)result2.translation) || this.valueCode != result2.valueCode || !Intrinsics.areEqual((Object)this.valueMessage, (Object)result2.valueMessage) || this.isCache != result2.isCache || this.isSuccess != result2.isSuccess) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/HiTranslator$Companion;", "", "()V", "BASE_URL", "", "CONNECT_TIME_OUT", "", "CONTENT_TYPE", "READ_TIME_OUT", "REQUEST_METHOD", "supportLanguageMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getSupportLanguageMap", "()Ljava/util/HashMap;", "translator-link_release"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, String> getSupportLanguageMap() {
            return supportLanguageMap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

