/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate;

import androidx.annotation.Keep;
import com.talpa.translate.Hex;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001d\u001e\u001fBA\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\u0003H\u0002J0\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0003*\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/talpa/translate/MultiTextTranslator;", "", "sourceLanguage", "", "targetLanguage", "texts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "appKey", "secret", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/ArrayList;Ljava/lang/String;Ljava/lang/String;)V", "connect", "Lcom/talpa/translate/MultiTextTranslator$Result;", "execute", "generateNonce", "generateSign", "timestamp", "", "nonce", "parserJson", "json", "readInputStream", "inputStream", "Ljava/io/InputStream;", "writeOutputStream", "", "outputStream", "Ljava/io/OutputStream;", "md5", "Builder", "Companion", "Result", "translator-link_release"})
@Keep
public final class MultiTextTranslator {
    private final String sourceLanguage;
    private final String targetLanguage;
    private final ArrayList<String> texts;
    private final String appKey;
    private final String secret;
    private static final String BASE_URL = "https://api.translasion.com/v2/translate";
    private static final int CONNECT_TIME_OUT = 6000;
    private static final int READ_TIME_OUT = 8000;
    private static final String REQUEST_METHOD = "POST";
    private static final String CONTENT_TYPE = "application/json";
    @NotNull
    private static final HashMap<String, String> supportLanguageMap;
    public static final Companion Companion;

    @NotNull
    public final Result execute() {
        Result result2 = this.connect();
        return result2;
    }

    private final Result connect() {
        InputStream inputStream;
        OutputStream outputStream;
        URL url = new URL(BASE_URL);
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setRequestProperty("content-type", CONTENT_TYPE);
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(8000);
        connection.setDefaultUseCaches(true);
        connection.setDoOutput(true);
        OutputStream outputStream2 = outputStream = connection.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"outputStream");
        this.writeOutputStream(outputStream2);
        outputStream.close();
        InputStream inputStream2 = inputStream = connection.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
        Result result2 = this.readInputStream(inputStream2);
        inputStream.close();
        connection.disconnect();
        return result2;
    }

    private final void writeOutputStream(OutputStream outputStream) {
        String json;
        long timestamp = System.currentTimeMillis() / (long)1000;
        String nonce = this.generateNonce();
        String sig = this.generateSign(this.appKey, this.targetLanguage, timestamp, this.secret, nonce);
        JSONArray textsArray = new JSONArray((Collection)this.texts);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("app_key", (Object)this.appKey);
        jsonObj.put("to", (Object)this.targetLanguage);
        jsonObj.put("texts", (Object)textsArray);
        jsonObj.put("timestamp", timestamp);
        jsonObj.put("nonce", (Object)nonce);
        jsonObj.put("sig", (Object)sig);
        if (this.sourceLanguage != null) {
            jsonObj.put("from", (Object)this.sourceLanguage);
        }
        String string = jsonObj.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObj.toString()");
        String string2 = json = string;
        OutputStream outputStream2 = outputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        outputStream2.write(byArray2);
        outputStream.flush();
    }

    private final String generateNonce() {
        Object[] charArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
        IntRange intRange = ArraysKt.getIndices((Object[])charArray);
        boolean bl = false;
        int index1 = RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default));
        IntRange intRange2 = ArraysKt.getIndices((Object[])charArray);
        boolean bl2 = false;
        int index2 = RangesKt.random((IntRange)intRange2, (Random)((Random)Random.Default));
        IntRange intRange3 = ArraysKt.getIndices((Object[])charArray);
        boolean bl3 = false;
        int index3 = RangesKt.random((IntRange)intRange3, (Random)((Random)Random.Default));
        IntRange intRange4 = ArraysKt.getIndices((Object[])charArray);
        boolean bl4 = false;
        int index4 = RangesKt.random((IntRange)intRange4, (Random)((Random)Random.Default));
        return "" + ((Character)charArray[index1]).charValue() + ((Character)charArray[index2]).charValue() + ((Character)charArray[index3]).charValue() + ((Character)charArray[index4]).charValue();
    }

    private final String generateSign(String appKey, String targetLanguage, long timestamp, String secret, String nonce) {
        String value = appKey + '&' + targetLanguage + '&' + timestamp + '&' + secret + '&' + nonce;
        return this.md5(value);
    }

    private final String md5(@NotNull String $this$md5) {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        MessageDigest messageDigest = digest;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] data = messageDigest.digest(byArray2);
        char[] charArray = Hex.encodeHex(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)charArray, (String)"charArray");
        object = charArray;
        bl = false;
        return new String((char[])object);
    }

    private final Result readInputStream(InputStream inputStream) {
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        boolean bl = false;
        String content = new String(bytes, Charsets.UTF_8);
        return this.parserJson(content);
    }

    /*
     * WARNING - void declaration
     */
    private final Result parserJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        String keyCode = "code";
        String keyMessage = "message";
        String keyResult = "result";
        String keyText = "texts";
        int valueCode = 0;
        String valueMessage = null;
        JSONArray valueTexts = null;
        if (jsonObject.has(keyCode)) {
            valueCode = jsonObject.getInt(keyCode);
        }
        if (jsonObject.has(keyMessage)) {
            valueMessage = jsonObject.getString(keyMessage);
        }
        if (jsonObject.has(keyResult)) {
            JSONObject valueResult = jsonObject.getJSONObject(keyResult);
            valueTexts = valueResult.getJSONArray(keyText);
        }
        boolean bl = false;
        ArrayList<JSONArray> translations = new ArrayList<JSONArray>();
        JSONArray jSONArray = valueTexts;
        int length = jSONArray != null ? jSONArray.length() : 0;
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void index;
            Object object = valueTexts;
            if (object == null || (object = object.getString((int)index)) == null) {
            } else {
                Object value = object;
                translations.add((JSONArray)value);
            }
            ++index;
        }
        return new Result(this.sourceLanguage, this.targetLanguage, this.texts, translations, valueCode, valueMessage, false, false, 192, null);
    }

    private MultiTextTranslator(String sourceLanguage, String targetLanguage, ArrayList<String> texts, String appKey, String secret) {
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.texts = texts;
        this.appKey = appKey;
        this.secret = secret;
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        HashMap hashMap = new HashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap $this$apply = hashMap;
        boolean bl4 = false;
        ((Map)$this$apply).put("auto", "auto");
        ((Map)$this$apply).put("af", "af");
        ((Map)$this$apply).put("sq", "sq");
        ((Map)$this$apply).put("am", "am");
        ((Map)$this$apply).put("ar", "ar");
        ((Map)$this$apply).put("hy", "hy");
        ((Map)$this$apply).put("az", "az");
        ((Map)$this$apply).put("eu", "eu");
        ((Map)$this$apply).put("be", "be");
        ((Map)$this$apply).put("bn", "bn");
        ((Map)$this$apply).put("bs", "bs");
        ((Map)$this$apply).put("bg", "bg");
        ((Map)$this$apply).put("ca", "ca");
        ((Map)$this$apply).put("ceb", "ceb");
        ((Map)$this$apply).put("zh", "zh");
        ((Map)$this$apply).put("zh-TW", "zh-TW");
        ((Map)$this$apply).put("co", "co");
        ((Map)$this$apply).put("hr", "hr");
        ((Map)$this$apply).put("cs", "cs");
        ((Map)$this$apply).put("da", "da");
        ((Map)$this$apply).put("nl", "nl");
        ((Map)$this$apply).put("en", "en");
        ((Map)$this$apply).put("eo", "eo");
        ((Map)$this$apply).put("et", "et");
        ((Map)$this$apply).put("fi", "fi");
        ((Map)$this$apply).put("fr", "fr");
        ((Map)$this$apply).put("fy", "fy");
        ((Map)$this$apply).put("gl", "gl");
        ((Map)$this$apply).put("ka", "ka");
        ((Map)$this$apply).put("de", "de");
        ((Map)$this$apply).put("el", "el");
        ((Map)$this$apply).put("gu", "gu");
        ((Map)$this$apply).put("ht", "ht");
        ((Map)$this$apply).put("ha", "ha");
        ((Map)$this$apply).put("haw", "haw");
        ((Map)$this$apply).put("he", "he");
        ((Map)$this$apply).put("hi", "hi");
        ((Map)$this$apply).put("hmn", "hmn");
        ((Map)$this$apply).put("hu", "hu");
        ((Map)$this$apply).put("is", "is");
        ((Map)$this$apply).put("ig", "ig");
        ((Map)$this$apply).put("id", "id");
        ((Map)$this$apply).put("ga", "ga");
        ((Map)$this$apply).put("it", "it");
        ((Map)$this$apply).put("ja", "ja");
        ((Map)$this$apply).put("jv", "jv");
        ((Map)$this$apply).put("kn", "kn");
        ((Map)$this$apply).put("kk", "kk");
        ((Map)$this$apply).put("km", "km");
        ((Map)$this$apply).put("rw", "rw");
        ((Map)$this$apply).put("ko", "ko");
        ((Map)$this$apply).put("ku", "ku");
        ((Map)$this$apply).put("ky", "ky");
        ((Map)$this$apply).put("lo", "lo");
        ((Map)$this$apply).put("la", "la");
        ((Map)$this$apply).put("lv", "lv");
        ((Map)$this$apply).put("lt", "lt");
        ((Map)$this$apply).put("lb", "lb");
        ((Map)$this$apply).put("mk", "mk");
        ((Map)$this$apply).put("mg", "mg");
        ((Map)$this$apply).put("ms", "ms");
        ((Map)$this$apply).put("ml", "ml");
        ((Map)$this$apply).put("mt", "mt");
        ((Map)$this$apply).put("mi", "mi");
        ((Map)$this$apply).put("mr", "mr");
        ((Map)$this$apply).put("mn", "mn");
        ((Map)$this$apply).put("my", "my");
        ((Map)$this$apply).put("ne", "ne");
        ((Map)$this$apply).put("no", "no");
        ((Map)$this$apply).put("ny", "ny");
        ((Map)$this$apply).put("or", "or");
        ((Map)$this$apply).put("ps", "ps");
        ((Map)$this$apply).put("fa", "fa");
        ((Map)$this$apply).put("pl", "pl");
        ((Map)$this$apply).put("pt", "pt");
        ((Map)$this$apply).put("pa", "pa");
        ((Map)$this$apply).put("ro", "ro");
        ((Map)$this$apply).put("ru", "ru");
        ((Map)$this$apply).put("sm", "sm");
        ((Map)$this$apply).put("gd", "gd");
        ((Map)$this$apply).put("sr", "sr");
        ((Map)$this$apply).put("st", "st");
        ((Map)$this$apply).put("sn", "sn");
        ((Map)$this$apply).put("sd", "sd");
        ((Map)$this$apply).put("si", "si");
        ((Map)$this$apply).put("sk", "sk");
        ((Map)$this$apply).put("sl", "sl");
        ((Map)$this$apply).put("so", "so");
        ((Map)$this$apply).put("es", "es");
        ((Map)$this$apply).put("su", "su");
        ((Map)$this$apply).put("sw", "sw");
        ((Map)$this$apply).put("sv", "sv");
        ((Map)$this$apply).put("tl", "tl");
        ((Map)$this$apply).put("tg", "tg");
        ((Map)$this$apply).put("ta", "ta");
        ((Map)$this$apply).put("tt", "tt");
        ((Map)$this$apply).put("te", "te");
        ((Map)$this$apply).put("th", "th");
        ((Map)$this$apply).put("tr", "tr");
        ((Map)$this$apply).put("tk", "tk");
        ((Map)$this$apply).put("uk", "uk");
        ((Map)$this$apply).put("ur", "ur");
        ((Map)$this$apply).put("ug", "ug");
        ((Map)$this$apply).put("uz", "uz");
        ((Map)$this$apply).put("vi", "vi");
        ((Map)$this$apply).put("cy", "cy");
        ((Map)$this$apply).put("xh", "xh");
        ((Map)$this$apply).put("yi", "yi");
        ((Map)$this$apply).put("yo", "yo");
        ((Map)$this$apply).put("zu", "zu");
        supportLanguageMap = hashMap;
    }

    public /* synthetic */ MultiTextTranslator(String sourceLanguage, String targetLanguage, ArrayList texts, String appKey, String secret, DefaultConstructorMarker $constructor_marker) {
        this(sourceLanguage, targetLanguage, texts, appKey, secret);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\u00020\u00002\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\tj\b\u0012\u0004\u0012\u00020\u0004`\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tj\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/talpa/translate/MultiTextTranslator$Builder;", "", "()V", "appKey", "", "secret", "sourceLanguage", "targetLanguage", "texts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "build", "Lcom/talpa/translate/MultiTextTranslator;", "setAppKey", "setSecret", "setSourceLanguage", "setTargetLanguage", "setTexts", "translator-link_release"})
    public static final class Builder {
        private String sourceLanguage;
        private String targetLanguage;
        private ArrayList<String> texts;
        private String appKey;
        private String secret;

        @NotNull
        public final Builder setSourceLanguage(@Nullable String sourceLanguage) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.sourceLanguage = sourceLanguage;
            return builder;
        }

        @NotNull
        public final Builder setTargetLanguage(@NotNull String targetLanguage) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.targetLanguage = targetLanguage;
            return builder;
        }

        @NotNull
        public final Builder setTexts(@NotNull ArrayList<String> texts) {
            Intrinsics.checkParameterIsNotNull(texts, (String)"texts");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.texts = texts;
            return builder;
        }

        @NotNull
        public final Builder setAppKey(@NotNull String appKey) {
            Intrinsics.checkParameterIsNotNull((Object)appKey, (String)"appKey");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.appKey = appKey;
            return builder;
        }

        @NotNull
        public final Builder setSecret(@NotNull String secret) {
            Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.secret = secret;
            return builder;
        }

        @NotNull
        public final MultiTextTranslator build() {
            if (this.targetLanguage == null) {
                throw (Throwable)new NullPointerException("targetLanguage can`t null.");
            }
            if (this.texts == null) {
                throw (Throwable)new NullPointerException("text can`t null.");
            }
            if (this.appKey == null) {
                throw (Throwable)new NullPointerException("key can`t null.");
            }
            if (this.secret == null) {
                throw (Throwable)new NullPointerException("secret can`t null.");
            }
            String string = this.targetLanguage;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            ArrayList<String> arrayList = this.texts;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            String string2 = this.appKey;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = this.secret;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            return new MultiTextTranslator(this.sourceLanguage, string, arrayList, string2, string3, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001b\b\u0086\b\u0018\u00002\u00020\u0001Bi\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u000eH\u00c6\u0003J\t\u0010#\u001a\u00020\u000eH\u00c6\u0003Js\u0010$\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0018\b\u0002\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u000bH\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0011R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0006j\b\u0012\u0004\u0012\u00020\u0003`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/talpa/translate/MultiTextTranslator$Result;", "", "sourceLanguage", "", "targetLanguage", "texts", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "translations", "", "valueCode", "", "valueMessage", "isCache", "", "isSuccess", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/ArrayList;Ljava/util/List;ILjava/lang/String;ZZ)V", "()Z", "getSourceLanguage", "()Ljava/lang/String;", "getTargetLanguage", "getTexts", "()Ljava/util/ArrayList;", "getTranslations", "()Ljava/util/List;", "getValueCode", "()I", "getValueMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "translator-link_release"})
    public static final class Result {
        @Nullable
        private final String sourceLanguage;
        @NotNull
        private final String targetLanguage;
        @NotNull
        private final ArrayList<String> texts;
        @NotNull
        private final List<String> translations;
        private final int valueCode;
        @Nullable
        private final String valueMessage;
        private final boolean isCache;
        private final boolean isSuccess;

        @Nullable
        public final String getSourceLanguage() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String getTargetLanguage() {
            return this.targetLanguage;
        }

        @NotNull
        public final ArrayList<String> getTexts() {
            return this.texts;
        }

        @NotNull
        public final List<String> getTranslations() {
            return this.translations;
        }

        public final int getValueCode() {
            return this.valueCode;
        }

        @Nullable
        public final String getValueMessage() {
            return this.valueMessage;
        }

        public final boolean isCache() {
            return this.isCache;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        public Result(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull ArrayList<String> texts, @NotNull List<String> translations, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull(texts, (String)"texts");
            Intrinsics.checkParameterIsNotNull(translations, (String)"translations");
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            this.texts = texts;
            this.translations = translations;
            this.valueCode = valueCode;
            this.valueMessage = valueMessage;
            this.isCache = isCache;
            this.isSuccess = isSuccess;
        }

        public /* synthetic */ Result(String string, String string2, ArrayList arrayList, List list, int n, String string3, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                string3 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = n == 1000;
            }
            this(string, string2, arrayList, list, n, string3, bl, bl2);
        }

        @Nullable
        public final String component1() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String component2() {
            return this.targetLanguage;
        }

        @NotNull
        public final ArrayList<String> component3() {
            return this.texts;
        }

        @NotNull
        public final List<String> component4() {
            return this.translations;
        }

        public final int component5() {
            return this.valueCode;
        }

        @Nullable
        public final String component6() {
            return this.valueMessage;
        }

        public final boolean component7() {
            return this.isCache;
        }

        public final boolean component8() {
            return this.isSuccess;
        }

        @NotNull
        public final Result copy(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull ArrayList<String> texts, @NotNull List<String> translations, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull(texts, (String)"texts");
            Intrinsics.checkParameterIsNotNull(translations, (String)"translations");
            return new Result(sourceLanguage, targetLanguage, texts, translations, valueCode, valueMessage, isCache, isSuccess);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, String string2, ArrayList arrayList, List list, int n, String string3, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = result2.sourceLanguage;
            }
            if ((n2 & 2) != 0) {
                string2 = result2.targetLanguage;
            }
            if ((n2 & 4) != 0) {
                arrayList = result2.texts;
            }
            if ((n2 & 8) != 0) {
                list = result2.translations;
            }
            if ((n2 & 0x10) != 0) {
                n = result2.valueCode;
            }
            if ((n2 & 0x20) != 0) {
                string3 = result2.valueMessage;
            }
            if ((n2 & 0x40) != 0) {
                bl = result2.isCache;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = result2.isSuccess;
            }
            return result2.copy(string, string2, arrayList, list, n, string3, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Result(sourceLanguage=" + this.sourceLanguage + ", targetLanguage=" + this.targetLanguage + ", texts=" + this.texts + ", translations=" + this.translations + ", valueCode=" + this.valueCode + ", valueMessage=" + this.valueMessage + ", isCache=" + this.isCache + ", isSuccess=" + this.isSuccess + ")";
        }

        public int hashCode() {
            String string = this.sourceLanguage;
            String string2 = this.targetLanguage;
            ArrayList<String> arrayList = this.texts;
            List<String> list = this.translations;
            String string3 = this.valueMessage;
            int n = ((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (arrayList != null ? ((Object)arrayList).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.valueCode)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31;
            int n2 = this.isCache ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.isSuccess ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result2 = (Result)object;
                    if (!Intrinsics.areEqual((Object)this.sourceLanguage, (Object)result2.sourceLanguage) || !Intrinsics.areEqual((Object)this.targetLanguage, (Object)result2.targetLanguage) || !Intrinsics.areEqual(this.texts, result2.texts) || !Intrinsics.areEqual(this.translations, result2.translations) || this.valueCode != result2.valueCode || !Intrinsics.areEqual((Object)this.valueMessage, (Object)result2.valueMessage) || this.isCache != result2.isCache || this.isSuccess != result2.isSuccess) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R-\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/MultiTextTranslator$Companion;", "", "()V", "BASE_URL", "", "CONNECT_TIME_OUT", "", "CONTENT_TYPE", "READ_TIME_OUT", "REQUEST_METHOD", "supportLanguageMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getSupportLanguageMap", "()Ljava/util/HashMap;", "translator-link_release"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, String> getSupportLanguageMap() {
            return supportLanguageMap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

