/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate;

import android.content.Context;
import android.text.TextUtils;
import com.talpa.tengine.store.TranslationStoreKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0003\u0017\u0018\u0019B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/talpa/translate/HiTranslatorV1;", "", "context", "Landroid/content/Context;", "sourceLanguage", "", "targetLanguage", "text", "key", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "connect", "Lcom/talpa/translate/HiTranslatorV1$Result;", "execute", "parserJson", "json", "readInputStream", "inputStream", "Ljava/io/InputStream;", "writeOutputStream", "", "outputStream", "Ljava/io/OutputStream;", "zip", "Builder", "Companion", "Result", "translator-link_release"})
public final class HiTranslatorV1 {
    private final Context context;
    private final String sourceLanguage;
    private final String targetLanguage;
    private final String text;
    private final String key;
    private static final String BASE_URL = "https://api.translasion.com/v1/translate";
    private static final int CONNECT_TIME_OUT = 6000;
    private static final int READ_TIME_OUT = 6000;
    private static final String REQUEST_METHOD = "POST";
    private static final String CONTENT_TYPE = "application/json";
    private static final String PREFER_TRANSLATOR = "prefer_translator_data";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Result execute() {
        String translation = TranslationStoreKt.readTranslation(this.sourceLanguage, this.targetLanguage, this.text);
        if (!TextUtils.isEmpty((CharSequence)translation)) {
            return new Result(this.sourceLanguage, this.targetLanguage, this.text, translation, 1000, null, true, false, 160, null);
        }
        Result result = this.connect();
        if (!TextUtils.isEmpty((CharSequence)result.getTranslation())) {
            String string = result.getTranslation();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            TranslationStoreKt.storeTranslation(this.sourceLanguage, this.targetLanguage, this.text, string);
        }
        return result;
    }

    private final Result connect() {
        InputStream inputStream;
        OutputStream outputStream;
        URL url = new URL(BASE_URL);
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setRequestProperty("content-type", CONTENT_TYPE);
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(6000);
        connection.setDefaultUseCaches(true);
        connection.setDoOutput(true);
        OutputStream outputStream2 = outputStream = connection.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"outputStream");
        this.writeOutputStream(outputStream2);
        outputStream.close();
        InputStream inputStream2 = inputStream = connection.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
        Result result = this.readInputStream(inputStream2);
        inputStream.close();
        connection.disconnect();
        return result;
    }

    private final void writeOutputStream(OutputStream outputStream) {
        String json;
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("to", (Object)this.targetLanguage);
        jsonObj.put("text", (Object)this.text);
        jsonObj.put("k", (Object)this.key);
        if (this.sourceLanguage != null) {
            jsonObj.put("from", (Object)this.sourceLanguage);
        }
        String string = jsonObj.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObj.toString()");
        String string2 = json = string;
        OutputStream outputStream2 = outputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        outputStream2.write(byArray2);
        outputStream.flush();
    }

    private final Result readInputStream(InputStream inputStream) {
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        boolean bl = false;
        String content = new String(bytes, Charsets.UTF_8);
        return this.parserJson(content);
    }

    private final Result parserJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        String keyCode = "code";
        String keyMessage = "message";
        String keyResult = "result";
        String keyText = "text";
        int valueCode = 0;
        String valueMessage = null;
        String valueText = null;
        if (jsonObject.has(keyCode)) {
            valueCode = jsonObject.getInt(keyCode);
        }
        if (jsonObject.has(keyMessage)) {
            valueMessage = jsonObject.getString(keyMessage);
        }
        if (jsonObject.has(keyResult)) {
            JSONObject valueResult = jsonObject.getJSONObject(keyResult);
            valueText = valueResult.getString(keyText);
        }
        return new Result(this.sourceLanguage, this.targetLanguage, this.text, valueText, valueCode, valueMessage, false, false, 192, null);
    }

    private final void zip() {
    }

    private HiTranslatorV1(Context context, String sourceLanguage, String targetLanguage, String text, String key) {
        this.context = context;
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.text = text;
        this.key = key;
    }

    public /* synthetic */ HiTranslatorV1(Context context, String sourceLanguage, String targetLanguage, String text, String key, DefaultConstructorMarker $constructor_marker) {
        this(context, sourceLanguage, targetLanguage, text, key);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/talpa/translate/HiTranslatorV1$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "key", "", "sourceLanguage", "targetLanguage", "text", "build", "Lcom/talpa/translate/HiTranslatorV1;", "setKey", "setSourceLanguage", "setTargetLanguage", "setText", "translator-link_release"})
    public static final class Builder {
        private String sourceLanguage;
        private String targetLanguage;
        private String text;
        private String key;
        private final Context context;

        @NotNull
        public final Builder setSourceLanguage(@NotNull String sourceLanguage) {
            Intrinsics.checkParameterIsNotNull((Object)sourceLanguage, (String)"sourceLanguage");
            this.sourceLanguage = sourceLanguage;
            return this;
        }

        @NotNull
        public final Builder setTargetLanguage(@NotNull String targetLanguage) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            this.targetLanguage = targetLanguage;
            return this;
        }

        @NotNull
        public final Builder setText(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.text = text;
            return this;
        }

        @NotNull
        public final Builder setKey(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            this.key = key;
            return this;
        }

        @NotNull
        public final HiTranslatorV1 build() {
            if (this.targetLanguage == null) {
                throw (Throwable)new NullPointerException("targetLanguage can`t null.");
            }
            if (this.text == null) {
                throw (Throwable)new NullPointerException("text can`t null.");
            }
            if (this.key == null) {
                throw (Throwable)new NullPointerException("key can`t null.");
            }
            String string = this.targetLanguage;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = this.text;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = this.key;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            return new HiTranslatorV1(this.context, this.sourceLanguage, string, string2, string3, null);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u000bH\u00c6\u0003J_\u0010\u001f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000eR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/talpa/translate/HiTranslatorV1$Result;", "", "sourceLanguage", "", "targetLanguage", "text", "translation", "valueCode", "", "valueMessage", "isCache", "", "isSuccess", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;ZZ)V", "()Z", "getSourceLanguage", "()Ljava/lang/String;", "getTargetLanguage", "getText", "getTranslation", "getValueCode", "()I", "getValueMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "translator-link_release"})
    public static final class Result {
        @Nullable
        private final String sourceLanguage;
        @NotNull
        private final String targetLanguage;
        @NotNull
        private final String text;
        @Nullable
        private final String translation;
        private final int valueCode;
        @Nullable
        private final String valueMessage;
        private final boolean isCache;
        private final boolean isSuccess;

        @Nullable
        public final String getSourceLanguage() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String getTargetLanguage() {
            return this.targetLanguage;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getTranslation() {
            return this.translation;
        }

        public final int getValueCode() {
            return this.valueCode;
        }

        @Nullable
        public final String getValueMessage() {
            return this.valueMessage;
        }

        public final boolean isCache() {
            return this.isCache;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        public Result(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            this.text = text;
            this.translation = translation;
            this.valueCode = valueCode;
            this.valueMessage = valueMessage;
            this.isCache = isCache;
            this.isSuccess = isSuccess;
        }

        public /* synthetic */ Result(String string, String string2, String string3, String string4, int n, String string5, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                string5 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = n == 1000;
            }
            this(string, string2, string3, string4, n, string5, bl, bl2);
        }

        @Nullable
        public final String component1() {
            return this.sourceLanguage;
        }

        @NotNull
        public final String component2() {
            return this.targetLanguage;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @Nullable
        public final String component4() {
            return this.translation;
        }

        public final int component5() {
            return this.valueCode;
        }

        @Nullable
        public final String component6() {
            return this.valueMessage;
        }

        public final boolean component7() {
            return this.isCache;
        }

        public final boolean component8() {
            return this.isSuccess;
        }

        @NotNull
        public final Result copy(@Nullable String sourceLanguage, @NotNull String targetLanguage, @NotNull String text, @Nullable String translation, int valueCode, @Nullable String valueMessage, boolean isCache, boolean isSuccess) {
            Intrinsics.checkParameterIsNotNull((Object)targetLanguage, (String)"targetLanguage");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            return new Result(sourceLanguage, targetLanguage, text, translation, valueCode, valueMessage, isCache, isSuccess);
        }

        public static /* synthetic */ Result copy$default(Result result, String string, String string2, String string3, String string4, int n, String string5, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = result.sourceLanguage;
            }
            if ((n2 & 2) != 0) {
                string2 = result.targetLanguage;
            }
            if ((n2 & 4) != 0) {
                string3 = result.text;
            }
            if ((n2 & 8) != 0) {
                string4 = result.translation;
            }
            if ((n2 & 0x10) != 0) {
                n = result.valueCode;
            }
            if ((n2 & 0x20) != 0) {
                string5 = result.valueMessage;
            }
            if ((n2 & 0x40) != 0) {
                bl = result.isCache;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = result.isSuccess;
            }
            return result.copy(string, string2, string3, string4, n, string5, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Result(sourceLanguage=" + this.sourceLanguage + ", targetLanguage=" + this.targetLanguage + ", text=" + this.text + ", translation=" + this.translation + ", valueCode=" + this.valueCode + ", valueMessage=" + this.valueMessage + ", isCache=" + this.isCache + ", isSuccess=" + this.isSuccess + ")";
        }

        public int hashCode() {
            String string = this.sourceLanguage;
            String string2 = this.targetLanguage;
            String string3 = this.text;
            String string4 = this.translation;
            String string5 = this.valueMessage;
            int n = ((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + Integer.hashCode(this.valueCode)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31;
            int n2 = this.isCache ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.isSuccess ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result = (Result)object;
                    if (!Intrinsics.areEqual((Object)this.sourceLanguage, (Object)result.sourceLanguage) || !Intrinsics.areEqual((Object)this.targetLanguage, (Object)result.targetLanguage) || !Intrinsics.areEqual((Object)this.text, (Object)result.text) || !Intrinsics.areEqual((Object)this.translation, (Object)result.translation) || this.valueCode != result.valueCode || !Intrinsics.areEqual((Object)this.valueMessage, (Object)result.valueMessage) || this.isCache != result.isCache || this.isSuccess != result.isSuccess) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/talpa/translate/HiTranslatorV1$Companion;", "", "()V", "BASE_URL", "", "CONNECT_TIME_OUT", "", "CONTENT_TYPE", "PREFER_TRANSLATOR", "READ_TIME_OUT", "REQUEST_METHOD", "translator-link_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

