package com.talpa.tengine

import android.content.Intent
import androidx.annotation.Keep
import com.talpa.tengine.lang.LANG
import java.text.SimpleDateFormat
import java.util.*
import java.util.regex.Pattern

private const val TAG = "Trans"

/**
 * 翻译实体类,该对象伴随整个翻译流程
 * @author CY 19-4-18
 * @param text 最大单句７５个字符，不包含换行符，加上换行符７６个字符，框架自动处理
 */
//@Entity(tableName = "trans")
@Keep
data class Trans(
    var from: String = LANG.AUTO,
    var to: String = "",
    var text: String = ""
) {//Multi text

    //@PrimaryKey(autoGenerate = true)
    val id: Int = 0

    var feedBack: Boolean = false

//    /**
//     * cache key
//     */
//    val key: String by lazy {
//        //val texts = multiText.joinToString()
//
//        key("$from$to$text")
//    }

    /**
     * 翻译日志
     */
    private val logs = StringBuilder()

//    /**
//     * 需要翻译的文本，由　multiText　转化而来
//     */
//    internal val text: String by lazy { join(preText()) }

    /**
     * 记录拆分规则[子数组起始的下标,子数组长度]
     */
    private val catMap: HashMap<Int, Int> = hashMapOf()

    private val simpleFormat by lazy {
        SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH)
    }

    /**
     * 添加日志
     */
    fun appendLog(message: String) {
        logs.append("***").append(simpleFormat.format(Date())).append("***").append('\n')
            .append(message).append('\n')
        /* if (BuildConfig.DEBUG) {
             Log.i(TAG, message)
         }*/
    }

    /**
     * 获取日志
     */
    fun logs() = logs.toString()

    /**
     * 埋点
     */
    fun appendEvent(eventId: String, params: HashMap<String, String>? = null) {
        try {
            val intent = Intent(ACTION_DATA_TRANS)
            intent.putExtra(EXTRA_EVENT_ID, eventId)
            intent.putExtra(EXTRA_EVENT_PARAMS, params)
            /*LocalBroadcastManager.getInstance(context)
                .sendBroadcast(intent)*/
        } catch (e: Throwable) {
            e.printStackTrace()
        }
    }


    /**
     * 根据翻译后的内容合成字符串
     */
    internal fun postText(translationList: List<String>): List<String> {

        //if (multiText.size == 1) return translationList

        val list = arrayListOf<String>()
        for ((key, value) in catMap) {//[子数组起始的下标,子数组长度]
            val startIndex = key //+ (value * i)
            val endIndex = startIndex + value

            if (startIndex >= translationList.size || endIndex > translationList.size) {
                list.add("")
            } else {
                try {
                    // println("startIndex=$startIndex  endIndex=$endIndex")
                    val subList = translationList.subList(startIndex, endIndex)
                    val text = subList.joinToString(separator = "")
                    list.add(text)
                } catch (e: Throwable) {
                    e.printStackTrace()
                    list.add("")
                }

            }

        }

        return list
    }

    /**
     *  过滤转义字符 \n,\r,\t,空格
     */
    private fun filter(text: String): String {

        val p =
            Pattern.compile("[\\f\\n\\r\\t\\v]")//去掉空格"\s ＝＝[　\f\n\r\t\v]匹配任何空白字符，包括空格、制表符、换页符等等。等价于 [ \f\n\r\t\v]
        val m = p.matcher(text)
        return m.replaceAll("")

        // return text.filterNot { c -> c == '\n' || c == '\r' || c == '\t' || c == ' ' }
    }

    /**
     * 拼接
     * 将处理好的翻译内容数组，以\r\n间隔转为文本以提供翻译
     */
    private fun join(list: List<String>) = list.joinToString(separator = "\n")

    /**
     * 翻译结果
     */
    var result: Result? = null

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Trans

        if (from != other.from) return false
        if (to != other.to) return false
        if (other.text != text) return false

        return true
    }

    /*  override fun hashCode(): Int {
          var result = from.hashCode()
          result = 31 * result + to.hashCode()
          result = 31 * result + text.contentHashCode()
          return result
      }*/

    override fun hashCode(): Int {
        return super.hashCode()
    }

//    private fun key(string: String): String {
//        return ByteString.encodeUtf8(string).md5().hex()
//    }


/*
    fun getTranslate(translateFactory: TranslateFactory): Translate {
        return when (translateFactory) {
//            is BaiduTranslate -> {
//                Translate.BAIDU
//            }
            is BingTranslate -> {
                Translate.BING
            }
            is GoogleTranslate -> {
                Translate.GOOGLE
            }
//            is IcibaTranslate -> {
//                Translate.ICIBA
//            }
//            is TencentTranslate -> {
//                Translate.TENCENT
//            }
//            is YoudaoTranslate -> {
//                Translate.YOUDAO
//            }
            is GoogleCloudTranslate -> {
                Translate.GOOGLE_CLOUD
            }
            is YandexTranslate -> {
                Translate.YANDEX
            }
            else -> {
                Translate.MICROSOFT_CLOUD
            }

        }


    }
*/

    data class Result(
        var code: Int = SUCCESS,
        var translation: String? = null,
        var errorMessage: String? = null,
        var detectLang: String? = null,
        var isCached: Boolean = false,
        @TranslateSource val source: String = UNKNOWN
    ) {
        override fun toString(): String {
            return super.toString()
        }
    }


    companion object {

        /** Translate Success. */
        const val SUCCESS = 0

        /** Network operation timed out. */
        const val ERROR_NETWORK_TIMEOUT = 1

        /** Other network related errors. */
        const val ERROR_NETWORK = 2

        /** Server Error. */
        const val ERROR_SERVER = 3

        /** Other Error. */
        const val ERROR_OTHER = 4


        /*　打点数据　START*/
        /** 进入翻译 */
        const val EVENT_ENTER = "Trans_enter"//源语言，目标语言，ip

        /**
         * 翻译成功并退出
         */
        const val EVENT_EXIT_SUCCESS = "Trans_exit_success"

        /**
         * 翻译失败并退出
         */
        const val EVENT_EXIT_FAILURE = "Trans_exit_failure"

        /**
         * 翻译发生未知异常并退出翻译
         */
        const val EVENT_EXIT_THROWABLE = "Trans_exit_throwable"

        /** 加载翻译缓存 */
        const val EVENT_CACHE = "Trans_cache"

        /** 总的翻译成功 */
        const val EVENT_TRANS_ULTIMATE_SUCCESS = "Trans_ultimate_success"//ultimate

        /** 总的翻译失败 */
        const val EVENT_TRANS_ULTIMATE_FAIL = "Trans_ultimate_fail"

        /** 进入在线翻译 */
        const val EVENT_ONLINE_TRANSLATE_START = "Trans_online_translate_start"

        /** 离线翻译成功 */
        const val EVENT_OFFLINE_TRANSLATE_SUCCESS = "Trans_offline_translate_success"

        /** 离线翻译失败 */
        const val EVENT_OFFLINE_TRANSLATE_FAILURE = "Trans_offline_translate_failure"

        /** Google free 翻译成功 */
        const val EVENT_TRANS_SUCCESS_FROM_GOOGLE_FREE = "Trans_google_free_success"

        /** Google free 翻译失败 */
        const val EVENT_TRANS_FAIL_FROM_GOOGLE_FREE = "Trans_google_free_fail"

        /** Google charge 翻译成功 */
        const val EVENT_TRANS_SUCCESS_FROM_GOOGLE_CHARGE = "Trans_google_charge_success"

        /** Google charge 翻译失败 */
        const val EVENT_TRANS_FAIL_FROM_GOOGLE_CHARGE = "Trans_google_charge_fail"

        /** Microsoft free 翻译成功 */
        const val EVENT_TRANS_SUCCESS_FROM_MICROSOFT_FREE = "Trans_microsoft_free_success"

        /** Microsoft free 翻译失败 */
        const val EVENT_TRANS_FAIL_FROM_MICROSOFT_FREE = "Trans_microsoft_free_fail"

        /** Microsoft charge 翻译成功 */
        const val EVENT_TRANS_SUCCESS_FROM_MICROSOFT_CHARGE =
            "Trans_microsoft_charge_success"

        /** Microsoft charge 翻译失败 */
        const val EVENT_TRANS_FAIL_FROM_MICROSOFT_CHARGE = "Trans_microsoft_charge_fail"

        /** SERVER 翻译成功 */
        const val EVENT_TRANS_SUCCESS_FROM_SERVER = "Trans_server_success"

        const val EVENT_TRANS_FAIL_FROM_SERVER = "Trans_server_fail"

//        /** Bai du 翻译成功 */
//         const val EVENT_TRANS_SUCCESS_FROM_BAIDU = "Trans_baidu_success"
//        /** Bai du 翻译失败 */
//         const val EVENT_TRANS_FAIL_FROM_BAIDU = "Trans_baidu_fail"
//        /** YOU DAO 翻译成功 */
//         const val EVENT_TRANS_SUCCESS_FROM_YOUDAO = "Trans_youdao_success"
//        /** YOU DAO 翻译失败 */
//         const val EVENT_TRANS_FAIL_FROM_YOUDAO = "Trans_youdao_fail"
        /** YANDEX 翻译成功 */
        const val EVENT_TRANS_SUCCESS_FROM_YANDEX = "Trans_yandex_success"

        /** YANDEX 翻译失败 */
        const val EVENT_TRANS_FAIL_FROM_YANDEX = "Trans_yandex_fail"
//        /** ICIBA 翻译成功 */
//         const val EVENT_TRANS_SUCCESS_FROM_ICIBA = "Trans_iciba_success"
//        /** ICIBA 翻译失败 */
//         const val EVENT_TRANS_FAIL_FROM_ICIBA = "Trans_iciba_fail"
//        /** TENCENT 翻译成功 */
//         const val EVENT_TRANS_SUCCESS_FROM_TENCENT = "Trans_tencent_success"
//        /** TENCENT 翻译失败 */
//         const val EVENT_TRANS_FAIL_FROM_TENCENT = "Trans_tencent_fail"

        /*　打点数据　END*/

        /**
         * 打点数据动作
         */
        const val ACTION_DATA_TRANS = "ACTION_DATA_TRANS"
        const val EXTRA_EVENT_ID = "EXTRA_EVENT_ID"
        const val EXTRA_EVENT_PARAMS = "EXTRA_EVENT_PARAMS"

        const val LANGUAGE_CHECK_BEFORE_TRANS = "language_check_before_trans"
    }

//    /**
//     * 翻译接口
//     */
//    enum class Translate {
//        GOOGLE_CLOUD,//收费
//        MICROSOFT_CLOUD,//收费
//        BAIDU,
//        BING,
//        GOOGLE,
//        ICIBA,
//        TENCENT,
//        YANDEX,
//        YOUDAO,
//        GOOGLE_OFFLINE
//    }


}

fun main() {

    val text = """
This document is meant for Android developers looking to apply their existing Android knowledge to build mobile apps with Flutter. If you understand the fundamentals of the Android framework then you can use this document as a jump start to Flutter development.

Your Android knowledge and skill set are highly valuable when building with Flutter, because Flutter relies on the mobile operating system for numerous capabilities and configurations. Flutter is a new way to build UIs for mobile, but it has a plugin system to communicate with Android (and iOS) for non-UI tasks. If you’re an expert with Android, you don’t have to relearn everything to use Flutter.

This document can be used as a cookbook by jumping around and finding questions that are most relevant to your needs.
    """.trimIndent()
    val p =
        Pattern.compile("[\\f\\n\\r\\t\\v]")//去掉空格"\s ＝＝[　\f\n\r\t\v]匹配任何空白字符，包括空格、制表符、换页符等等。等价于 [ \f\n\r\t\v]
    val m = p.matcher(text)
    val t = m.replaceAll("")
    println(text)
    println("---------------")
    println(t)
    // d("nini\nd d\r\n\thh")

    //text.cut()
}

/**
 * 字符串根据自定长度裁剪成数组
 */
fun String.cut(subMaxLength: Int = 75): List<String> {

    val length = this.length
    //最大子字符串长度75,+1因为字符串裁剪[0,76)
    val subLength = subMaxLength + 1
    //数组数量
    val subStrNum = if (length % subLength == 0) length / subLength else length / subLength + 1

    val list = arrayListOf<String>()
    for (i in 0..subStrNum) {
        val startIndex = i * subLength
        var endIndex = (i + 1) * subLength
        if (endIndex > length) {
            endIndex = length
        }
        val sub = this.substring(startIndex, endIndex)
        list.add(sub)

        if (endIndex >= length) {
            break
        }
    }

    return list
}

/**
 * 去掉\n,\r,\t，空格
 */
fun d(text: String): String {
    //text.replace("\n", "")
    //println("text=$text")
    val d = text.filterNot { c -> c == '\n' || c == '\r' || c == '\t' || c == ' ' }
//    val d = text.replace(Regex.fromLiteral("[\\s\\S]"), "")
    //println("d=$d")
    return d //t.joinToString(separator = "\r\n")
}