package com.talpa.tengine.charge

import com.talpa.tengine.request.RequestHelper
import io.reactivex.Flowable
import okhttp3.FormBody
import okhttp3.Request
import okhttp3.ResponseBody
import java.util.*

/**
 *
 * @author CY 2019/1/21
 */
abstract class AbstractFactory {

    /**
     * 支持的语言Map
     */
    val langMap: HashMap<String, String> by lazy { hashMapOf<String, String>() }

    /**
     * 参数
     */
    val formData: HashMap<String, String> by lazy { hashMapOf<String, String>() }

    init {
        this.setLangSupport(langMap)
    }

    /**
     * 设置支持的语言
     */
    protected abstract fun setLangSupport(langMap: HashMap<String, String>)

    /**
     * 是否支持该语言
     */
    fun isSupportLanguage(lang: String): Boolean = langMap.contains(lang)

    protected fun get(baseUrl: String): Flowable<retrofit2.Response<ResponseBody>> {
        return RequestHelper.get(baseUrl = baseUrl, params = formData)
    }

    protected fun post(url: String, encoded: Boolean = false): Request {
        val formBodyBuilder = FormBody.Builder()
        for ((key, value) in formData) {
            if (encoded) {
                formBodyBuilder.addEncoded(key, value)
            } else {
                formBodyBuilder.add(key, value)
            }
        }
        return Request.Builder().url(url).post(formBodyBuilder.build()).build()
    }


    abstract fun execute(): Flowable<retrofit2.Response<ResponseBody>>
}