package com.talpa.tengine.lang

/**
 *  Translate Lang
 *  @author CY 2019-01-13
 */

class LANG {

    companion object {

        /********Translate Language Start ***********/

        const val AUTO = "auto" // 自动检测语种

        const val AF="af"//南非荷兰语
        const val SQ="sq"//阿尔巴尼亚语
        const val AM="am"//阿姆哈拉语
        const val AR="ar"//阿拉伯语
        const val HY="hy"//亚美尼亚语
        const val AZ="az"//阿塞拜疆语
        const val EU="eu"//巴斯克语
        const val BE="be"//白俄罗斯语
        const val BN="bn"//孟加拉语
        const val BS="bs"//波斯尼亚语
        const val BG="bg"//保加利亚语
        const val CA="ca"//加泰罗尼亚语
        const val CEB="ceb"//宿务语
        const val ZH_CN="zh"//中文
        const val ZH_TW="zh-TW"//中文繁体
        const val CO="co"//科西嘉语
        const val HR="hr"//克罗地亚语
        const val CS="cs"//捷克语
        const val DA="da"//丹麦语
        const val NL="nl"//荷兰语
        const val EN="en"//英语
        const val EO="eo"//世界语
        const val ET="et"//爱沙尼亚语
        const val FI="fi"//芬兰语
        const val FR="fr"//法语
        const val FY="fy"//西弗里西亚语
        const val GL="gl"//加利西亚语
        const val KA="ka"//格鲁吉亚语
        const val DE="de"//德语
        const val EL="el"//希腊语
        const val GU="gu"//古吉拉特语
        const val HT="ht"//海地克里奥尔语
        const val HA="ha"//豪萨语
        const val HAW="haw"//夏威夷语
        const val HE="he"//希伯来语
        const val HI="hi"//印地语
        const val HMN="hmn"//苗语
        const val HU="hu"//匈牙利语
        const val IS="is"//冰岛语
        const val IG="ig"//伊博语
        const val ID="id"//印度尼西亚语
        const val GA="ga"//爱尔兰语
        const val IT="it"//意大利语
        const val JA="ja"//日语
        const val JV="jv"//爪哇语
        const val KN="kn"//卡纳达语
        const val KK="kk"//哈萨克语
        const val KM="km"//高棉语
        const val RW="rw"//卢旺达语
        const val KO="ko"//韩语
        const val KU="ku"//库尔德语
        const val KY="ky"//柯尔克孜语
        const val LO="lo"//老挝语
        const val LA="la"//拉丁语
        const val LV="lv"//拉脱维亚语
        const val LT="lt"//立陶宛语
        const val LB="lb"//卢森堡语
        const val MK="mk"//马其顿语
        const val MG="mg"//马拉加斯语
        const val MS="ms"//马来语
        const val ML="ml"//马拉雅拉姆语
        const val MT="mt"//马耳他语
        const val MI="mi"//毛利语
        const val MR="mr"//马拉地语
        const val MN="mn"//蒙古语
        const val MY="my"//缅甸语
        const val NE="ne"//尼泊尔语
        const val NO="no"//挪威语
        const val NY="ny"//齐切瓦语
        const val OR="or"//奥里亚语
        const val PS="ps"//普什图语
        const val FA="fa"//波斯语
        const val PL="pl"//波兰语
        const val PT="pt"//葡萄牙语
        const val PA="pa"//旁遮普语
        const val RO="ro"//罗马尼亚语
        const val RU="ru"//俄语
        const val SM="sm"//萨摩亚语
        const val GD="gd"//苏格兰盖尔语
        const val SR="sr"//塞尔维亚语
        const val ST="st"//南索托语
        const val SN="sn"//绍纳语
        const val SD="sd"//信德语
        const val SI="si"//僧伽罗语
        const val SK="sk"//斯洛伐克语
        const val SL="sl"//斯洛文尼亚语
        const val SO="so"//索马里语
        const val ES="es"//西班牙语
        const val SU="su"//巽他语
        const val SW="sw"//斯瓦希里语
        const val SV="sv"//瑞典语
        const val TL="tl"//他加禄语（菲律宾语）
        const val FIL = "fil" //他加禄语
        const val TG="tg"//塔吉克语
        const val TA="ta"//泰米尔语
        const val TT="tt"//鞑靼语
        const val TE="te"//泰卢固语
        const val TH="th"//泰语
        const val TR="tr"//土耳其语
        const val TK="tk"//土库曼语
        const val UK="uk"//乌克兰语
        const val UR="ur"//乌尔都语
        const val UG="ug"//维吾尔语
        const val UZ="uz"//乌兹别克语
        const val VI="vi"//越南语
        const val CY="cy"//威尔士语
        const val XH="xh"//科萨语
        const val YI="yi"//意第绪语
        const val YO="yo"//约鲁巴语
        const val ZU="zu"//祖鲁语
    }


    /*Android Locale Language list End*/
}


/**
 * Locale to LANG
 */
private fun languageTagToLang(languageTag: String): String? {
    return languageTagToLangMap()[languageTag]
}

fun languageTagToLangMap(): HashMap<String, String> {
    return hashMapOf<String, String>().apply {

        this["af"] = LANG.AF//南非荷兰语
        this["sq"] = LANG.SQ//阿尔巴尼亚语
        this["am"] = LANG.AM//阿姆哈拉语
        this["ar"] = LANG.AR//阿拉伯语
        this["hy"] = LANG.HY//亚美尼亚语
        this["az"] = LANG.AZ//阿塞拜疆语
        this["eu"] = LANG.EU//巴斯克语
        this["be"] = LANG.BE//白俄罗斯语
        this["bn"] = LANG.BN//孟加拉语
        this["bs"] = LANG.BS//波斯尼亚语
        this["bg"] = LANG.BG//保加利亚语
        this["ca"] = LANG.CA//加泰罗尼亚语
        this["ceb"] = LANG.CEB//宿务语
        this["zh"] = LANG.ZH_CN//中文
        this["co"] = LANG.CO//科西嘉语
        this["hr"] = LANG.HR//克罗地亚语
        this["cs"] = LANG.CS//捷克语
        this["da"] = LANG.DA//丹麦语
        this["nl"] = LANG.NL//荷兰语
        this["en"] = LANG.EN//英语
        this["eo"] = LANG.EO//世界语
        this["et"] = LANG.ET//爱沙尼亚语
        this["fi"] = LANG.FI//芬兰语
        this["fr"] = LANG.FR//法语
        this["fy"] = LANG.FY//西弗里西亚语
        this["gl"] = LANG.GL//加利西亚语
        this["ka"] = LANG.KA//格鲁吉亚语
        this["de"] = LANG.DE//德语
        this["el"] = LANG.EL//希腊语
        this["gu"] = LANG.GU//古吉拉特语
        this["ht"] = LANG.HT//海地克里奥尔语
        this["ha"] = LANG.HA//豪萨语
        this["haw"] = LANG.HAW//夏威夷语
        this["he"] = LANG.HE//希伯来语
        this["hi"] = LANG.HI//印地语
        this["hmn"] = LANG.HMN//苗语
        this["hu"] = LANG.HU//匈牙利语
        this["is"] = LANG.IS//冰岛语
        this["ig"] = LANG.IG//伊博语
        this["id"] = LANG.ID//印度尼西亚语
        this["ga"] = LANG.GA//爱尔兰语
        this["it"] = LANG.IT//意大利语
        this["ja"] = LANG.JA//日语
        this["jv"] = LANG.JV//爪哇语
        this["kn"] = LANG.KN//卡纳达语
        this["kk"] = LANG.KK//哈萨克语
        this["km"] = LANG.KM//高棉语
        this["rw"] = LANG.RW//卢旺达语
        this["ko"] = LANG.KO//韩语
        this["ku"] = LANG.KU//库尔德语
        this["ky"] = LANG.KY//柯尔克孜语
        this["lo"] = LANG.LO//老挝语
        this["la"] = LANG.LA//拉丁语
        this["lv"] = LANG.LV//拉脱维亚语
        this["lt"] = LANG.LT//立陶宛语
        this["lb"] = LANG.LB//卢森堡语
        this["mk"] = LANG.MK//马其顿语
        this["mg"] = LANG.MG//马拉加斯语
        this["ms"] = LANG.MS//马来语
        this["ml"] = LANG.ML//马拉雅拉姆语
        this["mt"] = LANG.MT//马耳他语
        this["mi"] = LANG.MI//毛利语
        this["mr"] = LANG.MR//马拉地语
        this["mn"] = LANG.MN//蒙古语
        this["my"] = LANG.MY//缅甸语
        this["ne"] = LANG.NE//尼泊尔语
        this["no"] = LANG.NO//挪威语
        this["ny"] = LANG.NY//齐切瓦语
        this["or"] = LANG.OR//奥里亚语
        this["ps"] = LANG.PS//普什图语
        this["fa"] = LANG.FA//波斯语
        this["pl"] = LANG.PL//波兰语
        this["pt"] = LANG.PT//葡萄牙语
        this["pa"] = LANG.PA//旁遮普语
        this["ro"] = LANG.RO//罗马尼亚语
        this["ru"] = LANG.RU//俄语
        this["sm"] = LANG.SM//萨摩亚语
        this["gd"] = LANG.GD//苏格兰盖尔语
        this["sr"] = LANG.SR//塞尔维亚语
        this["st"] = LANG.ST//南索托语
        this["sn"] = LANG.SN//绍纳语
        this["sd"] = LANG.SD//信德语
        this["si"] = LANG.SI//僧伽罗语
        this["sk"] = LANG.SK//斯洛伐克语
        this["sl"] = LANG.SL//斯洛文尼亚语
        this["so"] = LANG.SO//索马里语
        this["es"] = LANG.ES//西班牙语
        this["su"] = LANG.SU//巽他语
        this["sw"] = LANG.SW//斯瓦希里语
        this["sv"] = LANG.SV//瑞典语
        this["tl"] = LANG.TL//他加禄语
        this["fil"] = LANG.TL //他加禄语
        this["tg"] = LANG.TG//塔吉克语
        this["ta"] = LANG.TA//泰米尔语
        this["tt"] = LANG.TT//鞑靼语
        this["te"] = LANG.TE//泰卢固语
        this["th"] = LANG.TH//泰语
        this["tr"] = LANG.TR//土耳其语
        this["tk"] = LANG.TK//土库曼语
        this["uk"] = LANG.UK//乌克兰语
        this["ur"] = LANG.UR//乌尔都语
        this["ug"] = LANG.UG//维吾尔语
        this["uz"] = LANG.UZ//乌兹别克语
        this["vi"] = LANG.VI//越南语
        this["cy"] = LANG.CY//威尔士语
        this["xh"] = LANG.XH//科萨语
        this["yi"] = LANG.YI//意第绪语
        this["yo"] = LANG.YO//约鲁巴语
        this["zu"] = LANG.ZU//祖鲁语
    }
}

//
///**
// * Locale to LANG
// */
//fun localeLanguageToLang(language: String) = languageToLang[language]

///**
// * google code to lang
// */
//fun googleCodeToLang(code: String): String? {
//
//    /**
//     * 通过谷歌翻译语言code，返回LANG
//     */
//    val googleLangMap = mapOf(
//        //"" to LANG.AUTO
//        "auto" to LANG.AUTO
//        , "en" to LANG.EN
//        , "hi" to LANG.HI
//        , "bn" to LANG.BN
//        , "te" to LANG.TE
//        , "mr" to LANG.MR
//        , "ta" to LANG.TA
//        , "ur" to LANG.UR
//        , "kn" to LANG.KN
//        , "gu" to LANG.GU
//        , "ml" to LANG.ML
//        , "pa" to LANG.PA
//        , "zh-CN" to LANG.ZH_CN
//        , "es" to LANG.ES
//        , "ar" to LANG.AR
//        , "ms" to LANG.MS
//        , "pt" to LANG.PT
//        , "ru" to LANG.RU
//        , "fr" to LANG.FR
//        , "de" to LANG.DE
//        , "ha" to LANG.HA
//        , "ja" to LANG.JA
//        , "fa" to LANG.FA
//        , "sw" to LANG.SW
//        //, "jw" to LANG.JW
//        , "th" to LANG.TH
//        , "id" to LANG.IN
//        , "tr" to LANG.TR
//        , "ne" to LANG.NE
//        , "tl" to LANG.FIL
//        , "vi" to LANG.VI
//        , "ko" to LANG.KO
//        , "it" to LANG.IT
//        , "am" to LANG.AM
//        , "cs" to LANG.CS
//        , "hr" to LANG.HR
//        , "sv" to LANG.SV
//        , "nl" to LANG.NL
//        , "el" to LANG.EL
//        , "ro" to LANG.RO
//        , "pl" to LANG.PL
//        , "fi" to LANG.FI
//        , "hu" to LANG.HU
//        //, "iw" to LANG.IW
//        , "kk" to LANG.KK
//        , "km" to LANG.KM
//        , "ky" to LANG.KY
//        , "my" to LANG.MY
//        //, "no" to LANG.NB
//        , "ps" to LANG.PS
//        , "si" to LANG.SI
//        , "so" to LANG.SO
//        , "sq" to LANG.SQ
//        , "uk" to LANG.UK
//        , "da" to LANG.DA
//        , "yo" to LANG.YO
//
//    )
//
//    return googleLangMap[code]
//}
//
///**
// * microsoft code to lang
// */
//fun microsoftCodeToLang(code: String) = microsoftLangMap[code]
//
///**
// * baidu code to lang
// */
//fun baiduCodeToLang(code: String) = baiduLangMap[code]
//
///**
// * iciba code to lang
// */
//fun icibaCodeToLang(code: String) = icibaLangMap[code]
//
///**
// * tencent code to lang
// */
//fun tencentCodeToLang(code: String) = tencentLangMap[code]

///**
// * yandex code to lang
// */
//fun yandexCodeToLang(code: String) = yandexLangMap[code]

///**
// * youdao code to lang
// */
//fun youdaoCodeToLang(code: String) = youdaoLangMap[code]

//
///**
// * Locale.LanguageTag to LANG
// */
//val languageTagToLang by lazy {
//
//}

///**
// * Locale.Language to LANG
// */
//val languageToLang = hashMapOf<String, String>().apply {
//    //this["sbp"] = LANG.SBP//桑古语
//    //this["ksh"] = LANG.KSH//科隆语
//    //this["nyn"] = LANG.NYN//尼昂科勒语
//    this["ps"] = LANG.PS//普什图语
//    this["pt"] = LANG.PT//葡萄牙语
//    //this["luo"] = LANG.LUO//卢欧语
//    this["fil"] = LANG.FIL//菲律宾语
//    //this["mgh"] = LANG.MGH//马库阿语
//    //this["ccp"] = LANG.CCP//ccp
//    //this["luy"] = LANG.LUY//卢雅语
//    //this["mgo"] = LANG.MGO//梅塔语
//    //this["bas"] = LANG.BAS//巴萨语
//    //this["teo"] = LANG.TEO//特索语
//    //this["qu"] = LANG.QU//克丘亚语
//    this["af"] = LANG.AF//南非荷兰语
//    //this["brx"] = LANG.BRX//博多语
//    //this["ak"] = LANG.AK//阿肯语
//    this["am"] = LANG.AM//阿姆哈拉语
//    //this["kde"] = LANG.KDE//马孔德语
//    this["ar"] = LANG.AR//阿拉伯语
//    //this["as"] = LANG.AS//阿萨姆语
//    this["az"] = LANG.AZ//阿塞拜疆语
//    //this["rm"] = LANG.RM//罗曼什语
//    //this["rn"] = LANG.RN//隆迪语
//    this["ro"] = LANG.RO//罗马尼亚语
//    this["be"] = LANG.BE//白俄罗斯语
//    this["ru"] = LANG.RU//俄语
//    this["bg"] = LANG.BG//保加利亚语
//    //this["rw"] = LANG.RW//卢旺达语
//    //this["kea"] = LANG.KEA//卡布佛得鲁语
//    //this["bm"] = LANG.BM//班巴拉语
//    this["bn"] = LANG.BN//孟加拉语
//    //this["bo"] = LANG.BO//藏语
//    //this["twq"] = LANG.TWQ//北桑海语
//    //this["br"] = LANG.BR//布列塔尼语
//    this["bs"] = LANG.BS//波斯尼亚语
//    //this["xog"] = LANG.XOG//索加语
//    //this["se"] = LANG.SE//北方萨米语
//    //this["sg"] = LANG.SG//桑戈语
//    this["si"] = LANG.SI//僧伽罗语
//    //this["seh"] = LANG.SEH//塞纳语
//    this["sk"] = LANG.SK//斯洛伐克语
//    this["sl"] = LANG.SL//斯洛文尼亚语
//    this["sn"] = LANG.SN//绍纳语
//    this["so"] = LANG.SO//索马里语
//    this["ca"] = LANG.CA//加泰罗尼亚语
//    this["sq"] = LANG.SQ//阿尔巴尼亚语
//    this["sr"] = LANG.SR//塞尔维亚语
//    //this["mzn"] = LANG.MZN//马赞德兰语
//    //this["ses"] = LANG.SES//东桑海语
//    //this["ce"] = LANG.CE//车臣语
//    this["sv"] = LANG.SV//瑞典语
//    this["sw"] = LANG.SW//斯瓦希里语
//    this["ta"] = LANG.TA//泰米尔语
//    //this["asa"] = LANG.ASA//帕雷语
//    //this["yav"] = LANG.YAV//洋卞语
//    this["cs"] = LANG.CS//捷克语
//    this["te"] = LANG.TE//泰卢固语
//    this["tg"] = LANG.TG//塔吉克语
//    this["th"] = LANG.TH//泰语
//    //this["ti"] = LANG.TI//提格利尼亚语
//    this["cy"] = LANG.CY//威尔士语
//    //this["tk"] = LANG.TK//土库曼语
//    //this["dyo"] = LANG.DYO//朱拉语
//    this["to"] = LANG.TO//汤加语
//    this["da"] = LANG.DA//丹麦语
//    this["tr"] = LANG.TR//土耳其语
//    //this["tt"] = LANG.TT//鞑靼语
//    this["de"] = LANG.DE//德语
//    //this["cgg"] = LANG.CGG//奇加语
//    //this["ast"] = LANG.AST//阿斯图里亚斯语
//    //this["nmg"] = LANG.NMG//夸西奥语
//    //this["bem"] = LANG.BEM//本巴语
//    //this["ug"] = LANG.UG//维吾尔语
//    //this["bez"] = LANG.BEZ//贝纳语
//    //this["dz"] = LANG.DZ//宗卡语
//    this["uk"] = LANG.UK//乌克兰语
//    this["ur"] = LANG.UR//乌尔都语
//    //this["dje"] = LANG.DJE//哲尔马语
//    this["haw"] = LANG.HAW//夏威夷语
//    //this["ee"] = LANG.EE//埃维语
//    this["uz"] = LANG.UZ//乌兹别克语
//    //this["tzm"] = LANG.TZM//塔马齐格特语
//    this["el"] = LANG.EL//希腊语
//    this["en"] = LANG.EN//英语
//    //this["nnh"] = LANG.NNH//恩甘澎语
//    this["eo"] = LANG.EO//世界语
//    //this["chr"] = LANG.CHR//切罗基语
//    this["es"] = LANG.ES//西班牙语
//    this["et"] = LANG.ET//爱沙尼亚语
//    this["eu"] = LANG.EU//巴斯克语
//    this["vi"] = LANG.VI//越南语
//    //this["khq"] = LANG.KHQ//西桑海语
//    //this["shi"] = LANG.SHI//希尔哈语
//    //this["hsb"] = LANG.HSB//上索布语
//    this["fa"] = LANG.FA//波斯语
//    //this["ff"] = LANG.FF//富拉语
//    this["fi"] = LANG.FI//芬兰语
//    //this["rwk"] = LANG.RWK//罗瓦语
//    //this["yue"] = LANG.YUE//粤语
//    //this["fo"] = LANG.FO//法罗语
//    this["fr"] = LANG.FR//法语
//    this["fy"] = LANG.FY//西弗里西亚语
//    //this["jgo"] = LANG.JGO//恩艮巴语
//    //this["lkt"] = LANG.LKT//拉科塔语
//    //this["wo"] = LANG.WO//沃洛夫语
//    this["ga"] = LANG.GA//爱尔兰语
//    //this["wae"] = LANG.WAE//瓦尔瑟语
//    //this["zgh"] = LANG.ZGH//标准摩洛哥塔马塞特语
//    this["gd"] = LANG.GD//苏格兰盖尔语
//    this["gl"] = LANG.GL//加利西亚语
//    this["gu"] = LANG.GU//古吉拉特语
//    //this["gv"] = LANG.GV//马恩语
//    this["xh"] = LANG.XH//科萨语
//    this["ha"] = LANG.HA//豪萨语
//    //this["ckb"] = LANG.CKB//中库尔德语
//    this["hi"] = LANG.HI//印地语
//    //this["agq"] = LANG.AGQ//亚罕语
//    //this["gsw"] = LANG.GSW//瑞士德语
//    this["hr"] = LANG.HR//克罗地亚语
//    //this["kkj"] = LANG.KKJ//卡库语
//    this["hu"] = LANG.HU//匈牙利语
//    this["hy"] = LANG.HY//亚美尼亚语
//    this["yo"] = LANG.YO//约鲁巴语
//    this["ig"] = LANG.IG//伊博语
//    //this["naq"] = LANG.NAQ//纳马语
//    //this["vai"] = LANG.VAI//瓦伊语
//    //this["ii"] = LANG.II//四川彝语
//    //this["in"] = LANG.IN//印度尼西亚语
//    this["is"] = LANG.IS//冰岛语
//    this["it"] = LANG.IT//意大利语
//    //this["kln"] = LANG.KLN//卡伦金语
//    this["iw"] = LANG.IW//希伯来语
//    this["zh"] = LANG.ZH_CN//中文
//    this["ja"] = LANG.JA//日语
//    this["zu"] = LANG.ZU//祖鲁语
//    //this["ji"] = LANG.JI//意第绪语
//    //this["guz"] = LANG.GUZ//古西语
//    //this["smn"] = LANG.SMN//伊纳里萨米语
//    this["ka"] = LANG.KA//格鲁吉亚语
//    //this["ki"] = LANG.KI//吉库尤语
//    //this["mas"] = LANG.MAS//马赛语
//    this["kk"] = LANG.KK//哈萨克语
//    //this["kl"] = LANG.KL//格陵兰语
//    this["km"] = LANG.KM//高棉语
//    this["kn"] = LANG.KN//卡纳达语
//    this["ko"] = LANG.KO//韩语
//    //this["ks"] = LANG.KS//克什米尔语
//    //this["kw"] = LANG.KW//康沃尔语
//    this["ky"] = LANG.KY//柯尔克孜语
//    this["lb"] = LANG.LB//卢森堡语
//    //this["ebu"] = LANG.EBU//恩布语
//    //this["lg"] = LANG.LG//卢干达语
//    //this["nds"] = LANG.NDS//低地德语
//    //this["jmc"] = LANG.JMC//马切姆语
//    //this["fur"] = LANG.FUR//弗留利语
//    //this["ln"] = LANG.LN//林加拉语
//    this["lo"] = LANG.LO//老挝语
//    //this["kok"] = LANG.KOK//孔卡尼语
//    this["lt"] = LANG.LT//立陶宛语
//    //this["lu"] = LANG.LU//鲁巴加丹加语
//    this["lv"] = LANG.LV//拉脱维亚语
//    //this["nus"] = LANG.NUS//努埃尔语
//    //this["vun"] = LANG.VUN//温旧语
//    //this["lag"] = LANG.LAG//朗吉语
//    //this["dav"] = LANG.DAV//台塔语
//    this["mg"] = LANG.MG//马拉加斯语
//    //this["lrc"] = LANG.LRC//北卢尔语
//    this["mk"] = LANG.MK//马其顿语
//    this["ml"] = LANG.ML//马拉雅拉姆语
//    this["mn"] = LANG.MN//蒙古语
//    this["mr"] = LANG.MR//马拉地语
//    this["ms"] = LANG.MS//马来语
//    this["mt"] = LANG.MT//马耳他语
//    this["my"] = LANG.MY//缅甸语
//    //this["dsb"] = LANG.DSB//下索布语
//    //this["nb"] = LANG.NB//书面挪威语
//    //this["nd"] = LANG.ND//北恩德贝勒语
//    this["ne"] = LANG.NE//尼泊尔语
//    //this["mua"] = LANG.MUA//蒙当语
//    this["nl"] = LANG.NL//荷兰语
//    //this["nn"] = LANG.NN//挪威尼诺斯克语
//    //this["rof"] = LANG.ROF//兰博语
//    //this["kab"] = LANG.KAB//卡拜尔语
//    //this["kam"] = LANG.KAM//卡姆巴语
//    //this["mer"] = LANG.MER//梅鲁语
//    //this["sah"] = LANG.SAH//萨哈语
//    //this["om"] = LANG.OM//奥罗莫语
//    //this["saq"] = LANG.SAQ//桑布鲁语
//    //this["or"] = LANG.OR//奥里亚语
//    //this["os"] = LANG.OS//奥塞梯语
//    //this["mfe"] = LANG.MFE//毛里求斯克里奥尔语
//    //this["dua"] = LANG.DUA//都阿拉语
//    this["pa"] = LANG.PA//旁遮普语
//    //this["ksb"] = LANG.KSB//香巴拉语
//    //this["ewo"] = LANG.EWO//旺杜语
//    this["pl"] = LANG.PL//波兰语
//    //this["ksf"] = LANG.KSF//巴菲亚语
//
//
//}

///**
// * 微软语言映射
// */
//val microsoftLangMap = mapOf(
//    "auto-detect" to LANG.AUTO
//    , "af" to LANG.AF
//    , "ar" to LANG.AR
//    , "bg" to LANG.BG
//    , "bn" to LANG.BN
//    , "bs" to LANG.BS
//    , "ca" to LANG.CA
//    , "cs" to LANG.CS
//    , "cy" to LANG.CY
//    , "da" to LANG.DA
//    , "de" to LANG.DE
//    , "el" to LANG.EL
//    , "en" to LANG.EN
//    , "es" to LANG.ES
//    , "et" to LANG.ET
//    , "fa" to LANG.FA
//    , "fi" to LANG.FI
//    , "fil" to LANG.FIL
//    //, "fj" to LANG.FJ
//    , "fr" to LANG.FR
//    //, "he" to LANG.HE
//    , "hi" to LANG.HI
//    , "hr" to LANG.HR
//    , "ht" to LANG.FR
//    , "hu" to LANG.HU
//    , "id" to LANG.IN
//    , "is" to LANG.IS
//    , "it" to LANG.IT
//    , "ja" to LANG.JA
//    , "ko" to LANG.KO
//    , "lt" to LANG.LT
//    , "lv" to LANG.LV
//    , "mg" to LANG.MG
//    , "ms" to LANG.MS
//    , "mt" to LANG.MT
//    //, "mww" to LANG.HMN
//    , "nb" to LANG.NB
//    , "nl" to LANG.NL
//    //, "otq" to LANG.OTQ
//    , "pl" to LANG.PL
//    , "pt" to LANG.PT
//    , "ro" to LANG.RO
//    , "ru" to LANG.RU
//    , "sk" to LANG.SK
//    , "sl" to LANG.SL
//    //, "sm" to LANG.SM
//    , "sr-Cyrl" to LANG.SR
//    , "sr-Latn" to LANG.SR
//    , "sv" to LANG.SV
//    , "sw" to LANG.SW
//    , "ta" to LANG.TA
//    , "te" to LANG.TE
//    , "th" to LANG.TH
//    //, "tlh" to LANG.FILH
//    , "to" to LANG.TO
//    , "tr" to LANG.TR
//    //, "ty" to LANG.TY
//    , "uk" to LANG.UK
//    , "ur" to LANG.UR
//    , "vi" to LANG.VI
//    //, "yua" to LANG.YUA
//    //, "yue" to LANG.YUE
//    , "zh-Hans" to LANG.ZH_CN
//    , "zh-Hant" to LANG.ZH_TW
//)

///**
// * 百度语言映射
// */
//val baiduLangMap = mapOf(
//    "auto" to LANG.AUTO,
//    "zh" to LANG.ZH_CN,
//    "en" to LANG.EN,
//    "kor" to LANG.KO,
//    "fra" to LANG.FR,
//    "ru" to LANG.RU,
//    "de" to LANG.DE,
//    "ara" to LANG.AR,
//    "spa" to LANG.ES,
//    "bul" to LANG.BG,
//    "pl" to LANG.PL,
//    "dan" to LANG.DA,
//    "fin" to LANG.FI,
//    "nl" to LANG.NL,
//    "cs" to LANG.CS,
//    "rom" to LANG.RO,
//    "pt" to LANG.PT,
//    "jp" to LANG.JA,
//    "swe" to LANG.SW,
//    "slo" to LANG.SL,
//    "th" to LANG.TH,
//    "el" to LANG.EL,
//    "hu" to LANG.HU,
//    "it" to LANG.IT,
//    "vie" to LANG.VI,
//    "cht" to LANG.ZH_TW
//)
//
//val icibaLangMap = mapOf(
//    "auto" to LANG.AUTO,
//    "zh" to LANG.ZH_CN,
//    "en" to LANG.EN,
//    "ja" to LANG.JA,
//    "ko" to LANG.KO,
//    "fr" to LANG.FR,
//    "de" to LANG.DE
//)
//
//val tencentLangMap = mapOf(
//    "auto" to LANG.AUTO,
//    "zh" to LANG.ZH_CN,
//    "en" to LANG.EN,
//    "jp" to LANG.JA,
//    "kr" to LANG.KO,
//    "fr" to LANG.FR,
//    "ru" to LANG.RU,
//    "de" to LANG.DE,
//    "es" to LANG.ES,
//    "it" to LANG.IT,
//    "tr" to LANG.TR,
//    "pt" to LANG.PT,
//    "vi" to LANG.VI,
//    "id" to LANG.IN,
//    "ms" to LANG.MS,
//    "th" to LANG.TH
//)
//
//val yandexLangMap = mapOf(
//    "auto" to LANG.AUTO,
//    "az" to LANG.AZ,
//    "ml" to LANG.ML,
//    "sq" to LANG.SQ,
//    "mt" to LANG.MT,
//    "am" to LANG.AM,
//    "mk" to LANG.MK,
//    "en" to LANG.EN,
//    //"mi" to LANG.MI,
//    "ar" to LANG.AR,
//    "mr" to LANG.MR,
//    "hy" to LANG.HY,
//    "af" to LANG.AF,
//    "mn" to LANG.MN,
//    "eu" to LANG.EU,
//    "de" to LANG.DE,
//    "ne" to LANG.NE,
//    "be" to LANG.BE,
//    "no" to LANG.NB,
//    "bn" to LANG.BN,
//    "pa" to LANG.PA,
//    "my" to LANG.MY,
//    "bg" to LANG.BG,
//    "fa" to LANG.FA,
//    "bs" to LANG.BS,
//    "pl" to LANG.PL,
//    "cy" to LANG.CY,
//    "pt" to LANG.PT,
//    "hu" to LANG.HU,
//    "ro" to LANG.RO,
//    "vi" to LANG.VI,
//    "ru" to LANG.RU,
//    "ht" to LANG.FR,
//    //"ceb" to LANG.CEB,
//    "gl" to LANG.GL,
//    "sr" to LANG.SR,
//    "nl" to LANG.NL,
//    "si" to LANG.SI,
//    "sk" to LANG.SK,
//    "el" to LANG.EL,
//    "sl" to LANG.SL,
//    "ka" to LANG.KA,
//    "sw" to LANG.SW,
//    "gu" to LANG.GU,
//    //"su" to LANG.SU,
//    "da" to LANG.DA,
//    "tg" to LANG.TG,
//    //"he" to LANG.HE,
//    "th" to LANG.TH,
//    //"yi" to LANG.YI,
//    "tl" to LANG.FIL,
//    //"id" to LANG.IN,
//    "ta" to LANG.TA,
//    "ga" to LANG.GA,
//    "it" to LANG.IT,
//    "te" to LANG.TE,
//    "is" to LANG.IS,
//    "tr" to LANG.TR,
//    "es" to LANG.ES,
//    "kk" to LANG.KK,
//    "uz" to LANG.UZ,
//    "kn" to LANG.KN,
//    "uk" to LANG.UK,
//    "ca" to LANG.CA,
//    "ur" to LANG.UR,
//    "ky" to LANG.KY,
//    "fi" to LANG.FI,
//    "zh" to LANG.ZH_CN,
//    "fr" to LANG.FR,
//    "ko" to LANG.KO,
//    "hi" to LANG.HI,
//    "xh" to LANG.XH,
//    "hr" to LANG.HR,
//    "km" to LANG.KM,
//    "cs" to LANG.CS,
//    "lo" to LANG.LO,
//    "sv" to LANG.SV,
//    "la" to LANG.LO,
//    "gd" to LANG.GD,
//    "lv" to LANG.LV,
//    "et" to LANG.ET,
//    "lt" to LANG.LT,
//    "eo" to LANG.EO,
//    "lb" to LANG.LB,
//    //"jv" to LANG.JW,
//    "mg" to LANG.MG,
//    "ja" to LANG.JA,
//    "ms" to LANG.MS
//)
////
//val youdaoLangMap = mapOf(
//    "auto" to LANG.AUTO,
//    "zh-CHS" to LANG.ZH_CN,
//    "en" to LANG.EN,
//    "ja" to LANG.JA,
//    "ko" to LANG.KO,
//    "fr" to LANG.FR,
//    "ru" to LANG.RU,
//    "de" to LANG.DE,
//    "es" to LANG.ES,
//    "pt" to LANG.PT,
//    "vi" to LANG.VI,
//    "id" to LANG.IN,
//    "ar" to LANG.AR
//)

fun main() {
    val langMap = mutableMapOf<String, String>()
    langMap[LANG.AUTO] = "auto"
    langMap[LANG.ZH_CN] = "zh-CHS"
    langMap[LANG.EN] = "en"
    langMap[LANG.JA] = "ja"
    langMap[LANG.KO] = "ko"
    langMap[LANG.FR] = "fr"
    langMap[LANG.RU] = "ru"
    langMap[LANG.DE] = "de"
    langMap[LANG.ES] = "es"
    langMap[LANG.PT] = "pt"
    langMap[LANG.VI] = "vi"
    langMap[LANG.ID] = "id"
    langMap[LANG.AR] = "ar"

    val sb = StringBuilder()
    for ((key, value) in langMap) {
        sb.append("\"$value\"").append(" to ").append("LANG.$key").append(',').append('\n')
    }
    println(sb)
}
