package com.talpa.translator.link

import android.content.Context
import androidx.annotation.Keep
import com.talpa.tengine.Trans
import com.talpa.tengine.translateByOSCTranslator
import com.talpa.translate.HiTranslator
import com.talpa.translate.MultiTextTranslator
import io.reactivex.Flowable

/**
 *
 * Translate Link 链接翻译引擎中间件
 *
 * @author CY 2020/4/14
 */

var DEBUG = false

fun setDebug(bebug: Boolean) {
    DEBUG = bebug
}

/**
 * Translate
 */
@Keep
fun Context.translate(trans: Trans): Flowable<Trans> {

    //Offline -> Free -> Server -> Charge
    /*return translateByOFSCTranslator(trans) {
        setServerAppKey(getServerAppKey())
        setServerAppSecret(getServerAppSecret())
        setGoogleKey(getGoogleKey())
        setMicrosoftKey(getMicrosoftKey())
        isDownloadModelIfNeeded(isDownloadModelIfNeeded = false)
        isEnabledOfflineTranslate(isEnabledOfflineTranslate = true)//isEnabledOfflineTranslate()
        isEnabledYandex(applicationContext.isEnabledYandex())
    }*/
    //Server -> Charge
    /*return translateBySCTranslator(trans) {
        setServerAppKey(getServerAppKey())
        setServerAppSecret(getServerAppSecret())
        setGoogleKey(getGoogleKey())
        setMicrosoftKey(getMicrosoftKey())
        //isDownloadModelIfNeeded(isDownloadModelIfNeeded = false)
        //isEnabledOfflineTranslate(isEnabledOfflineTranslate = isEnabledOfflineTranslate())
        //isEnabledYandex(isEnabledYandex())
    }*/
    //Offline -> Server -> Charge
    return translateByOSCTranslator(trans) {
        setServerAppKey(getServerAppKey())
        setServerAppSecret(getServerAppSecret())
        setGoogleKey(getGoogleKey())
        setMicrosoftKey(getMicrosoftKey())
        isDownloadModelIfNeeded(isDownloadModelIfNeeded = false)
        isEnabledOfflineTranslate(isEnabledOfflineTranslate = true)//isEnabledOfflineTranslate()
    }
}

//@Keep
//suspend fun Context.mergeTranslate(multiTrans: MultiTextTrans): MultiTextTrans {
//
//}

@Keep
suspend fun Context.multiTranslate(multiTrans: MultiTextTrans): MultiTextTrans {


    //val appKey = "e292400433a4" //getServerAppKey()
    //val appSecret = "1e98215f-929b-7cd9-9c20-4c523d4b493b" //getServerAppSecret()//
    //val appKey = "e962487c7a9a" //getServerAppKey()
    //val appSecret = "1d326d19-0b72-eed3-df57-5b7a9155bcd4" //getServerAppSecret()
    val appKey = getServerAppKey()
    val appSecret = getServerAppSecret()

    //key=e962487c7a9a   secret=1d326d19-0b72-eed3-df57-5b7a9155bcd4
    return if (appKey == null || appSecret == null) {

        multiTrans.apply {
            result =
                MultiTextTranslator.Result(
                    sourceLanguage = multiTrans.sourceLanguage,
                    targetLanguage = multiTrans.targetLanguage,
                    texts = multiTrans.sourceTexts,
                    valueCode = -1,
                    valueMessage = "appKey is null or appSecret is null"
                )
        }
        //Result.failure(Exception("appKey is null or appSecret is null"))
    } else {
        val transResult = try {
            val (sourceTexts, sourceLanguage, targetLanguage, obj) = multiTrans
            MultiTextTranslator.Builder()
                .setAppKey(appKey)
                .setSecret(appSecret)
                .setSourceLanguage(sourceLanguage)
                .setTargetLanguage(targetLanguage)
                .setTexts(sourceTexts)
                .build()
                .execute()

        } catch (e: Exception) {
            e.printStackTrace()
            //Result.failure<MultiTextTrans>(e)
            MultiTextTranslator.Result(
                sourceLanguage = multiTrans.sourceLanguage,
                targetLanguage = multiTrans.targetLanguage,
                texts = multiTrans.sourceTexts,
                valueCode = -1,
                valueMessage = e.message
            )
        }
        multiTrans.apply {
            this.result = transResult
        }

    }

}

@Keep
data class MultiTextTrans(
    val sourceTexts: ArrayList<String>,
    val sourceLanguage: String,
    val targetLanguage: String,
    val obj: Any? = null
) {
    var result: MultiTextTranslator.Result? = null
}

//data class MultiTransResult(val result: Result)