/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.conversation;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.conversation.ConversationKey;
import com.tencent.imsdk.conversation.ConversationListener;
import com.tencent.imsdk.conversation.ConversationResult;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.DraftMessage;
import java.util.List;

public class ConversationManager {
    private static final String TAG = "ConversationManager";
    private ConversationListener mInternalConversationListener;
    private ConversationListener mConversationListener;

    public static ConversationManager getInstance() {
        return ConversationManagerHolder.conversationManager;
    }

    public void init() {
        this.initInternalConversationListener();
    }

    private void initInternalConversationListener() {
        if (this.mInternalConversationListener == null) {
            this.mInternalConversationListener = new ConversationListener(){

                @Override
                public void onSyncServerStart() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerStart();
                            }
                        }
                    });
                }

                @Override
                public void onSyncServerFinish() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerFinish();
                            }
                        }
                    });
                }

                @Override
                public void onSyncServerFailed() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerFailed();
                            }
                        }
                    });
                }

                @Override
                public void onNewConversation(final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onNewConversation(conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationChanged(final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationChanged(conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onTotalUnreadMessageCountChanged(final long totalUnreadCount) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onTotalUnreadMessageCountChanged(totalUnreadCount);
                            }
                        }
                    });
                }
            };
        }
        this.nativeSetConversationListener(this.mInternalConversationListener);
    }

    public void setConversationListener(ConversationListener conversationListener) {
        this.mConversationListener = conversationListener;
    }

    public void getConversationList(long nextSeq, int count, IMCallback<ConversationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationList(nextSeq, count, callback);
    }

    public void getConversationList(List<ConversationKey> conversationKeyList, IMCallback<List<Conversation>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversations(conversationKeyList, callback);
    }

    public void getConversationInfo(ConversationKey conversationKey, IMCallback<Conversation> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationInfo(conversationKey, callback);
    }

    public void deleteConversation(ConversationKey conversationKey, boolean clearCloudMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteConversation(conversationKey, clearCloudMessage, callback);
    }

    public void setConversationDraft(ConversationKey conversationKey, DraftMessage draftMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetConversationDraft(conversationKey, draftMessage, callback);
    }

    public void pinConversation(ConversationKey conversationKey, boolean isPinned, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativePinConversation(conversationKey, isPinned, callback);
    }

    public void getTotalUnreadMessageCount(IMCallback<Long> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetTotalUnreadMessageCount(callback);
    }

    protected native void nativeSetConversationListener(ConversationListener var1);

    protected native void nativeGetConversationList(long var1, int var3, IMCallback var4);

    protected native void nativeGetConversations(List<ConversationKey> var1, IMCallback var2);

    protected native void nativeGetConversationInfo(ConversationKey var1, IMCallback var2);

    protected native void nativeDeleteConversation(ConversationKey var1, boolean var2, IMCallback var3);

    protected native void nativeSetConversationDraft(ConversationKey var1, DraftMessage var2, IMCallback var3);

    protected native void nativePinConversation(ConversationKey var1, boolean var2, IMCallback var3);

    protected native void nativeGetTotalUnreadMessageCount(IMCallback var1);

    private static class ConversationManagerHolder {
        private static final ConversationManager conversationManager = new ConversationManager();

        private ConversationManagerHolder() {
        }
    }
}

