/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.group;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.group.GroupApplication;
import com.tencent.imsdk.group.GroupApplicationResult;
import com.tencent.imsdk.group.GroupInfo;
import com.tencent.imsdk.group.GroupInfoChangeItem;
import com.tencent.imsdk.group.GroupInfoGetResult;
import com.tencent.imsdk.group.GroupInfoModifyParam;
import com.tencent.imsdk.group.GroupListener;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.group.GroupMemberInfoChangeItem;
import com.tencent.imsdk.group.GroupMemberInfoModifyParam;
import com.tencent.imsdk.group.GroupMemberInfoResult;
import com.tencent.imsdk.group.GroupMemberOperationResult;
import com.tencent.imsdk.group.GroupMemberSearchParam;
import com.tencent.imsdk.group.GroupSearchParam;
import com.tencent.imsdk.manager.BaseManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupManager {
    private GroupListener mGroupInternalListener;
    private GroupListener mGroupListener;

    public static GroupManager getInstance() {
        return GroupManagerHolder.groupManager;
    }

    public void init() {
        this.initGroupListener();
    }

    private void initGroupListener() {
        if (this.mGroupInternalListener == null) {
            this.mGroupInternalListener = new GroupListener(){

                @Override
                public void onMemberEnter(final String groupID, final List<GroupMemberInfo> memberList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onMemberEnter(groupID, memberList);
                            }
                        }
                    });
                }

                @Override
                public void onMemberLeave(final String groupID, final GroupMemberInfo member) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onMemberLeave(groupID, member);
                            }
                        }
                    });
                }

                @Override
                public void onMemberInvited(final String groupID, final GroupMemberInfo opUser, final List<GroupMemberInfo> memberList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onMemberInvited(groupID, opUser, memberList);
                            }
                        }
                    });
                }

                @Override
                public void onMemberKicked(final String groupID, final GroupMemberInfo opUser, final List<GroupMemberInfo> memberList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onMemberKicked(groupID, opUser, memberList);
                            }
                        }
                    });
                }

                @Override
                public void onMemberInfoChanged(final String groupID, final List<GroupMemberInfoChangeItem> v2TIMGroupMemberChangeInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onMemberInfoChanged(groupID, v2TIMGroupMemberChangeInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onGroupCreated(final String groupID) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onGroupCreated(groupID);
                            }
                        }
                    });
                }

                @Override
                public void onGroupDismissed(final String groupID, final GroupMemberInfo opUser) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onGroupDismissed(groupID, opUser);
                            }
                        }
                    });
                }

                @Override
                public void onGroupRecycled(final String groupID, final GroupMemberInfo opUser) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onGroupRecycled(groupID, opUser);
                            }
                        }
                    });
                }

                @Override
                public void onGroupInfoChanged(final String groupID, final List<GroupInfoChangeItem> changeInfos) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onGroupInfoChanged(groupID, changeInfos);
                            }
                        }
                    });
                }

                @Override
                public void onReceiveJoinApplication(final String groupID, final GroupMemberInfo member, final String opReason) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onReceiveJoinApplication(groupID, member, opReason);
                            }
                        }
                    });
                }

                @Override
                public void onApplicationProcessed(final String groupID, final GroupMemberInfo opUser, final boolean isAgreeJoin, final String opReason) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onApplicationProcessed(groupID, opUser, isAgreeJoin, opReason);
                            }
                        }
                    });
                }

                @Override
                public void onGrantAdministrator(final String groupID, final GroupMemberInfo opUser, final List<GroupMemberInfo> memberList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onGrantAdministrator(groupID, opUser, memberList);
                            }
                        }
                    });
                }

                @Override
                public void onRevokeAdministrator(final String groupID, final GroupMemberInfo opUser, final List<GroupMemberInfo> memberList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onRevokeAdministrator(groupID, opUser, memberList);
                            }
                        }
                    });
                }

                @Override
                public void onQuitFromGroup(final String groupID) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onQuitFromGroup(groupID);
                            }
                        }
                    });
                }

                @Override
                public void onReceiveRESTCustomData(final String groupID, final byte[] customData) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onReceiveRESTCustomData(groupID, customData);
                            }
                        }
                    });
                }

                @Override
                public void onGroupAttributeChanged(final String groupID, final Map<String, String> groupAttributeMap) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (GroupManager.this.mGroupListener != null) {
                                GroupManager.this.mGroupListener.onGroupAttributeChanged(groupID, groupAttributeMap);
                            }
                        }
                    });
                }
            };
        }
        this.nativeSetGroupListener(this.mGroupInternalListener);
    }

    public void setGroupListener(GroupListener listener) {
        this.mGroupListener = listener;
    }

    public void createGroup(String groupType, String groupID, String groupName, IMCallback<String> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        GroupInfo groupInfo = new GroupInfo();
        groupInfo.setGroupID(groupID);
        groupInfo.setGroupType(groupType);
        groupInfo.setGroupName(groupName);
        this.nativeCreateGroup(groupInfo, null, callback);
    }

    public void createGroup(GroupInfo info, List<GroupMemberInfo> memberList, IMCallback<String> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCreateGroup(info, memberList, callback);
    }

    public void joinGroup(String groupID, String message, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeJoinGroup(groupID, message, callback);
    }

    public void quitGroup(String groupID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeQuitGroup(groupID, callback);
    }

    public void dismissGroup(String groupID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDismissGroup(groupID, callback);
    }

    public void getJoinedGroupList(IMCallback<List<GroupInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetJoinedGroupList(callback);
    }

    public void getGroupsInfo(List<String> groupIDList, IMCallback<List<GroupInfoGetResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupsInfo(groupIDList, callback);
    }

    public void searchGroups(GroupSearchParam param, IMCallback<List<GroupInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSearchGroups(param, callback);
    }

    public void setGroupInfo(GroupInfoModifyParam param, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetGroupInfo(param, callback);
    }

    public void setGroupReceiveMessageOpt(String groupID, int opt, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetGroupMessageReceiveOption(groupID, opt, callback);
    }

    public void initGroupAttributes(String groupID, HashMap<String, String> attributes, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeInitGroupAttributes(groupID, attributes, callback);
    }

    public void setGroupAttributes(String groupID, HashMap<String, String> attributes, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeUpdateGroupAttributes(groupID, attributes, callback);
    }

    public void deleteGroupAttributes(String groupID, List<String> keys, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteGroupAttributes(groupID, keys, callback);
    }

    public void getGroupAttributes(String groupID, List<String> keys, IMCallback<Map<String, String>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupAttributes(groupID, keys, callback);
    }

    public void getGroupOnlineMemberCount(String groupID, IMCallback<Integer> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupOnlineMemberCount(groupID, callback);
    }

    public void getGroupMemberList(String groupID, int filter, long nextSeq, IMCallback<GroupMemberInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupMemberList(groupID, filter, nextSeq, callback);
    }

    public void getGroupMembersInfo(String groupID, List<String> memberList, IMCallback<List<GroupMemberInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupMembersInfo(groupID, memberList, callback);
    }

    public void setGroupMemberInfo(GroupMemberInfoModifyParam param, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetGroupMemberInfo(param, callback);
    }

    public void searchGroupMembersInfo(GroupMemberSearchParam groupMemberSearchParam, IMCallback<HashMap<String, List<GroupMemberInfo>>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSearchGroupMembersInfo(groupMemberSearchParam, callback);
    }

    public void muteGroupMember(String groupID, String userID, int seconds, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeMuteGroupMember(groupID, userID, seconds, callback);
    }

    public void inviteUserToGroup(String groupID, List<String> userList, IMCallback<List<GroupMemberOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeInviteGroupMembers(groupID, userList, "", callback);
    }

    public void kickGroupMember(String groupID, List<String> memberList, String reason, IMCallback<List<GroupMemberOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteGroupMembers(groupID, memberList, reason, callback);
    }

    public void setGroupMemberRole(String groupID, String userID, int role, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetGroupMemberRole(groupID, userID, role, callback);
    }

    public void transferGroupOwner(String groupID, String userID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetGroupOwner(groupID, userID, callback);
    }

    public void getGroupApplicationList(IMCallback<GroupApplicationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupApplicationList(callback);
    }

    public void acceptGroupApplication(GroupApplication application, String reason, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        application.setResponseType(GroupApplication.RESPONSE_TYPE_AGREE);
        application.setResponseMessage(reason);
        this.nativeResponseGroupApplication(application, callback);
    }

    public void refuseGroupApplication(GroupApplication application, String reason, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        application.setResponseType(GroupApplication.RESPONSE_TYPE_REFUSE);
        application.setResponseMessage(reason);
        this.nativeResponseGroupApplication(application, callback);
    }

    public void setGroupApplicationRead(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetGroupApplicationListRead(callback);
    }

    protected native void nativeSetGroupListener(GroupListener var1);

    protected native void nativeCreateGroup(GroupInfo var1, List<GroupMemberInfo> var2, IMCallback<String> var3);

    protected native void nativeJoinGroup(String var1, String var2, IMCallback var3);

    protected native void nativeQuitGroup(String var1, IMCallback var2);

    protected native void nativeDismissGroup(String var1, IMCallback var2);

    protected native void nativeInviteGroupMembers(String var1, List<String> var2, String var3, IMCallback var4);

    protected native void nativeDeleteGroupMembers(String var1, List<String> var2, String var3, IMCallback var4);

    protected native void nativeGetJoinedGroupList(IMCallback var1);

    protected native void nativeGetGroupsInfo(List<String> var1, IMCallback var2);

    protected native void nativeSearchGroups(GroupSearchParam var1, IMCallback var2);

    protected native void nativeSetGroupInfo(GroupInfoModifyParam var1, IMCallback var2);

    protected native void nativeSetGroupOwner(String var1, String var2, IMCallback var3);

    protected native void nativeGetGroupMemberList(String var1, int var2, long var3, IMCallback var5);

    protected native void nativeGetGroupMembersInfo(String var1, List<String> var2, IMCallback var3);

    protected native void nativeSetGroupMemberInfo(GroupMemberInfoModifyParam var1, IMCallback var2);

    protected native void nativeSearchGroupMembersInfo(GroupMemberSearchParam var1, IMCallback var2);

    protected native void nativeSetGroupMemberRole(String var1, String var2, int var3, IMCallback var4);

    protected native void nativeMuteGroupMember(String var1, String var2, int var3, IMCallback var4);

    protected native void nativeSetGroupMessageReceiveOption(String var1, int var2, IMCallback var3);

    protected native void nativeGetGroupApplicationList(IMCallback var1);

    protected native void nativeSetGroupApplicationListRead(IMCallback var1);

    protected native void nativeResponseGroupApplication(GroupApplication var1, IMCallback var2);

    protected native void nativeInitGroupAttributes(String var1, Map<String, String> var2, IMCallback var3);

    protected native void nativeUpdateGroupAttributes(String var1, Map<String, String> var2, IMCallback var3);

    protected native void nativeDeleteGroupAttributes(String var1, List<String> var2, IMCallback var3);

    protected native void nativeGetGroupAttributes(String var1, List<String> var2, IMCallback var3);

    protected native void nativeGetGroupOnlineMemberCount(String var1, IMCallback var2);

    private static class GroupManagerHolder {
        private static final GroupManager groupManager = new GroupManager();

        private GroupManagerHolder() {
        }
    }
}

