/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.common.NetworkInfoCenter;
import com.tencent.imsdk.common.SystemUtil;
import com.tencent.imsdk.conversation.ConversationManager;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.manager.CustomServerInfo;
import com.tencent.imsdk.manager.SDKConfig;
import com.tencent.imsdk.manager.SDKListener;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.relationship.RelationshipManager;
import com.tencent.imsdk.relationship.UserInfo;
import java.lang.ref.WeakReference;

public class BaseManager
implements NetworkInfoCenter.INetworkChangeListener {
    private static final String TAG = BaseManager.class.getSimpleName();
    private SDKConfig.NetworkInfo mLastNetworkInfo = new SDKConfig.NetworkInfo();
    private WeakReference<SDKListener> sdkListenerWeakReference;
    private static boolean mLoadLibrarySuccess = false;
    private boolean isInit = false;
    private boolean isTestEnvironment = false;

    public static BaseManager getInstance() {
        return BaseManagerHolder.baseManager;
    }

    public boolean initSDK(Context context, SDKConfig sdkConfig, boolean needLogCallback, SDKListener listener) {
        if (!mLoadLibrarySuccess) {
            IMLog.e(TAG, "libimsdk.so is not loaded");
            return false;
        }
        if (sdkConfig.sdkAppId <= 0L) {
            IMLog.e(TAG, "invalid sdkAppID:" + sdkConfig.sdkAppId);
            return false;
        }
        if (null == context) {
            IMLog.e(TAG, "null context");
            return false;
        }
        if (this.isInit) {
            IMLog.w(TAG, "Has initSDK");
            return true;
        }
        String sdkVersion = this.nativeGetSDKVersion();
        String buglySdkAppID = "ebfa608d4d";
        SharedPreferences settings = context.getSharedPreferences("BuglySdkInfos", 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(buglySdkAppID, sdkVersion);
        editor.commit();
        IMContext.getInstance().init(context.getApplicationContext());
        NetworkInfoCenter.getInstance().init(context.getApplicationContext(), this);
        MessageCenter.getInstance().init();
        GroupManager.getInstance().init();
        ConversationManager.getInstance().init();
        RelationshipManager.getInstance().init();
        sdkConfig.sdkInitPath = SystemUtil.getSDKInitPath();
        sdkConfig.sdkInstanceType = SystemUtil.getInstanceType();
        sdkConfig.testEnvironment = this.isTestEnvironment;
        sdkConfig.deviceInfo.deviceType = SystemUtil.getDeviceType();
        sdkConfig.deviceInfo.deviceId = SystemUtil.getDeviceID();
        sdkConfig.deviceInfo.deviceBrand = SystemUtil.getInstanceType();
        sdkConfig.deviceInfo.systemVersion = SystemUtil.getSystemVersion();
        sdkConfig.networkInfo.networkType = NetworkInfoCenter.getInstance().getNetworkType();
        sdkConfig.networkInfo.ipType = NetworkInfoCenter.getInstance().getIPType();
        sdkConfig.networkInfo.networkId = NetworkInfoCenter.getInstance().getNetworkID();
        sdkConfig.networkInfo.networkConnected = NetworkInfoCenter.getInstance().isNetworkConnected();
        sdkConfig.logSetting.enableConsoleLog = true;
        sdkConfig.logSetting.logFilePath = SystemUtil.getSDKLogPath();
        sdkConfig.uiPlatform = this.getUIPlatform();
        this.mLastNetworkInfo = sdkConfig.networkInfo;
        this.nativeInitSDK(sdkConfig, needLogCallback, listener);
        this.sdkListenerWeakReference = new WeakReference<SDKListener>(listener);
        this.isInit = true;
        return true;
    }

    public void unInitSDK() {
        this.nativeUninitSDK();
        this.isInit = false;
        this.isTestEnvironment = false;
        this.mLastNetworkInfo.clean();
    }

    private String getUIPlatform() {
        boolean has_tuikit = this.isTUIKit();
        boolean has_flutter = this.isFlutter();
        boolean has_unity = this.isUnity();
        if (has_flutter) {
            if (has_tuikit) {
                return "tuikit&flutter";
            }
            return "flutter";
        }
        if (has_unity) {
            if (has_tuikit) {
                return "tuikit&unity";
            }
            return "unity";
        }
        if (has_tuikit) {
            return "tuikit";
        }
        return "";
    }

    private boolean isTUIKit() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tim.uikit.TUIKit");
            if (c != null) {
                return true;
            }
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            String callName = "";
            for (int i = 0; i < stacks.length; ++i) {
                callName = stacks[i].getClassName();
                if (!callName.contains("TUIKitImpl")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isFlutter() {
        try {
            Class<?> c = Class.forName("com.qq.qcloud.tencent_im_sdk_plugin.tencent_im_sdk_plugin");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isUnity() {
        try {
            Class<?> c = Class.forName("com.qcloud.tencentimsdk.TencentImSDKPluginUnity");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void login(String userID, String userSig, IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeLogin(userID, userSig, callback);
    }

    public void logout(IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeLogout(callback);
    }

    public boolean setLibraryPath(String libraryPath) {
        mLoadLibrarySuccess = SystemUtil.loadIMLibrary(libraryPath);
        return mLoadLibrarySuccess;
    }

    public void setTestEnvironment(boolean testEnvironment) {
        this.isTestEnvironment = testEnvironment;
    }

    public void setCustomServerInfo(CustomServerInfo customServerInfo) {
        this.nativeSetCustomServerInfo(customServerInfo);
    }

    public String getLoginUser() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return null;
        }
        return this.nativeGetLoginUser();
    }

    public int getLoginStatus() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0;
        }
        return this.nativeGetLoginStatus();
    }

    public String getVersion() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return null;
        }
        return this.nativeGetSDKVersion();
    }

    public boolean isInited() {
        return this.isInit;
    }

    public long getClockTickInHz() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetClockTickInHz();
    }

    public long getTimeTick() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetTimeTick();
    }

    public long getServerTime() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetServerTime();
    }

    public void initLocalStorage(String userID, IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeInitLocalStorage(userID, callback);
    }

    @Override
    public void onNetworkChange(boolean connected, int networkType, int ipType, String networkID) {
        if (connected == this.mLastNetworkInfo.networkConnected && networkType == this.mLastNetworkInfo.networkType && ipType == this.mLastNetworkInfo.ipType && null != networkID && networkID.equals(this.mLastNetworkInfo.networkId)) {
            Log.w((String)TAG, (String)"onNetworkChange, networkinfo is same");
            return;
        }
        this.mLastNetworkInfo.networkConnected = connected;
        this.mLastNetworkInfo.networkType = networkType;
        this.mLastNetworkInfo.ipType = ipType;
        this.mLastNetworkInfo.networkId = networkID;
        this.nativeNotifyNetworkChange(connected, networkType, ipType, networkID);
    }

    public void notifySelfInfoUpdated(UserInfo selfInfo) {
        SDKListener listener;
        if (this.sdkListenerWeakReference != null && (listener = (SDKListener)this.sdkListenerWeakReference.get()) != null) {
            listener.onSelfInfoUpdated(selfInfo);
        }
    }

    protected native void nativeInitSDK(SDKConfig var1, boolean var2, SDKListener var3);

    protected native void nativeUninitSDK();

    protected native void nativeNotifyNetworkChange(boolean var1, int var2, int var3, String var4);

    protected native void nativeLogin(String var1, String var2, IMCallback var3);

    protected native void nativeLogout(IMCallback var1);

    protected native void nativeSetCustomServerInfo(CustomServerInfo var1);

    protected native String nativeGetLoginUser();

    protected native int nativeGetLoginStatus();

    protected native String nativeGetSDKVersion();

    protected native long nativeGetClockTickInHz();

    protected native long nativeGetTimeTick();

    protected native long nativeGetServerTime();

    protected native void nativeInitLocalStorage(String var1, IMCallback var2);

    static {
        try {
            mLoadLibrarySuccess = SystemUtil.loadIMLibrary();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    private static class BaseManagerHolder {
        private static final BaseManager baseManager = new BaseManager();

        private BaseManagerHolder() {
        }
    }
}

