/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.conversation.ConversationKey;
import com.tencent.imsdk.conversation.ConversationListener;
import com.tencent.imsdk.conversation.ConversationManager;
import com.tencent.imsdk.conversation.ConversationResult;
import com.tencent.imsdk.message.DraftMessage;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMConversation;
import com.tencent.imsdk.v2.V2TIMConversationListener;
import com.tencent.imsdk.v2.V2TIMConversationManager;
import com.tencent.imsdk.v2.V2TIMConversationResult;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.List;

public class V2TIMConversationManagerImpl
extends V2TIMConversationManager {
    private ConversationListener mConversationListener;
    private V2TIMConversationListener mV2TIMConversationListener;

    static V2TIMConversationManagerImpl getInstance() {
        return V2TIMConversationManagerImplHolder.v2TIMConversationManagerImpl;
    }

    private V2TIMConversationManagerImpl() {
        this.initListener();
    }

    private void initListener() {
        if (this.mConversationListener == null) {
            this.mConversationListener = new ConversationListener(){

                @Override
                public void onSyncServerStart() {
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener == null) {
                        return;
                    }
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener != null) {
                        V2TIMConversationManagerImpl.this.mV2TIMConversationListener.onSyncServerStart();
                    }
                }

                @Override
                public void onSyncServerFinish() {
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener == null) {
                        return;
                    }
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener != null) {
                        V2TIMConversationManagerImpl.this.mV2TIMConversationListener.onSyncServerFinish();
                    }
                }

                @Override
                public void onSyncServerFailed() {
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener == null) {
                        return;
                    }
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener != null) {
                        V2TIMConversationManagerImpl.this.mV2TIMConversationListener.onSyncServerFailed();
                    }
                }

                @Override
                public void onNewConversation(List<Conversation> conversationList) {
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener == null) {
                        return;
                    }
                    ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                    for (Conversation conversation : conversationList) {
                        V2TIMConversation v2TIMConversation = new V2TIMConversation();
                        v2TIMConversation.setConversation(conversation);
                        v2TIMConversationList.add(v2TIMConversation);
                    }
                    V2TIMConversationManagerImpl.this.mV2TIMConversationListener.onNewConversation(v2TIMConversationList);
                }

                @Override
                public void onConversationChanged(List<Conversation> conversationList) {
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener == null) {
                        return;
                    }
                    ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                    for (Conversation conversation : conversationList) {
                        V2TIMConversation v2TIMConversation = new V2TIMConversation();
                        v2TIMConversation.setConversation(conversation);
                        v2TIMConversationList.add(v2TIMConversation);
                    }
                    V2TIMConversationManagerImpl.this.mV2TIMConversationListener.onConversationChanged(v2TIMConversationList);
                }

                @Override
                public void onTotalUnreadMessageCountChanged(long totalUnreadCount) {
                    if (V2TIMConversationManagerImpl.this.mV2TIMConversationListener == null) {
                        return;
                    }
                    V2TIMConversationManagerImpl.this.mV2TIMConversationListener.onTotalUnreadMessageCountChanged(totalUnreadCount);
                }
            };
        }
        ConversationManager.getInstance().setConversationListener(this.mConversationListener);
    }

    @Override
    public void setConversationListener(V2TIMConversationListener listener) {
        this.mV2TIMConversationListener = listener;
    }

    @Override
    public void getConversationList(long nextSeq, int count, final V2TIMValueCallback<V2TIMConversationResult> callback) {
        V2TIMValueCallback<ConversationResult> v2callback = new V2TIMValueCallback<ConversationResult>(){

            @Override
            public void onSuccess(ConversationResult conversationResult) {
                if (callback != null) {
                    V2TIMConversationResult v2TIMConversationResult = new V2TIMConversationResult();
                    v2TIMConversationResult.setConversationResult(conversationResult);
                    callback.onSuccess(v2TIMConversationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationList(nextSeq, count, new IMCallback<ConversationResult>((V2TIMValueCallback)v2callback){

            @Override
            public void success(ConversationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getConversationList(List<String> conversationIDList, final V2TIMValueCallback<List<V2TIMConversation>> callback) {
        if (conversationIDList == null || conversationIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "conversationIDList cannot be empty");
            }
            return;
        }
        ArrayList<ConversationKey> conversationKeyList = new ArrayList<ConversationKey>();
        for (String conversationID : conversationIDList) {
            ConversationKey conversationKey = this.getConversationKey(conversationID);
            conversationKeyList.add(conversationKey);
        }
        V2TIMValueCallback<List<Conversation>> v2callback = new V2TIMValueCallback<List<Conversation>>(){

            @Override
            public void onSuccess(List<Conversation> conversations) {
                ArrayList<V2TIMConversation> v2TIMConversationList = new ArrayList<V2TIMConversation>();
                for (Conversation conversation : conversations) {
                    V2TIMConversation v2TIMConversation = new V2TIMConversation();
                    v2TIMConversation.setConversation(conversation);
                    v2TIMConversationList.add(v2TIMConversation);
                }
                if (callback != null) {
                    callback.onSuccess(v2TIMConversationList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationList(conversationKeyList, new IMCallback<List<Conversation>>((V2TIMValueCallback)v2callback){

            @Override
            public void success(List<Conversation> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getConversation(String conversationID, final V2TIMValueCallback<V2TIMConversation> callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        V2TIMValueCallback<Conversation> v2TIMValueCallback = new V2TIMValueCallback<Conversation>(){

            @Override
            public void onSuccess(Conversation conversation) {
                if (callback != null) {
                    V2TIMConversation v2TIMConversation = new V2TIMConversation();
                    v2TIMConversation.setConversation(conversation);
                    callback.onSuccess(v2TIMConversation);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        ConversationManager.getInstance().getConversationInfo(conversationKey, new IMCallback<Conversation>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(Conversation data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteConversation(String conversationID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        ConversationManager.getInstance().deleteConversation(conversationKey, true, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setConversationDraft(String conversationID, String draftText, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        DraftMessage draftMessage = new DraftMessage();
        if (draftText != null) {
            draftMessage.setUserDefinedData(draftText.getBytes());
        }
        ConversationManager.getInstance().setConversationDraft(conversationKey, draftMessage, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void pinConversation(String conversationID, boolean isPinned, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)conversationID)) {
            if (callback != null) {
                callback.onError(6017, "conversationID is empty");
            }
            return;
        }
        ConversationKey conversationKey = this.getConversationKey(conversationID);
        ConversationManager.getInstance().pinConversation(conversationKey, isPinned, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getTotalUnreadMessageCount(V2TIMValueCallback<Long> callback) {
        ConversationManager.getInstance().getTotalUnreadMessageCount(new IMCallback<Long>(callback){

            @Override
            public void success(Long data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    protected ConversationKey getConversationKey(String conversationID) {
        ConversationKey conversationKey = new ConversationKey();
        String v1ConvID = "";
        int index = conversationID.indexOf("c2c_");
        if (index == 0) {
            v1ConvID = conversationID.substring("c2c_".length());
            conversationKey.setConversationType(1);
            conversationKey.setConversationID(v1ConvID);
        } else {
            index = conversationID.indexOf("group_");
            if (index == 0) {
                v1ConvID = conversationID.substring("group_".length());
                conversationKey.setConversationType(2);
                conversationKey.setConversationID(v1ConvID);
            }
        }
        return conversationKey;
    }

    private static class V2TIMConversationManagerImplHolder {
        private static final V2TIMConversationManagerImpl v2TIMConversationManagerImpl = new V2TIMConversationManagerImpl();

        private V2TIMConversationManagerImplHolder() {
        }
    }
}

