/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.message.DownloadParam;
import com.tencent.imsdk.message.DownloadProgressInfo;
import com.tencent.imsdk.message.ImageElement;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.List;

public class V2TIMImageElem
extends V2TIMElem {
    public static final int V2TIM_IMAGE_TYPE_ORIGIN = 0;
    public static final int V2TIM_IMAGE_TYPE_THUMB = 1;
    public static final int V2TIM_IMAGE_TYPE_LARGE = 2;
    private ImageElement timImageElem;

    public String getPath() {
        if (this.getElement() == null) {
            return null;
        }
        this.timImageElem = (ImageElement)this.getElement();
        return this.timImageElem.getOriginImageFilePath();
    }

    public List<V2TIMImage> getImageList() {
        if (this.getElement() == null) {
            return null;
        }
        this.timImageElem = (ImageElement)this.getElement();
        ArrayList<V2TIMImage> v2TIMImageList = new ArrayList<V2TIMImage>();
        V2TIMImage v2TIMOriginalImage = new V2TIMImage();
        v2TIMOriginalImage.setUUID(this.timImageElem.getOriginImageUUID());
        v2TIMOriginalImage.setType(0);
        v2TIMOriginalImage.setSize(this.timImageElem.getOriginImageFileSize());
        v2TIMOriginalImage.setWidth(this.timImageElem.getOriginImageWidth());
        v2TIMOriginalImage.setHeight(this.timImageElem.getOriginImageHeight());
        v2TIMOriginalImage.setUrl(this.timImageElem.getOriginImageUrl());
        v2TIMImageList.add(v2TIMOriginalImage);
        V2TIMImage v2TIMLargeImage = new V2TIMImage();
        v2TIMLargeImage.setUUID(this.timImageElem.getLargeImageUUID());
        v2TIMLargeImage.setType(2);
        v2TIMLargeImage.setSize(this.timImageElem.getLargeImageFileSize());
        v2TIMLargeImage.setWidth(this.timImageElem.getLargeImageWidth());
        v2TIMLargeImage.setHeight(this.timImageElem.getLargeImageHeight());
        v2TIMLargeImage.setUrl(this.timImageElem.getLargeImageUrl());
        v2TIMImageList.add(v2TIMLargeImage);
        V2TIMImage v2TIMThumbImage = new V2TIMImage();
        v2TIMThumbImage.setUUID(this.timImageElem.getThumbImageUUID());
        v2TIMThumbImage.setType(1);
        v2TIMThumbImage.setSize(this.timImageElem.getThumbImageFileSize());
        v2TIMThumbImage.setWidth(this.timImageElem.getThumbImageWidth());
        v2TIMThumbImage.setHeight(this.timImageElem.getThumbImageHeight());
        v2TIMThumbImage.setUrl(this.timImageElem.getThumbImageUrl());
        v2TIMImageList.add(v2TIMThumbImage);
        return v2TIMImageList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("V2TIMImageElem--->").append(", localPath=").append(this.getPath());
        List<V2TIMImage> v2TIMImageList = this.getImageList();
        for (V2TIMImage v2TIMImage : v2TIMImageList) {
            stringBuilder.append(", type:").append(v2TIMImage.getType()).append(", uuid:").append(v2TIMImage.getUUID()).append(", height:").append(v2TIMImage.getHeight()).append(", width:").append(v2TIMImage.getWidth()).append(", size:").append(v2TIMImage.getSize()).append(", url:" + v2TIMImage.getUrl());
        }
        return stringBuilder.toString();
    }

    public class V2TIMImage {
        private String uuid;
        private int type;
        private int size;
        private int width;
        private int height;
        private String url;

        public String getUUID() {
            return this.uuid;
        }

        protected void setUUID(String uuid) {
            this.uuid = uuid;
        }

        public int getType() {
            return this.type;
        }

        protected void setType(int type) {
            this.type = type;
        }

        public int getSize() {
            return this.size;
        }

        protected void setSize(int size) {
            this.size = size;
        }

        public int getWidth() {
            return this.width;
        }

        protected void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        protected void setHeight(int height) {
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        protected void setUrl(String url) {
            this.url = url;
        }

        public void downloadImage(String path, final V2TIMDownloadCallback v2TIMDownloadCallback) {
            DownloadParam downloadParam = new DownloadParam();
            downloadParam.setDownloadFlag(DownloadParam.DOWNLOAD_FLAG_REQUEST_DIRECT_DOWNLOAD);
            downloadParam.setDownloadUrl(this.url);
            downloadParam.setFileSavePath(path);
            V2TIMValueCallback<DownloadProgressInfo> v2TIMValueProgressCallback = new V2TIMValueCallback<DownloadProgressInfo>(){

                @Override
                public void onSuccess(DownloadProgressInfo downloadProgressInfo) {
                    V2TIMElem.V2ProgressInfo v2ProgressInfo = new V2TIMElem.V2ProgressInfo(downloadProgressInfo.getCurrentSize(), downloadProgressInfo.getTotalSize());
                    if (v2TIMDownloadCallback != null) {
                        v2TIMDownloadCallback.onProgress(v2ProgressInfo);
                    }
                }

                @Override
                public void onError(int code, String desc) {
                    if (v2TIMDownloadCallback != null) {
                        v2TIMDownloadCallback.onError(code, desc);
                    }
                }
            };
            V2TIMCallback v2TIMCallback = new V2TIMCallback(){

                @Override
                public void onSuccess() {
                    if (v2TIMDownloadCallback != null) {
                        v2TIMDownloadCallback.onSuccess();
                    }
                }

                @Override
                public void onError(int code, String desc) {
                    if (v2TIMDownloadCallback != null) {
                        v2TIMDownloadCallback.onError(code, desc);
                    }
                }
            };
            MessageCenter.getInstance().downloadMessageElement(downloadParam, new IMCallback<DownloadProgressInfo>((V2TIMValueCallback)v2TIMValueProgressCallback){

                @Override
                public void success(DownloadProgressInfo data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            }, new IMCallback(v2TIMCallback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
    }
}

