/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.common;

import android.text.TextUtils;
import android.util.Log;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.common.SystemUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpClient {
    private static final String TAG = HttpClient.class.getSimpleName();
    public static final int HTTP_ACTION_REQUEST = 0;
    public static final int HTTP_ACTION_RESPONSE = 1;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAX_POOL_SIZE = 2 * CPU_COUNT + 1;
    private static final long KEEP_ALIVE = 5L;
    private static final int PROXY_TYPE_HTTP = 1;
    private static final int PROXY_TYPE_SOCKS5 = 2;
    private static String mRollbackHttps2Http = "";
    private static boolean mNeedRollbackHttps2Http = false;
    private static final Executor mThreadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    private static native void nativeProgressCallback(int var0, int var1, int var2, long var3);

    private static native void nativeResponseCallback(int var0, String[] var1, String[] var2, byte[] var3, long var4);

    private static void httpRequest(final String method, final String url, final Map<String, String> headers, final byte[] content, final String uploadFile, final String downloadFile, final HttpRequestListener listener, final int proxyType, final String proxyHost, final int proxyPort, final String proxyUserName, final String proxyPassword, final int connectTimeout, final int recvTimeout, final String rollbackHttps2Http) {
        Runnable requestRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Could not resolve type clashes
             * Loose catch block
             */
            @Override
            public void run() {
                block46: {
                    byte[] response;
                    HashMap<String, String> rspHeaders;
                    int code;
                    InputStream responseInputStream;
                    HttpURLConnection conn;
                    block43: {
                        boolean hasDownloadFile;
                        int totalSize;
                        boolean hasOutput;
                        Object proxy;
                        conn = null;
                        responseInputStream = null;
                        code = 200;
                        rspHeaders = null;
                        response = null;
                        String requestUrl = url;
                        if (url.startsWith("https")) {
                            if (!mRollbackHttps2Http.equals(rollbackHttps2Http)) {
                                mRollbackHttps2Http = rollbackHttps2Http;
                                mNeedRollbackHttps2Http = HttpClient.needRollbackHttps2Http(rollbackHttps2Http);
                            }
                            if (mNeedRollbackHttps2Http) {
                                requestUrl = url.replaceFirst("https", "http");
                            }
                        }
                        if (1 == proxyType && !proxyHost.isEmpty() && proxyPort != 0) {
                            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                            conn = (HttpURLConnection)new URL(requestUrl).openConnection((Proxy)proxy);
                            if (!proxyUserName.isEmpty() && !proxyPassword.isEmpty()) {
                                Authenticator.setDefault(new BasicAuthenticator(proxyUserName, proxyPassword));
                            }
                        } else if (2 == proxyType && !proxyHost.isEmpty() && proxyPort != 0) {
                            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHost, proxyPort));
                            conn = (HttpURLConnection)new URL(requestUrl).openConnection((Proxy)proxy);
                            if (!proxyUserName.isEmpty() && !proxyPassword.isEmpty()) {
                                Authenticator.setDefault(new BasicAuthenticator(proxyUserName, proxyPassword));
                            }
                        } else {
                            conn = (HttpURLConnection)new URL(requestUrl).openConnection();
                        }
                        conn.setRequestMethod(method);
                        conn.setConnectTimeout(connectTimeout);
                        conn.setReadTimeout(recvTimeout);
                        conn.setUseCaches(false);
                        conn.setDoInput(true);
                        if (headers != null) {
                            for (Map.Entry entry : headers.entrySet()) {
                                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                        boolean hasContent = content != null && content.length > 0;
                        boolean hasUploadFile = uploadFile != null && uploadFile.length() != 0;
                        boolean bl = hasOutput = hasContent || hasUploadFile;
                        if (!method.equalsIgnoreCase("GET") && hasOutput) {
                            conn.setDoOutput(true);
                            InputStream inputStream = null;
                            inputStream = hasUploadFile ? new FileInputStream(uploadFile) : new ByteArrayInputStream(content);
                            if (inputStream != null) {
                                int len;
                                totalSize = inputStream.available();
                                conn.setFixedLengthStreamingMode(totalSize);
                                int bytesTransferred = 0;
                                byte[] buf = new byte[4096];
                                while ((len = inputStream.read(buf)) >= 0) {
                                    bytesTransferred += len;
                                    conn.getOutputStream().write(buf, 0, len);
                                    if (listener == null) continue;
                                    listener.onProgress(0, bytesTransferred, totalSize);
                                }
                                inputStream.close();
                            }
                        }
                        code = conn.getResponseCode();
                        int headerCount = conn.getHeaderFields().size();
                        if (headerCount > 0) {
                            rspHeaders = new HashMap<String, String>();
                            for (int i = 0; i < headerCount; ++i) {
                                rspHeaders.put(conn.getHeaderFieldKey(i), conn.getHeaderField(i));
                            }
                        }
                        if ((totalSize = conn.getContentLength()) == -1) {
                            totalSize = 0;
                        }
                        boolean bl2 = hasDownloadFile = downloadFile != null && downloadFile.length() != 0;
                        if (code == 200) {
                            responseInputStream = new BufferedInputStream(conn.getInputStream());
                            OutputStream outputStream = null;
                            outputStream = hasDownloadFile ? new FileOutputStream(downloadFile) : new ByteArrayOutputStream();
                            if (outputStream != null) {
                                int len;
                                int bytesReceived = 0;
                                byte[] buf = new byte[4096];
                                while ((len = responseInputStream.read(buf)) >= 0) {
                                    bytesReceived += len;
                                    outputStream.write(buf, 0, len);
                                    if (listener == null) continue;
                                    listener.onProgress(1, bytesReceived, totalSize);
                                }
                                response = hasDownloadFile ? new byte[]{} : ((ByteArrayOutputStream)outputStream).toByteArray();
                                outputStream.close();
                            }
                        }
                        if (responseInputStream == null) break block43;
                        try {
                            responseInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (listener != null) {
                        listener.onCompleted(code, rspHeaders, response);
                    }
                    break block46;
                    catch (UnknownHostException e) {
                        block44: {
                            IMLog.e(TAG, "http request failed." + e.getLocalizedMessage());
                            code = 404;
                            if (responseInputStream == null) break block44;
                            try {
                                responseInputStream.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (conn != null) {
                            conn.disconnect();
                        }
                        if (listener != null) {
                            listener.onCompleted(code, rspHeaders, response);
                        }
                    }
                    catch (Exception e2) {
                        block45: {
                            IMLog.e(TAG, "http request failed." + e2.getLocalizedMessage());
                            code = -1;
                            response = Log.getStackTraceString((Throwable)e2).getBytes();
                            if (responseInputStream == null) break block45;
                            {
                                catch (Throwable throwable) {
                                    if (responseInputStream != null) {
                                        try {
                                            responseInputStream.close();
                                        }
                                        catch (IOException e3) {
                                            e3.printStackTrace();
                                        }
                                    }
                                    if (conn != null) {
                                        conn.disconnect();
                                    }
                                    if (listener != null) {
                                        listener.onCompleted(code, rspHeaders, response);
                                    }
                                    throw throwable;
                                }
                            }
                            try {
                                responseInputStream.close();
                            }
                            catch (IOException e4) {
                                e4.printStackTrace();
                            }
                        }
                        if (conn != null) {
                            conn.disconnect();
                        }
                        if (listener != null) {
                            listener.onCompleted(code, rspHeaders, response);
                        }
                    }
                }
            }
        };
        mThreadPoolExecutor.execute(requestRunnable);
    }

    private static void httpRequest(String method, String url, String[] headerKeys, String[] headerValues, byte[] content, String uploadFile, String downloadFile, final long progressCallback, final long responseCallback, int proxyType, String proxyHost, int proxyPort, String proxyUserName, String proxyPassword, int connectTimeout, int recvTimeout, String rollbackHttps2Http) {
        HashMap<String, String> headers = null;
        if (headerKeys != null && headerValues != null && headerKeys.length == headerValues.length) {
            headers = new HashMap<String, String>();
            for (int i = 0; i < headerKeys.length; ++i) {
                headers.put(headerKeys[i], headerValues[i]);
            }
        }
        HttpClient.httpRequest(method, url, headers, content, uploadFile, downloadFile, new HttpRequestListener(){

            @Override
            public void onProgress(int action, int currentSize, int totalSize) {
                if (progressCallback != 0L) {
                    HttpClient.nativeProgressCallback(action, currentSize, totalSize, progressCallback);
                }
            }

            @Override
            public void onCompleted(int code, Map<String, String> headers, byte[] response) {
                if (responseCallback != 0L) {
                    String[] rspHeaderKeys = null;
                    String[] rspHeaderValues = null;
                    if (headers != null) {
                        rspHeaderKeys = new String[headers.size()];
                        rspHeaderValues = new String[headers.size()];
                        int i = 0;
                        for (Map.Entry<String, String> entry : headers.entrySet()) {
                            rspHeaderKeys[i] = entry.getKey();
                            rspHeaderValues[i] = entry.getValue();
                            ++i;
                        }
                    }
                    HttpClient.nativeResponseCallback(code, rspHeaderKeys, rspHeaderValues, response, responseCallback);
                }
            }
        }, proxyType, proxyHost, proxyPort, proxyUserName, proxyPassword, connectTimeout, recvTimeout, rollbackHttps2Http);
    }

    private static boolean needRollbackHttps2Http(String rollbackHttps2Http) {
        boolean result = false;
        if (TextUtils.isEmpty((CharSequence)rollbackHttps2Http)) {
            return result;
        }
        try {
            JSONArray rollbackHttps2HttpJsonArray = new JSONArray(rollbackHttps2Http);
            String brand = "";
            if (SystemUtil.isBrandOppo()) {
                brand = "oppo";
            } else if (SystemUtil.isBrandVivo()) {
                brand = "vivo";
            } else if (SystemUtil.isBrandHuawei()) {
                brand = "huawei";
            } else if (SystemUtil.isBrandXiaoMi()) {
                brand = "xiaomi";
            } else if (SystemUtil.isBrandMeizu()) {
                brand = "meizu";
            }
            for (int i = 0; i < rollbackHttps2HttpJsonArray.length(); ++i) {
                JSONObject brandObject = rollbackHttps2HttpJsonArray.getJSONObject(i);
                String brandConfig = brandObject.getString("brand");
                int below_version = brandObject.getInt("below_version");
                if (!brand.equals(brandConfig)) continue;
                int androidVersion = SystemUtil.getSDKVersion();
                if (androidVersion <= below_version) {
                    result = true;
                }
                break;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    static class BasicAuthenticator
    extends Authenticator {
        private String userName = "";
        private String password = "";

        public BasicAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }

    public static interface HttpRequestListener {
        public void onProgress(int var1, int var2, int var3);

        public void onCompleted(int var1, Map<String, String> var2, byte[] var3);
    }
}

