/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.common;

import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMValueCallback;

public abstract class IMCallback<T> {
    protected V2TIMCallback callback;
    protected V2TIMValueCallback<T> valueCallback;

    protected IMCallback(V2TIMCallback cb) {
        this.callback = cb;
    }

    protected IMCallback(V2TIMValueCallback<T> cb) {
        this.valueCallback = cb;
    }

    public void success(final T data) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (IMCallback.this.callback != null) {
                    IMCallback.this.callback.onSuccess();
                } else if (IMCallback.this.valueCallback != null) {
                    IMCallback.this.valueCallback.onSuccess(data);
                }
            }
        });
    }

    public void fail(final int code, final String errorMessage) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (IMCallback.this.callback != null) {
                    IMCallback.this.callback.onError(code, errorMessage);
                } else if (IMCallback.this.valueCallback != null) {
                    IMCallback.this.valueCallback.onError(code, errorMessage);
                }
            }
        });
    }

    public void fail(final int code, final String errorMessage, T data) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (IMCallback.this.callback != null) {
                    IMCallback.this.callback.onError(code, errorMessage);
                } else if (IMCallback.this.valueCallback != null) {
                    IMCallback.this.valueCallback.onError(code, errorMessage);
                }
            }
        });
    }
}

